/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.data;

import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WaitData
extends FragilityData {
    private int ticks;

    public WaitData(double breakSpeed) {
        super(breakSpeed);
    }

    @Override
    public FragilityData.FragileBehaviour getBehaviour() {
        return FragilityData.FragileBehaviour.WAIT;
    }

    @Override
    public void parseExtraData(@Nullable BlockState state, ConfigLoader cl, String[] extraData) throws FragilityData.FragilityDataParseException {
        int ticks;
        this.lengthCheck(extraData, 1);
        try {
            ticks = Integer.parseInt(extraData[0]);
        }
        catch (NumberFormatException nfe) {
            throw new FragilityData.FragilityDataParseException(extraData[0] + "must be an integer larger than 0.");
        }
        this.ticks = Math.max(ticks, 1);
    }

    @Override
    public void onCrash(World world, BlockState state, @Nullable TileEntity te, BlockPos pos, @Nullable Entity crasher, double speedSq) {
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " ");
        sb.append(this.ticks);
        return sb.toString();
    }

    public int getTicks() {
        return this.ticks;
    }
}

