/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.config.behaviour.datamanager;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import com.fredtargaryen.fragileglass.config.behaviour.configloader.ConfigLoader;
import com.fredtargaryen.fragileglass.config.behaviour.data.FragilityData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;

public abstract class DataManager<E, D> {
    protected File configDir;
    protected File configFile;
    private String typeString;
    protected HashMap<E, D> data = new HashMap();

    protected DataManager(String typeString) {
        this.typeString = typeString;
    }

    public final void clearData() {
        this.data.clear();
    }

    public final void export(String filecontents) throws IOException {
        LocalDateTime now = LocalDateTime.now();
        FileWriter fw = new FileWriter(new File(this.configDir, "fragileglassft_" + this.typeString + "_" + now.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME).replace(':', '-') + ".cfg"));
        fw.write("@This config data was exported via a Fragile Glass and Thin Ice command on " + now.format(DateTimeFormatter.ISO_LOCAL_DATE) + " at " + now.format(DateTimeFormatter.ISO_LOCAL_TIME) + ".\n\n");
        fw.write(filecontents);
        fw.close();
    }

    public final D getData(E key) {
        return this.data.get(key);
    }

    public Stream<E> getKeys() {
        return this.data.keySet().stream();
    }

    protected abstract String[] getDefaultConfigFileText();

    private void handleConfigFileException(Exception e) {
        FragileGlassBase.warn("Could not load fragileglassft_" + this.typeString + ".cfg! Default behaviour will be loaded. No custom data will take effect.");
        e.printStackTrace();
        this.loadDefaultData();
    }

    public final boolean hasData() {
        return !this.data.isEmpty();
    }

    public abstract boolean loadData();

    protected boolean loadDataFromConfigDir(ConfigLoader cl) {
        boolean ok = true;
        try {
            File[] fileList = this.configDir.listFiles();
            if (fileList != null) {
                String fileName = this.configFile.getName();
                System.out.println("Found file " + fileName + "; now loading");
                BufferedReader br = new BufferedReader(new FileReader(this.configFile));
                ok &= cl.loadFile(br, this.configDir, fileName);
                br.close();
                for (File file : fileList) {
                    fileName = file.getName();
                    String[] fileNameParts = fileName.split("_");
                    if (fileNameParts.length != 3 || !fileNameParts[0].equals("fragileglassft") || !fileNameParts[1].equals(this.typeString)) continue;
                    System.out.println("Found file " + fileName + "; now loading");
                    br = new BufferedReader(new FileReader(file));
                    ok &= cl.loadFile(br, this.configDir, fileName);
                    br.close();
                }
            }
            return ok;
        }
        catch (IOException ioe) {
            this.handleConfigFileException(new Exception());
            return false;
        }
    }

    protected void loadDefaultData() {
        this.data.clear();
    }

    public abstract void parseConfigLine(String var1) throws ConfigLoader.ConfigLoadException;

    public abstract void removeBehaviour(E var1, @Nullable FragilityData.FragileBehaviour var2);

    public void setupDirsAndFiles(MinecraftServer ms) {
        this.configDir = ms.func_71254_M().func_186352_b(ms.func_71270_I(), "serverconfig");
        this.configFile = new File(this.configDir, "fragileglassft_" + this.typeString + ".cfg");
        if (!this.configFile.exists()) {
            try {
                FragileGlassBase.warn("[FRAGILE GLASS CONFIG] fragileglassft_" + this.typeString + ".cfg not found! Writing a new one.");
                FileWriter fw = new FileWriter(this.configFile);
                for (String s : this.getDefaultConfigFileText()) {
                    fw.write(s);
                }
                fw.close();
            }
            catch (IOException ioe) {
                this.handleConfigFileException(ioe);
            }
        }
    }

    public abstract String stringifyBehaviour(E var1, @Nullable FragilityData.FragileBehaviour var2);
}

