/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass;

import com.fredtargaryen.fragileglass.block.BlockFragileGlass;
import com.fredtargaryen.fragileglass.block.BlockFragilePane;
import com.fredtargaryen.fragileglass.block.BlockStainedFragileGlass;
import com.fredtargaryen.fragileglass.block.BlockStainedFragilePane;
import com.fredtargaryen.fragileglass.block.BlockSugarCauldron;
import com.fredtargaryen.fragileglass.block.BlockThinIce;
import com.fredtargaryen.fragileglass.block.SugarBlock;
import com.fredtargaryen.fragileglass.item.ItemBlockStainedFragileGlass;
import com.fredtargaryen.fragileglass.item.ItemBlockStainedFragilePane;
import com.fredtargaryen.fragileglass.proxy.CommonProxy;
import com.fredtargaryen.fragileglass.tileentity.TileEntityFragile;
import com.fredtargaryen.fragileglass.worldgen.PatchGen;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="ftfragileglass", version="1.8", name="Fragile Glass and Thin Ice", acceptedMinecraftVersions="[1.8.9]")
public class FragileGlassBase {
    @Mod.Instance(value="ftfragileglass")
    public static FragileGlassBase instance;
    public static ArrayList<Item> iceBlocks;
    public static boolean genThinIce;
    public static int avePatchSize;
    public static int genChance;
    public static final PatchGen patchGen;
    public static Block fragileGlass;
    public static Block fragilePane;
    public static Block stainedFragileGlass;
    public static Block stainedFragilePane;
    public static Block sugarBlock;
    public static Block thinIce;
    public static Block sugarCauldron;
    @SidedProxy(clientSide="com.fredtargaryen.fragileglass.proxy.ClientProxy", serverSide="com.fredtargaryen.fragileglass.proxy.ServerProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        avePatchSize = config.getInt("avePatchSize", "Worldgen", 5, 4, 10, "Average patch diameter");
        genChance = config.getInt("genChance", "Worldgen", 3, 2, 5, "1 in x chance of patch appearing");
        genThinIce = config.getBoolean("genThinIce", "Worldgen", true, "If true, thin ice patches will generate on frozen bodies of water");
        config.save();
        fragileGlass = new BlockFragileGlass().func_149663_c("ftfragileglass").func_149672_a(Block.field_149778_k);
        fragilePane = new BlockFragilePane().func_149663_c("ftfragilepane").func_149672_a(Block.field_149778_k);
        stainedFragileGlass = new BlockStainedFragileGlass().func_149663_c("ftstainedfragileglass").func_149672_a(Block.field_149778_k);
        stainedFragilePane = new BlockStainedFragilePane().func_149663_c("ftstainedfragilepane").func_149672_a(Block.field_149778_k);
        sugarBlock = new SugarBlock().func_149663_c("ftsugarblock").func_149672_a(Block.field_149776_m);
        thinIce = new BlockThinIce().func_149663_c("ftthinice").func_149672_a(Block.field_149778_k);
        sugarCauldron = new BlockSugarCauldron().func_149663_c("ftsugarcauldron").func_149711_c(5.0f).func_149752_b(10.0f).func_149672_a(Block.field_149777_j);
        GameRegistry.registerBlock((Block)fragileGlass, (String)fragileGlass.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)fragilePane, (String)fragilePane.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)stainedFragileGlass, ItemBlockStainedFragileGlass.class, (String)stainedFragileGlass.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)stainedFragilePane, ItemBlockStainedFragilePane.class, (String)stainedFragilePane.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)sugarBlock, (String)sugarBlock.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)thinIce, (String)thinIce.func_149739_a().substring(5));
        GameRegistry.registerBlock((Block)sugarCauldron, (String)sugarCauldron.func_149739_a().substring(5));
        proxy.doStateMappings();
        OreDictionary.registerOre((String)"blockSugar", (ItemStack)new ItemStack(sugarBlock, 1, 1));
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        GameRegistry.addRecipe((ItemStack)new ItemStack(sugarBlock, 1), (Object[])new Object[]{"xxx", "xxx", "xxx", Character.valueOf('x'), Items.field_151102_aT});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151102_aT, 9), (Object[])new Object[]{new ItemStack(sugarBlock)});
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(sugarCauldron), (Object[])new Object[]{Items.field_151102_aT, Items.field_151066_bu});
        GameRegistry.addRecipe((ItemStack)new ItemStack(fragilePane, 16), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), fragileGlass});
        for (int meta = 0; meta < 16; ++meta) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(stainedFragileGlass, 8, meta), (Object[])new Object[]{"xxx", "xox", "xxx", Character.valueOf('x'), new ItemStack(fragileGlass), Character.valueOf('o'), new ItemStack(Items.field_151100_aR, 1, 15 - meta)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(stainedFragilePane, 16, meta), (Object[])new Object[]{"xxx", "xxx", Character.valueOf('x'), new ItemStack(stainedFragileGlass, 1, meta)});
        }
        GameRegistry.registerTileEntity(TileEntityFragile.class, (String)"glassTE");
        if (genThinIce) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)patchGen, (int)1);
        }
        proxy.registerRenderers();
        proxy.registerModels();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        iceBlocks = new ArrayList();
        for (ItemStack is : OreDictionary.getOres((String)"blockIce")) {
            iceBlocks.add(is.func_77973_b());
        }
    }

    static {
        patchGen = new PatchGen();
    }
}

