/*
 * Decompiled with CFR 0.152.
 */
package com.fredtargaryen.fragileglass.worldgen;

import com.fredtargaryen.fragileglass.FragileGlassBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockIce;
import net.minecraft.item.Item;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.fml.common.IWorldGenerator;

public class PatchGen
implements IWorldGenerator {
    private int timeSinceLastPatch = 0;
    private final int timeToWaitBeforeBonusPatch = FragileGlassBase.genChance + 1;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        BiomeGenBase b = world.func_180494_b(new BlockPos(chunkX, 145, chunkZ));
        if (b.func_76746_c()) {
            this.timeSinceLastPatch = random.nextInt(FragileGlassBase.genChance) == 0 && this.genPatch(random, chunkX, chunkZ, world) ? 0 : (this.timeSinceLastPatch >= this.timeToWaitBeforeBonusPatch && this.genPatch(random, chunkX, chunkZ, world) ? 0 : ++this.timeSinceLastPatch);
        }
    }

    public boolean genPatch(Random random, int chunkX, int chunkZ, World world) {
        int chunkBlockX = chunkX * 16;
        int chunkBlockZ = chunkZ * 16;
        int nextChunkBlockX = chunkBlockX + 16;
        int nextChunkBlockZ = chunkBlockZ + 16;
        BlockPos.MutableBlockPos nextBlockPos = new BlockPos.MutableBlockPos(0, 0, 0);
        for (int candX = chunkBlockX; candX < nextChunkBlockX; candX += 8) {
            for (int candZ = chunkBlockZ; candZ < nextChunkBlockZ; candZ += 8) {
                int patchRadius;
                BlockPos patchCentre = world.func_175672_r(new BlockPos(candX, 0, candZ)).func_177977_b();
                int patchY = patchCentre.func_177956_o();
                Block candidate = world.func_180495_p(patchCentre).func_177230_c();
                if (!(candidate instanceof BlockIce) && !FragileGlassBase.iceBlocks.contains(Item.func_150898_a((Block)candidate))) continue;
                for (int rad = patchRadius = (int)((2.0 * random.nextGaussian() + (double)FragileGlassBase.avePatchSize) / 2.0); rad > 0; --rad) {
                    for (double d = 0.0; d < 360.0; d += 10.0) {
                        double r = Math.toRadians(d);
                        int nextX = (int)((double)candX + (double)rad * Math.cos(r));
                        int nextZ = (int)((double)candZ + (double)rad * Math.sin(r));
                        nextBlockPos.func_181079_c(nextX, patchY, nextZ);
                        Block nextBlock = world.func_180495_p((BlockPos)nextBlockPos).func_177230_c();
                        if (!(nextBlock instanceof BlockIce) && !FragileGlassBase.iceBlocks.contains(Item.func_150898_a((Block)nextBlock))) continue;
                        if (rad > patchRadius - 2) {
                            if (!random.nextBoolean()) continue;
                            world.func_175656_a((BlockPos)nextBlockPos, FragileGlassBase.thinIce.func_176223_P());
                            continue;
                        }
                        world.func_175656_a((BlockPos)nextBlockPos, FragileGlassBase.thinIce.func_176223_P());
                    }
                }
                world.func_175656_a(patchCentre, FragileGlassBase.thinIce.func_176223_P());
                return true;
            }
        }
        return false;
    }
}

