/*
 * Decompiled with CFR 0.152.
 */
package ftgumod;

import ftgumod.Content;
import ftgumod.CraftingListener;
import ftgumod.FTGU;
import ftgumod.api.util.BlockSerializable;
import ftgumod.event.PlayerLockEvent;
import ftgumod.item.ItemMagnifyingGlass;
import ftgumod.item.ItemParchmentResearch;
import ftgumod.packet.PacketDispatcher;
import ftgumod.packet.client.TechnologyInfoMessage;
import ftgumod.packet.server.RequestMessage;
import ftgumod.proxy.ProxyClient;
import ftgumod.server.RecipeBookServerImpl;
import ftgumod.technology.CapabilityTechnology;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import ftgumod.util.LootUtils;
import ftgumod.util.StackUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class EventHandler {
    private ItemStack stack = ItemStack.field_190927_a;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onItemTooltip(ItemTooltipEvent evt) {
        Technology tech;
        Item item = evt.getItemStack().func_77973_b();
        if (item == Content.i_magnifyingGlass) {
            List<BlockSerializable> blocks = ItemMagnifyingGlass.getInspected(evt.getItemStack());
            if (Keyboard.isKeyDown((int)54) || Keyboard.isKeyDown((int)42)) {
                for (BlockSerializable block : blocks) {
                    evt.getToolTip().add(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + block.getLocalizedName());
                }
                if (blocks.size() > 0) {
                    evt.getToolTip().add("");
                }
            } else if (blocks.size() > 0) {
                evt.getToolTip().add(I18n.func_135052_a((String)(Content.i_magnifyingGlass.func_77658_a() + ".shift"), (Object[])new Object[0]));
                evt.getToolTip().add("");
            }
            evt.getToolTip().add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"technology.decipher.tooltip", (Object[])new Object[0]));
        } else if (item == Content.i_parchmentIdea) {
            Technology tech2 = StackUtils.INSTANCE.getTechnology(evt.getItemStack());
            if (tech2 != null) {
                String k = tech2.isResearched(evt.getEntityPlayer()) || tech2.canResearchIgnoreCustomUnlock(evt.getEntityPlayer()) ? "" : "" + TextFormatting.OBFUSCATED;
                evt.getToolTip().add(TextFormatting.GOLD + I18n.func_135052_a((String)"technology.idea", (Object[])new Object[]{tech2.getDisplayInfo().func_192297_a().func_150260_c()}));
                evt.getToolTip().add(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + k + tech2.getDisplayInfo().func_193222_b().func_150260_c());
            }
        } else if (item == Content.i_parchmentResearch && (tech = StackUtils.INSTANCE.getTechnology(evt.getItemStack())) != null) {
            boolean can = tech.isResearched(evt.getEntityPlayer()) || tech.canResearchIgnoreCustomUnlock(evt.getEntityPlayer());
            String k = can ? "" : "" + TextFormatting.OBFUSCATED;
            evt.getToolTip().add(TextFormatting.GOLD + tech.getDisplayInfo().func_192297_a().func_150260_c());
            evt.getToolTip().add(TextFormatting.DARK_PURPLE + "" + TextFormatting.ITALIC + k + tech.getDisplayInfo().func_193222_b().func_150260_c());
            if (can && !tech.isResearched(evt.getEntityPlayer())) {
                evt.getToolTip().add("");
                evt.getToolTip().add(TextFormatting.DARK_RED + I18n.func_135052_a((String)"item.parchment_research.complete", (Object[])new Object[0]));
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        if (ProxyClient.key.func_151468_f()) {
            FTGU.PROXY.openResearchBook((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            PacketDispatcher.sendToServer(new RequestMessage());
        }
    }

    @SubscribeEvent
    public void onItemCraft(PlayerEvent.ItemCraftedEvent evt) {
        if (evt.crafting.func_77973_b() == Content.i_researchBook) {
            for (int i = 0; i < evt.craftMatrix.func_70302_i_(); ++i) {
                ItemStack item = evt.craftMatrix.func_70301_a(i);
                if (item.func_190926_b() || item.func_77973_b() != Content.i_parchmentResearch) continue;
                ((ItemParchmentResearch)item.func_77973_b()).research(item, evt.player, false);
            }
        }
    }

    private void replaceRecipeBook(EntityPlayerMP player) {
        RecipeBookServerImpl book = new RecipeBookServerImpl(player);
        book.func_192825_a(player.field_192041_cq.func_192824_e());
        player.field_192041_cq = book;
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent evt) {
        if (!evt.player.field_70170_p.field_72995_K) {
            this.replaceRecipeBook((EntityPlayerMP)evt.player);
            Container inv = evt.player.field_71070_bA;
            inv.func_75132_a((IContainerListener)new CraftingListener(evt.player));
            CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)evt.player.getCapability(CapabilityTechnology.TECH_CAP, null);
            if (cap != null) {
                for (Technology tech : TechnologyManager.INSTANCE.getStart()) {
                    if (cap.isResearched(tech.getRegistryName().toString())) continue;
                    cap.setResearched(tech.getRegistryName().toString());
                    tech.addRecipes((EntityPlayerMP)evt.player);
                }
                if (cap.isNew()) {
                    if (FTGU.journal) {
                        evt.player.field_71071_by.func_70441_a(new ItemStack(Content.i_researchBook));
                    }
                    cap.setOld();
                }
            }
            for (Technology tech : TechnologyManager.INSTANCE) {
                if (!tech.hasCustomUnlock() || !tech.canResearchIgnoreCustomUnlock(evt.player)) continue;
                tech.registerListeners((EntityPlayerMP)evt.player);
            }
            PacketDispatcher.sendTo(new TechnologyInfoMessage(TechnologyManager.INSTANCE.cache), (EntityPlayerMP)evt.player);
        }
    }

    @SubscribeEvent
    public void onPlayerLeave(PlayerEvent.PlayerLoggedOutEvent evt) {
        TechnologyManager.INSTANCE.unloadProgress(evt.player);
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        if (!evt.getEntity().field_70170_p.field_72995_K) {
            this.replaceRecipeBook((EntityPlayerMP)evt.getEntityPlayer());
            ContainerPlayer inv = (ContainerPlayer)evt.getEntityPlayer().field_71070_bA;
            inv.func_75132_a((IContainerListener)new CraftingListener(evt.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public void onPlayerOpenContainer(PlayerContainerEvent.Open evt) {
        if (!evt.getEntity().field_70170_p.field_72995_K) {
            Container inv = evt.getEntityPlayer().field_71070_bA;
            inv.func_75132_a((IContainerListener)new CraftingListener(evt.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    public void onPlayerCloseContainer(PlayerContainerEvent.Close evt) {
        if (!evt.getEntity().field_70170_p.field_72995_K) {
            Container inv = evt.getEntityPlayer().field_71070_bA;
            inv.func_75132_a((IContainerListener)new CraftingListener(evt.getEntityPlayer()));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerInGui(GuiScreenEvent.DrawScreenEvent.Pre evt) {
        GuiScreen work = evt.getGui();
        if (work instanceof GuiContainer) {
            Container inv = ((GuiContainer)work).field_147002_h;
            for (Slot s : inv.field_75151_b) {
                if (!(s.field_75224_c instanceof InventoryCraftResult)) continue;
                ItemStack stack = s.field_75224_c.func_70301_a(0);
                if (stack.func_190926_b()) {
                    this.stack = stack;
                } else if (stack != this.stack) {
                    PlayerLockEvent event = new PlayerLockEvent((EntityPlayer)Minecraft.func_71410_x().field_71439_g, stack, ((InventoryCraftResult)s.field_75224_c).func_193055_i());
                    MinecraftForge.EVENT_BUS.post((Event)event);
                    if (!event.isCanceled()) {
                        s.field_75224_c.func_70299_a(0, ItemStack.field_190927_a);
                    }
                    this.stack = s.field_75224_c.func_70301_a(0);
                }
                return;
            }
        }
    }

    @SubscribeEvent
    public void onLootTableLoad(LootTableLoadEvent event) {
        if (event.getName().toString().equals("minecraft:chests/village_blacksmith")) {
            LootUtils.addLootPools(event.getLootTableManager(), event.getTable(), new ResourceLocation("ftgumod", "inject/blacksmith"));
        }
        if (event.getName().toString().equals("minecraft:chests/desert_pyramid")) {
            LootUtils.addLootPools(event.getLootTableManager(), event.getTable(), new ResourceLocation("ftgumod", "inject/pyramid"));
        }
        if (event.getName().toString().equals("minecraft:chests/stronghold_library")) {
            LootUtils.addLootPools(event.getLootTableManager(), event.getTable(), new ResourceLocation("ftgumod", "inject/library"));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getWorld().field_72995_K && event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
            PacketDispatcher.sendToServer(new RequestMessage());
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            FTGU.INSTANCE.runCompat("jei", true);
        }
    }
}

