/*
 * Decompiled with CFR 0.152.
 */
package ftgumod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import ftgumod.Content;
import ftgumod.EventHandler;
import ftgumod.api.technology.puzzle.ResearchConnect;
import ftgumod.api.technology.puzzle.ResearchMatch;
import ftgumod.api.util.predicate.ItemFluid;
import ftgumod.api.util.predicate.ItemLambda;
import ftgumod.command.CommandTechnology;
import ftgumod.compat.ICompat;
import ftgumod.compat.gamestages.CompatGameStages;
import ftgumod.compat.gamestages.UnlockGameStage;
import ftgumod.compat.immersiveengineering.CompatIE;
import ftgumod.compat.immersiveengineering.UnlockMultiblockFactory;
import ftgumod.packet.PacketDispatcher;
import ftgumod.proxy.ProxyCommon;
import ftgumod.technology.CapabilityTechnology;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import ftgumod.tileentity.TileEntityIdeaTable;
import ftgumod.tileentity.TileEntityResearchTable;
import ftgumod.util.StackUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(modid="ftgumod", name="From the Ground Up!", acceptedMinecraftVersions="[1.12.2]")
public class FTGU {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(Technology.Builder.class, (Object)new Technology.Deserializer()).registerTypeAdapter(AdvancementRewards.class, (Object)new AdvancementRewards.Deserializer()).registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer()).registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer()).registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory()).create();
    public static final String MODID = "ftgumod";
    public static File folder;
    public static boolean copy;
    public static boolean custom;
    public static byte hide;
    public static boolean journal;
    @Mod.Instance(value="ftgumod")
    public static FTGU INSTANCE;
    @SidedProxy(clientSide="ftgumod.proxy.ProxyClient", serverSide="ftgumod.proxy.ProxyCommon")
    public static ProxyCommon PROXY;
    public final Map<String, ICompat> compat = new HashMap<String, ICompat>();

    private void registerItem(Item item, String name) {
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    private void registerBlock(Block block, ItemBlock item, String name) {
        block.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        this.registerItem((Item)item, name);
    }

    public boolean runCompat(String name, Object ... arg) {
        ICompat compat = this.compat.get(name);
        return compat != null && compat.run(arg);
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        TileEntity.func_190560_a((String)"ftgumod:idea_table", TileEntityIdeaTable.class);
        TileEntity.func_190560_a((String)"ftgumod:research_table", TileEntityResearchTable.class);
        this.registerBlock(Content.b_ideaTable, Content.i_ideaTable, "idea_table");
        this.registerBlock(Content.b_researchTable, Content.i_researchTable, "research_table");
        this.registerItem(Content.i_parchmentEmpty, "parchment_empty");
        this.registerItem(Content.i_parchmentIdea, "parchment_idea");
        this.registerItem(Content.i_parchmentResearch, "parchment_research");
        this.registerItem(Content.i_researchBook, "research_book");
        this.registerItem(Content.i_magnifyingGlass, "magnifying_glass");
        CriteriaTriggers.func_192118_a((ICriterionTrigger)Content.c_technologyUnlocked);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)Content.c_technologyResearched);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)Content.c_itemLocked);
        CriteriaTriggers.func_192118_a((ICriterionTrigger)Content.c_inspect);
        StackUtils.INSTANCE.registerItemPredicate(new ResourceLocation(MODID, "fluid"), new ItemFluid.Factory());
        StackUtils.INSTANCE.registerItemPredicate(new ResourceLocation(MODID, "enchantment"), new ItemLambda.Factory(i -> EnchantmentHelper.func_82781_a((ItemStack)i).size() > 0));
        TechnologyManager.INSTANCE.registerPuzzle(new ResourceLocation(MODID, "match"), new ResearchMatch.Factory());
        TechnologyManager.INSTANCE.registerPuzzle(new ResourceLocation(MODID, "connect"), new ResearchConnect.Factory());
        CapabilityManager.INSTANCE.register(CapabilityTechnology.ITechnology.class, (Capability.IStorage)new CapabilityTechnology.Storage(), CapabilityTechnology.DefaultImpl::new);
        MinecraftForge.EVENT_BUS.register((Object)new CapabilityTechnology());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "inject/blacksmith"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "inject/pyramid"));
        LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "inject/library"));
        PacketDispatcher.registerPackets();
        folder = new File(event.getModConfigurationDirectory(), MODID);
        Configuration config = new Configuration(new File(folder, "ftgumod.cfg"));
        config.load();
        copy = config.getBoolean("general", "copy", true, "If enabled, technologies can be copied");
        custom = config.getBoolean("general", "custom", false, "If enabled, only config and world technologies will be loaded");
        journal = config.getBoolean("general", "journal", true, "If enabled, every player will get a research book when they join a new world or server");
        hide = (byte)config.getInt("client", "hide", 1, 0, 2, "0: No items or recipes are hidden from JEI\n1: Only locked recipes are hidden from JEI\n2: Locked items and recipes are hidden from JEI");
        config.save();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)INSTANCE, PROXY.getGuiHandler());
        PROXY.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            MinecraftForge.EVENT_BUS.register((Object)new CompatIE());
            TechnologyManager.INSTANCE.registerUnlock(new ResourceLocation("immersiveengineering", "multiblock"), new UnlockMultiblockFactory());
        }
        if (Loader.isModLoaded((String)"gamestages")) {
            CompatGameStages compat = new CompatGameStages();
            this.compat.put("gamestages", compat);
            MinecraftForge.EVENT_BUS.register((Object)compat);
            TechnologyManager.INSTANCE.registerUnlock(new ResourceLocation("gamestages", "stage"), new UnlockGameStage.Factory());
        }
        PROXY.postInit(event);
    }

    @Mod.EventHandler
    public void serverAboutToStart(FMLServerAboutToStartEvent event) {
        TechnologyManager.INSTANCE.reload(event.getServer().func_71254_M().func_186352_b(event.getServer().func_71270_I(), "data"));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTechnology());
    }

    static {
        copy = true;
        custom = false;
        hide = 1;
        journal = true;
    }
}

