/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.technology.puzzle;

import ftgumod.api.FTGUAPI;
import ftgumod.api.inventory.ContainerResearch;
import ftgumod.api.inventory.InventoryCraftingPersistent;
import ftgumod.api.inventory.SlotCrafting;
import ftgumod.api.technology.puzzle.ResearchConnect;
import ftgumod.api.technology.puzzle.gui.PuzzleGuiConnect;
import ftgumod.api.technology.recipe.IPuzzle;
import ftgumod.api.util.predicate.ItemPredicate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class PuzzleConnect
implements IPuzzle {
    private final IInventory inventory = new InventoryBasic(null, false, 3);
    private final List<ContainerResearch> registry = new LinkedList<ContainerResearch>();
    private final ResearchConnect research;

    public PuzzleConnect(ResearchConnect research) {
        this.research = research;
    }

    @Override
    public NBTBase write() {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.inventory.func_70301_a(i).func_77955_b(compound);
            items.func_74742_a((NBTBase)compound);
        }
        return items;
    }

    @Override
    public void read(NBTBase tag) {
        NBTTagList items = (NBTTagList)tag;
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound compound = items.func_150305_b(i);
            byte slot = compound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a((int)slot, new ItemStack(compound));
        }
    }

    @Override
    public ResearchConnect getRecipe() {
        return this.research;
    }

    private static boolean connects(ItemPredicate predicate, ItemStack stack) {
        if (predicate.func_193365_a().length == 0) {
            return true;
        }
        for (IRecipe recipe : CraftingManager.field_193380_a) {
            if (predicate.test(recipe.func_77571_b())) {
                for (Ingredient ingredient : recipe.func_192400_c()) {
                    if (!ingredient.test((Object)stack)) continue;
                    return true;
                }
                continue;
            }
            if (!FTGUAPI.stackUtils.isEqual(recipe.func_77571_b(), stack)) continue;
            for (Ingredient ingredient : recipe.func_192400_c()) {
                for (ItemStack s : predicate.func_193365_a()) {
                    if (!ingredient.test((Object)s)) continue;
                    return true;
                }
            }
        }
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (predicate.test(entry.getValue()) && FTGUAPI.stackUtils.isStackOf((ItemStack)entry.getKey(), stack)) {
                return true;
            }
            if (!FTGUAPI.stackUtils.isEqual((ItemStack)entry.getValue(), stack)) continue;
            for (ItemStack s : predicate.func_193365_a()) {
                if (!FTGUAPI.stackUtils.isStackOf((ItemStack)entry.getKey(), s)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void onStart(ContainerResearch container) {
        this.registry.add(container);
        InventoryCraftingPersistent crafting = new InventoryCraftingPersistent(this.inventory, 0, 3, 1);
        for (int i = 0; i < 3; ++i) {
            int j = i;
            container.func_75146_a(new SlotCrafting((Container)container, (IInventory)crafting, i, 44 + i * 18, 35, 1, stack -> this.fits((ItemStack)stack, j)));
        }
    }

    @Override
    public boolean test() {
        for (int i = 0; i < 3; ++i) {
            if (!this.inventory.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    private boolean fits(ItemStack stack, int index) {
        if (this.research.left.test(stack) || this.research.right.test(stack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (!FTGUAPI.stackUtils.isEqual(stack, this.inventory.func_70301_a(i))) continue;
            return false;
        }
        ItemPredicate left = index > 0 ? new ItemPredicate(this.inventory.func_70301_a(index - 1)) : this.research.left;
        ItemPredicate right = index < 2 ? new ItemPredicate(this.inventory.func_70301_a(index + 1)) : this.research.right;
        return PuzzleConnect.connects(left, stack) && PuzzleConnect.connects(right, stack);
    }

    @Override
    public void onInventoryChange(ContainerResearch container) {
        if (!container.isClient()) {
            container.markDirty();
        }
    }

    @Override
    public void onFinish() {
        NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)new InventoryCraftingPersistent(this.inventory, 0, 3, 1));
        for (int i = 0; i < 3; ++i) {
            this.inventory.func_70299_a(i, (ItemStack)remaining.get(i));
        }
    }

    @Override
    public void onRemove(@Nullable EntityPlayer player, World world, BlockPos pos) {
        if (!world.field_72995_K) {
            if (player != null) {
                for (int i = 0; i < 3; ++i) {
                    ItemStack stack = this.inventory.func_70301_a(i);
                    if (stack.func_190926_b() || player.func_191521_c(stack)) continue;
                    player.func_71019_a(stack, false);
                }
            } else {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)this.inventory);
            }
        }
        for (ContainerResearch container : this.registry) {
            container.removeSlots(3);
        }
        this.registry.clear();
    }

    @Override
    public void setHints(List<ITextComponent> hints) {
    }

    @Override
    public List<ITextComponent> getHints() {
        return Collections.emptyList();
    }

    @Override
    public Object getGui() {
        return new PuzzleGuiConnect(this.research);
    }
}

