/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.technology.puzzle;

import ftgumod.api.FTGUAPI;
import ftgumod.api.inventory.ContainerResearch;
import ftgumod.api.inventory.InventoryCraftingPersistent;
import ftgumod.api.inventory.SlotCrafting;
import ftgumod.api.technology.puzzle.ResearchMatch;
import ftgumod.api.technology.puzzle.gui.PuzzleGuiMatch;
import ftgumod.api.technology.recipe.IPuzzle;
import ftgumod.api.util.BlockSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class PuzzleMatch
implements IPuzzle {
    private final IInventory inventory = new InventoryBasic(null, false, 9);
    private final List<ContainerResearch> registry = new LinkedList<ContainerResearch>();
    private final ResearchMatch research;
    private List<ITextComponent> hints;

    public PuzzleMatch(ResearchMatch research) {
        this.research = research;
    }

    @Override
    public NBTBase write() {
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            if (this.inventory.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74774_a("Slot", (byte)i);
            this.inventory.func_70301_a(i).func_77955_b(compound);
            items.func_74742_a((NBTBase)compound);
        }
        return items;
    }

    @Override
    public void read(NBTBase tag) {
        NBTTagList items = (NBTTagList)tag;
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound compound = items.func_150305_b(i);
            byte slot = compound.func_74771_c("Slot");
            if (slot < 0 || slot >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a((int)slot, new ItemStack(compound));
        }
    }

    @Override
    public ResearchMatch getRecipe() {
        return this.research;
    }

    @Override
    public boolean test() {
        for (int i = 0; i < 9; ++i) {
            if (this.research.ingredients[i].test(this.inventory.func_70301_a(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onStart(ContainerResearch container) {
        this.registry.add(container);
        InventoryCraftingPersistent crafting = new InventoryCraftingPersistent(this.inventory, 0, 3, 3);
        for (int sloty = 0; sloty < 3; ++sloty) {
            for (int slotx = 0; slotx < 3; ++slotx) {
                container.func_75146_a(new SlotCrafting((Container)container, (IInventory)crafting, slotx + sloty * 3, 30 + slotx * 18, 17 + sloty * 18, 1, (Predicate<ItemStack>)null));
            }
        }
    }

    @Override
    public void onInventoryChange(ContainerResearch container) {
        if (!container.isClient()) {
            this.hints = new ArrayList<ITextComponent>();
            List<BlockSerializable> inspected = Collections.emptyList();
            if (((Slot)container.field_75151_b.get(2)).func_75216_d()) {
                inspected = FTGUAPI.stackUtils.getInspected(((Slot)container.field_75151_b.get(2)).func_75211_c());
            }
            for (int i = 0; i < 9; ++i) {
                if (this.research.hasHint(i)) {
                    this.hints.add(this.research.getHint(i).getHint(inspected));
                    continue;
                }
                this.hints.add(null);
            }
            container.markDirty();
        } else {
            container.refreshHints();
        }
    }

    @Override
    public void onFinish() {
        NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)new InventoryCraftingPersistent(this.inventory, 0, 3, 3));
        for (int i = 0; i < 9; ++i) {
            if (this.research.consume[i] != null) {
                if (this.research.consume[i].booleanValue()) {
                    this.inventory.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                this.inventory.func_70299_a(i, this.inventory.func_70301_a(i).func_77946_l());
                continue;
            }
            this.inventory.func_70299_a(i, (ItemStack)remaining.get(i));
        }
    }

    @Override
    public void onRemove(@Nullable EntityPlayer player, World world, BlockPos pos) {
        if (player != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.inventory.func_70301_a(i);
                if (stack.func_190926_b() || player.func_191521_c(stack)) continue;
                player.func_71019_a(stack, false);
            }
        } else {
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)this.inventory);
        }
        for (ContainerResearch container : this.registry) {
            container.removeSlots(9);
        }
        this.registry.clear();
    }

    @Override
    public void setHints(List<ITextComponent> hints) {
        this.hints = hints;
    }

    @Override
    public List<ITextComponent> getHints() {
        return this.hints;
    }

    @Override
    public Object getGui() {
        return new PuzzleGuiMatch(this, this.inventory);
    }
}

