/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.technology.puzzle;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ftgumod.api.FTGUAPI;
import ftgumod.api.technology.ITechnology;
import ftgumod.api.technology.puzzle.PuzzleMatch;
import ftgumod.api.technology.recipe.IPuzzle;
import ftgumod.api.technology.recipe.IResearchRecipe;
import ftgumod.api.util.BlockSerializable;
import ftgumod.api.util.Hint;
import ftgumod.api.util.JsonContextPublic;
import ftgumod.api.util.predicate.ItemLambda;
import ftgumod.api.util.predicate.ItemPredicate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class ResearchMatch
implements IResearchRecipe {
    final ItemPredicate[] ingredients;
    final Hint[] hints;
    final Boolean[] consume;
    private ITechnology tech;

    public ResearchMatch(ItemPredicate[] ingredients, Hint[] hints, Boolean[] consume) {
        this.ingredients = ingredients;
        this.hints = hints;
        this.consume = consume;
    }

    @Nullable
    public Hint getHint(int index) {
        return this.hints[index];
    }

    public boolean hasHint(int index) {
        return this.hints[index] != null;
    }

    @Override
    public boolean inspect(BlockSerializable block, List<BlockSerializable> inspected) {
        for (Hint hint : this.hints) {
            if (hint == null || !hint.inspect(block, inspected)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IPuzzle createInstance() {
        return new PuzzleMatch(this);
    }

    @Override
    public ITechnology getTechnology() {
        return this.tech;
    }

    @Override
    public void setTechnology(ITechnology tech) {
        this.tech = tech;
    }

    public static class Factory
    implements IResearchRecipe.Factory<ResearchMatch> {
        @Override
        public ResearchMatch deserialize(JsonObject object, JsonContextPublic context, ResourceLocation technology) {
            HashMap ingMap = Maps.newHashMap();
            HashMap hintMap = Maps.newHashMap();
            HashMap useMap = Maps.newHashMap();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)object, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                JsonElement element = (JsonElement)entry.getValue();
                char c = ((String)entry.getKey()).toCharArray()[0];
                if (!element.isJsonObject()) {
                    throw new JsonSyntaxException("Expected predicate to be an object");
                }
                JsonObject first = element.getAsJsonObject();
                ingMap.put(Character.valueOf(c), FTGUAPI.stackUtils.getItemPredicate(first.get("item"), context));
                Hint hint = null;
                if (first.has("hint")) {
                    hint = Hint.deserialize(first.get("hint"), first.get("decipher"));
                }
                Boolean use = null;
                if (first.has("consume")) {
                    use = JsonUtils.func_151212_i((JsonObject)first, (String)"consume");
                }
                hintMap.put(Character.valueOf(c), hint);
                useMap.put(Character.valueOf(c), use);
            }
            ingMap.put(Character.valueOf(' '), ItemLambda.EMPTY);
            JsonArray patternJ = JsonUtils.func_151214_t((JsonObject)object, (String)"pattern");
            if (patternJ.size() != 3) {
                throw new JsonSyntaxException("Invalid pattern: must be 3x3");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = JsonUtils.func_151206_a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (line.length() != 3) {
                    throw new JsonSyntaxException("Invalid pattern: must be 3x3");
                }
                pattern[x] = line;
            }
            ItemPredicate[] predicates = new ItemPredicate[9];
            Hint[] hints = new Hint[9];
            Boolean[] consume = new Boolean[9];
            Arrays.fill((Object[])predicates, ingMap.get(Character.valueOf(' ')));
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    ItemPredicate ing = (ItemPredicate)((Object)ingMap.get(Character.valueOf(chr)));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    predicates[x] = ing;
                    hints[x] = (Hint)hintMap.get(Character.valueOf(chr));
                    consume[x] = (Boolean)useMap.get(Character.valueOf(chr));
                    ++x;
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            return new ResearchMatch(predicates, hints, consume);
        }
    }
}

