/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.technology.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ftgumod.api.FTGUAPI;
import ftgumod.api.technology.recipe.IIdeaRecipe;
import ftgumod.api.util.JsonContextPublic;
import ftgumod.api.util.predicate.ItemPredicate;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.tuple.Pair;

public class IdeaRecipe
implements IIdeaRecipe {
    private final NonNullList<Pair<ItemPredicate, Boolean>> recipe;
    private final int needed;

    public IdeaRecipe(NonNullList<Pair<ItemPredicate, Boolean>> recipe, int needed) {
        this.needed = needed;
        this.recipe = recipe;
    }

    public static IdeaRecipe deserialize(JsonObject object, JsonContextPublic context) {
        int amount = JsonUtils.func_151203_m((JsonObject)object, (String)"amount");
        JsonArray ingredients = JsonUtils.func_151214_t((JsonObject)object, (String)"ingredients");
        NonNullList recipe = NonNullList.func_191196_a();
        for (JsonElement element : ingredients) {
            ItemPredicate predicate = FTGUAPI.stackUtils.getItemPredicate(element, context);
            JsonElement first = element;
            while (first.isJsonArray()) {
                first = first.getAsJsonArray().get(0);
            }
            recipe.add((Object)Pair.of((Object)((Object)predicate), first.isJsonObject() && first.getAsJsonObject().has("consume") ? Boolean.valueOf(JsonUtils.func_151212_i((JsonObject)first.getAsJsonObject(), (String)"consume")) : null));
        }
        return new IdeaRecipe((NonNullList<Pair<ItemPredicate, Boolean>>)recipe, amount);
    }

    @Override
    public NonNullList<ItemStack> test(InventoryCrafting inventory) {
        NonNullList remaining = ForgeHooks.defaultRecipeGetRemainingItems((InventoryCrafting)inventory);
        HashSet<Pair<ItemPredicate, Boolean>> copy = new HashSet<Pair<ItemPredicate, Boolean>>((Collection<Pair<ItemPredicate, Boolean>>)this.recipe);
        block0: for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Iterator iterator = copy.iterator();
            while (iterator.hasNext()) {
                Pair match = (Pair)iterator.next();
                if (!((ItemPredicate)((Object)match.getLeft())).test(stack)) continue;
                iterator.remove();
                if (match.getRight() == null) continue block0;
                if (((Boolean)match.getRight()).booleanValue()) {
                    remaining.set(i, (Object)ItemStack.field_190927_a);
                    continue block0;
                }
                remaining.set(i, (Object)stack.func_77946_l());
                continue block0;
            }
            return null;
        }
        return this.recipe.size() - copy.size() >= this.needed ? remaining : null;
    }
}

