/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.technology.unlock;

import ftgumod.api.technology.unlock.IUnlock;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.crafting.CompoundIngredient;

public class UnlockCompound
implements IUnlock {
    private final NonNullList<IUnlock> list;
    private final boolean display;
    private final Ingredient icon;

    public UnlockCompound(NonNullList<IUnlock> list) {
        this.list = list;
        List stream = list.stream().filter(IUnlock::isDisplayed).collect(Collectors.toList());
        this.display = stream.size() > 0;
        this.icon = this.display ? new CompoundIngredient(stream.stream().map(IUnlock::getIcon).collect(Collectors.toList())){} : null;
    }

    @Override
    public boolean isDisplayed() {
        return this.display;
    }

    @Override
    public Ingredient getIcon() {
        return this.icon;
    }

    @Override
    public boolean unlocks(ItemStack stack) {
        return this.list.stream().anyMatch(unlock -> unlock.unlocks(stack));
    }

    @Override
    public void unlock(EntityPlayerMP player) {
        this.list.forEach(unlock -> unlock.unlock(player));
    }

    @Override
    public void lock(EntityPlayerMP player) {
        this.list.forEach(unlock -> unlock.lock(player));
    }
}

