/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.util;

import ftgumod.api.util.predicate.BlockPredicate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class BlockSerializable {
    private final DimensionType dimension;
    private final BlockPos pos;
    private final Block block;
    private final Map<IProperty<?>, Object> properties;
    private final ItemStack display;

    public BlockSerializable(World world, BlockPos pos, IBlockState state, @Nullable ItemStack display) {
        this.dimension = world.field_73011_w.func_186058_p();
        this.pos = pos;
        this.block = state.func_177230_c();
        this.properties = new HashMap();
        for (IProperty property : state.func_177227_a()) {
            this.properties.put(property, state.func_177229_b(property));
        }
        this.display = display == null || display.func_190926_b() ? new ItemStack(this.block, 1, this.block.func_176201_c(state)) : display;
    }

    public BlockSerializable(NBTTagCompound compound) {
        this.dimension = DimensionType.func_193417_a((String)compound.func_74779_i("dimension"));
        this.pos = new BlockPos(compound.func_74762_e("x"), compound.func_74762_e("y"), compound.func_74762_e("z"));
        this.block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(compound.func_74779_i("block")));
        this.properties = new HashMap();
        NBTTagCompound state = compound.func_74775_l("state");
        BlockStateContainer container = this.block.func_176194_O();
        for (String name : state.func_150296_c()) {
            IProperty property = container.func_185920_a(name);
            this.properties.put(property, property.func_185929_b(state.func_74779_i(name)).get());
        }
        this.display = new ItemStack(compound.func_74775_l("display"));
    }

    public NBTTagCompound serialize() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("dimension", this.dimension.func_186065_b());
        compound.func_74768_a("x", this.pos.func_177958_n());
        compound.func_74768_a("y", this.pos.func_177956_o());
        compound.func_74768_a("z", this.pos.func_177952_p());
        compound.func_74778_a("block", this.block.getRegistryName().toString());
        NBTTagCompound state = new NBTTagCompound();
        for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
            state.func_74778_a(entry.getKey().func_177701_a(), this.getPropertyName(entry.getKey(), entry.getValue()));
        }
        compound.func_74782_a("state", (NBTBase)state);
        compound.func_74782_a("display", (NBTBase)this.display.serializeNBT());
        return compound;
    }

    private <T extends Comparable<T>> String getPropertyName(IProperty<T> property, Object object) {
        return property.func_177702_a((Comparable)object);
    }

    public String getLocalizedName() {
        return this.display.func_82833_r();
    }

    public boolean test(BlockPredicate predicate) {
        return predicate.test(FMLCommonHandler.instance().getMinecraftServerInstance().func_71218_a(this.dimension.func_186068_a()), this.pos, this.block, this.properties);
    }
}

