/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import ftgumod.api.util.BlockSerializable;
import ftgumod.api.util.predicate.BlockPredicate;
import ftgumod.api.util.predicate.BlockPredicateCompound;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.tuple.Pair;

public class Hint {
    private static final Gson GSON;
    private final ITextComponent hint;
    private final List<Pair<BlockPredicate, ITextComponent>> hints;

    public Hint(ITextComponent hint, List<Pair<BlockPredicate, ITextComponent>> hints) {
        this.hint = hint;
        this.hints = hints;
    }

    public static Hint deserialize(JsonElement eHint, JsonElement decipher) {
        ITextComponent hint = (ITextComponent)GSON.fromJson(eHint, ITextComponent.class);
        if (decipher != null) {
            if (decipher.isJsonArray()) {
                ArrayList<Pair<BlockPredicate, ITextComponent>> hints = new ArrayList<Pair<BlockPredicate, ITextComponent>>();
                for (JsonElement e : decipher.getAsJsonArray()) {
                    if (!e.isJsonObject()) {
                        throw new JsonSyntaxException("Expected decipher to be an object or an array of objects");
                    }
                    BlockPredicate predicate = BlockPredicateCompound.deserialize(e.getAsJsonObject().get("decipher"));
                    ITextComponent newHint = (ITextComponent)GSON.fromJson(e.getAsJsonObject().get("hint"), ITextComponent.class);
                    hints.add((Pair<BlockPredicate, ITextComponent>)Pair.of((Object)predicate, (Object)newHint));
                }
                return new Hint(hint, hints);
            }
            if (!decipher.isJsonObject()) {
                throw new JsonSyntaxException("Expected decipher to be an object or an array of objects");
            }
            if (decipher.getAsJsonObject().has("decipher")) {
                BlockPredicate predicate = BlockPredicateCompound.deserialize(decipher.getAsJsonObject().get("decipher"));
                ITextComponent newHint = (ITextComponent)GSON.fromJson(decipher.getAsJsonObject().get("hint"), ITextComponent.class);
                List<Pair<BlockPredicate, ITextComponent>> hints = Collections.singletonList(Pair.of((Object)predicate, (Object)newHint));
                return new Hint(hint, hints);
            }
        }
        return new Hint(hint, Collections.emptyList());
    }

    public ITextComponent getHint(List<BlockSerializable> inspected) {
        ITextComponent text = this.hint.func_150259_f();
        for (Pair<BlockPredicate, ITextComponent> hint : this.hints) {
            for (BlockSerializable block : inspected) {
                if (!block.test((BlockPredicate)hint.getLeft())) continue;
                ITextComponent sibling = ((ITextComponent)hint.getRight()).func_150259_f();
                sibling.func_150256_b().func_150238_a(TextFormatting.GOLD);
                text.func_150258_a("\n - ");
                text.func_150257_a(sibling);
            }
        }
        return text;
    }

    public ITextComponent getObfuscatedHint() {
        ITextComponent hint = this.hint.func_150259_f();
        hint.func_150256_b().func_150237_e(Boolean.valueOf(true));
        return hint;
    }

    public boolean inspect(BlockSerializable block, List<BlockSerializable> inspected) {
        for (Pair<BlockPredicate, ITextComponent> hint : this.hints) {
            BlockSerializable b;
            Iterator<BlockSerializable> iterator;
            if (!block.test((BlockPredicate)hint.getLeft()) || !(iterator = inspected.iterator()).hasNext() || (b = iterator.next()).test((BlockPredicate)hint.getLeft())) continue;
            return true;
        }
        return false;
    }

    static {
        GsonBuilder gsonbuilder = new GsonBuilder();
        gsonbuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)new ITextComponent.Serializer());
        gsonbuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
        gsonbuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
        GSON = gsonbuilder.create();
    }
}

