/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ftgumod.api.FTGUAPI;
import ftgumod.api.util.predicate.ItemPredicate;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.JsonContext;

public class JsonContextPublic
extends JsonContext {
    private final Map<String, ItemPredicate> constants = new HashMap<String, ItemPredicate>();

    public JsonContextPublic(String modId) {
        super(modId);
    }

    @Nullable
    public ItemPredicate getConstant(String name) {
        return this.constants.get(name);
    }

    public void loadConstants(JsonObject[] jsons) {
        for (JsonObject json : jsons) {
            if (json.has("conditions") && !CraftingHelper.processConditions((JsonArray)json.getAsJsonArray("conditions"), (JsonContext)this)) continue;
            if (!json.has("ingredient")) {
                throw new JsonSyntaxException("Constant entry must contain 'ingredient' value");
            }
            this.constants.put(JsonUtils.func_151200_h((JsonObject)json, (String)"name"), FTGUAPI.stackUtils.getItemPredicate(json.get("ingredient"), this));
        }
    }
}

