/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.util.predicate;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class BlockPredicate {
    public static final BlockPredicate ANY = new BlockPredicate(null, null, LocationPredicate.field_193455_a);
    private final Block block;
    private final Map<IProperty<?>, Object> properties;
    private final LocationPredicate location;

    public BlockPredicate(Block block, Map<IProperty<?>, Object> properties, LocationPredicate location) {
        this.block = block;
        this.properties = properties;
        this.location = location;
    }

    public static BlockPredicate deserialize(JsonObject object) {
        if (!(object.has("block") || object.has("state") || object.has("location"))) {
            return ANY;
        }
        Block block = null;
        if (object.has("block")) {
            ResourceLocation location = new ResourceLocation(JsonUtils.func_151200_h((JsonObject)object, (String)"block"));
            if (!Block.field_149771_c.func_148741_d((Object)location)) {
                throw new JsonSyntaxException("Unknown block type '" + location + "'");
            }
            block = (Block)Block.field_149771_c.func_82594_a((Object)location);
        }
        HashMap properties = null;
        if (object.has("state")) {
            if (block == null) {
                throw new JsonSyntaxException("Can't define block state without a specific block type");
            }
            BlockStateContainer blockState = block.func_176194_O();
            for (Map.Entry entry : JsonUtils.func_152754_s((JsonObject)object, (String)"state").entrySet()) {
                IProperty property = blockState.func_185920_a((String)entry.getKey());
                if (property == null) {
                    throw new JsonSyntaxException("Unknown block state property '" + (String)entry.getKey() + "' for block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                }
                String name = JsonUtils.func_151206_a((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                Optional optional = property.func_185929_b(name);
                if (!optional.isPresent()) {
                    throw new JsonSyntaxException("Invalid block state value '" + name + "' for property '" + (String)entry.getKey() + "' on block '" + Block.field_149771_c.func_177774_c((Object)block) + "'");
                }
                if (properties == null) {
                    properties = Maps.newHashMap();
                }
                properties.put(property, optional.get());
            }
        }
        LocationPredicate location = LocationPredicate.func_193454_a((JsonElement)object.get("location"));
        return new BlockPredicate(block, properties, location);
    }

    public boolean test(WorldServer world, BlockPos pos, IBlockState state) {
        if (this == ANY) {
            return true;
        }
        if (this.block != null && state.func_177230_c() != this.block) {
            return false;
        }
        if (this.properties != null) {
            for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                if (state.func_177229_b(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
        }
        return this.location.func_193453_a(world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
    }

    public boolean test(WorldServer world, BlockPos pos, Block block, Map<IProperty<?>, Object> properties) {
        if (this == ANY) {
            return true;
        }
        if (this.block != null && block != this.block) {
            return false;
        }
        if (this.properties != null) {
            for (Map.Entry<IProperty<?>, Object> entry : this.properties.entrySet()) {
                if (properties.get(entry.getKey()) == entry.getValue()) continue;
                return false;
            }
        }
        return this.location.func_193453_a(world, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
    }
}

