/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.util.predicate;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import ftgumod.api.util.predicate.BlockPredicate;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class BlockPredicateCompound
extends BlockPredicate {
    private final Iterable<BlockPredicate> compound;

    public BlockPredicateCompound(Iterable<BlockPredicate> compound) {
        super(null, null, null);
        this.compound = compound;
    }

    public static BlockPredicate deserialize(JsonElement element) {
        if (element.isJsonArray()) {
            HashSet<BlockPredicate> compound = new HashSet<BlockPredicate>();
            for (JsonElement e : element.getAsJsonArray()) {
                compound.add(BlockPredicateCompound.deserialize(e));
            }
            return new BlockPredicateCompound(compound);
        }
        if (element.isJsonObject()) {
            return BlockPredicate.deserialize(element.getAsJsonObject());
        }
        throw new JsonSyntaxException("Expected decipher to be an object or an array of objects");
    }

    @Override
    public boolean test(WorldServer world, BlockPos pos, IBlockState state) {
        for (BlockPredicate predicate : this.compound) {
            if (!predicate.test(world, pos, state)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean test(WorldServer world, BlockPos pos, Block block, Map<IProperty<?>, Object> properties) {
        for (BlockPredicate predicate : this.compound) {
            if (!predicate.test(world, pos, block, properties)) continue;
            return true;
        }
        return false;
    }
}

