/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.api.util.predicate;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ftgumod.api.util.predicate.ItemPredicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class ItemFluid
extends ItemPredicate {
    private final FluidStack fluid;

    public ItemFluid(FluidStack fluid) {
        super(FluidUtil.getFilledBucket((FluidStack)fluid));
        this.fluid = fluid;
    }

    public boolean apply(ItemStack itemStack) {
        FluidStack stack = FluidUtil.getFluidContained((ItemStack)itemStack);
        return stack != null && stack.containsFluid(this.fluid);
    }

    public static class Factory
    implements ItemPredicate.Factory {
        @Override
        public ItemPredicate apply(JsonObject json) {
            String name = JsonUtils.func_151200_h((JsonObject)json, (String)"fluid");
            Fluid fluid = FluidRegistry.getFluid((String)name);
            if (fluid == null) {
                throw new JsonSyntaxException("Unknown fluid " + name);
            }
            return new ItemFluid(new FluidStack(fluid, JsonUtils.func_151208_a((JsonObject)json, (String)"count", (int)1000)));
        }
    }
}

