/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.client.gui;

import ftgumod.Content;
import ftgumod.FTGU;
import ftgumod.api.technology.ITechnology;
import ftgumod.api.technology.unlock.IUnlock;
import ftgumod.packet.PacketDispatcher;
import ftgumod.packet.server.CopyTechMessage;
import ftgumod.proxy.ProxyClient;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import ftgumod.util.StackUtils;
import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public class GuiResearchBook
extends GuiScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ResourceLocation ACHIEVEMENT_BACKGROUND = new ResourceLocation("ftgumod", "textures/gui/achievement/achievement_background.png");
    private static final ResourceLocation STAINED_CLAY = new ResourceLocation("textures/blocks/hardened_clay_stained_cyan.png");
    private static final ResourceLocation RECIPE_BOOK = new ResourceLocation("textures/gui/recipe_book.png");
    public static Map<ResourceLocation, Float> zoom;
    public static Map<ResourceLocation, Double> xScrollO;
    public static Map<ResourceLocation, Double> yScrollO;
    private static boolean state;
    private static Technology root;
    private static Technology selected;
    private static int scroll;
    private final EntityPlayer player;
    private final int num = 4;
    private int x_min;
    private int y_min;
    private int x_max;
    private int y_max;
    private final int imageWidth;
    private final int imageHeight;
    private double xScrollP;
    private double yScrollP;
    private double xScrollTarget;
    private double yScrollTarget;
    private int scrolling;
    private double xLastScroll;
    private double yLastScroll;
    private int pages;

    public GuiResearchBook(EntityPlayer player) {
        this.player = player;
        this.imageWidth = 256;
        this.imageHeight = 202;
        if (root == null || !TechnologyManager.INSTANCE.contains(root) || !root.canResearchIgnoreResearched(player)) {
            for (Technology technology : TechnologyManager.INSTANCE.getRoots()) {
                if (!technology.canResearchIgnoreResearched(player)) continue;
                root = technology;
                break;
            }
        }
    }

    public void func_73866_w_() {
        if (selected == null || !TechnologyManager.INSTANCE.contains(selected) || !selected.isResearched(this.player)) {
            selected = null;
            state = true;
        }
        this.xScrollP = this.xScrollTarget = xScrollO.get(root.getRegistryName()).doubleValue();
        this.yScrollP = this.yScrollTarget = yScrollO.get(root.getRegistryName()).doubleValue();
        this.field_146292_n.clear();
        if (state) {
            HashSet<Technology> tree = new HashSet<Technology>();
            root.getChildren(tree, true);
            this.x_min = (int)root.getDisplayInfo().func_192299_e();
            this.y_min = (int)root.getDisplayInfo().func_192296_f();
            this.x_max = (int)root.getDisplayInfo().func_192299_e();
            this.y_max = (int)root.getDisplayInfo().func_192296_f();
            for (Technology technology : tree) {
                if (technology.getDisplayInfo().func_192299_e() < (float)this.x_min) {
                    this.x_min = (int)technology.getDisplayInfo().func_192299_e();
                } else if (technology.getDisplayInfo().func_192299_e() > (float)this.x_max) {
                    this.x_max = (int)technology.getDisplayInfo().func_192299_e();
                }
                if (technology.getDisplayInfo().func_192296_f() < (float)this.y_min) {
                    this.y_min = (int)technology.getDisplayInfo().func_192296_f();
                    continue;
                }
                if (!(technology.getDisplayInfo().func_192296_f() > (float)this.y_max)) continue;
                this.y_max = (int)technology.getDisplayInfo().func_192296_f();
            }
            this.x_min = this.x_min * 24 - 112;
            this.y_min = this.y_min * 24 - 112;
            this.x_max = this.x_max * 24 - 77;
            this.y_max = this.y_max * 24 - 77;
            GuiButton page = new GuiButton(2, (this.field_146294_l - this.imageWidth) / 2 + 24, this.field_146295_m / 2 + 74, 125, 20, root.getDisplayInfo().func_192297_a().func_150254_d());
            if (TechnologyManager.INSTANCE.getRoots().stream().filter(t -> t.canResearchIgnoreResearched(this.player)).count() < 2L) {
                page.field_146124_l = false;
            }
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 24, this.field_146295_m / 2 + 74, 80, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            this.field_146292_n.add(page);
            scroll = 1;
        } else {
            this.field_146292_n.add(new GuiButton(1, this.field_146294_l / 2 + 24, this.field_146295_m / 2 + 74, 80, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])));
            if (FTGU.copy && selected.canCopy()) {
                GuiButton copy = new GuiButton(2, (this.field_146294_l - this.imageWidth) / 2 + 24, this.field_146295_m / 2 + 74, 125, 20, I18n.func_135052_a((String)"gui.copy", (Object[])new Object[0]));
                copy.field_146124_l = false;
                for (int i = 0; i < this.player.field_71071_by.func_70302_i_(); ++i) {
                    if (this.player.field_71071_by.func_70301_a(i).func_190926_b() || this.player.field_71071_by.func_70301_a(i).func_77973_b() != Content.i_parchmentEmpty) continue;
                    copy.field_146124_l = true;
                    break;
                }
                this.field_146292_n.add(copy);
            }
            this.pages = (int)Math.max(Math.ceil((double)selected.getUnlock().stream().filter(IUnlock::isDisplayed).count() / 4.0), 1.0);
        }
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 1) {
            if (state) {
                this.field_146297_k.func_147108_a(null);
                this.field_146297_k.func_71381_h();
            } else {
                state = true;
                this.func_73866_w_();
            }
        } else if (button.field_146127_k == 2) {
            if (state) {
                Technology first = null;
                boolean next = false;
                for (Technology technology : TechnologyManager.INSTANCE.getRoots()) {
                    if (technology.canResearchIgnoreResearched(this.player)) {
                        if (next) {
                            next = false;
                            root = technology;
                            break;
                        }
                        if (first == null) {
                            first = technology;
                        }
                    }
                    if (technology != root) continue;
                    next = true;
                }
                if (next) {
                    root = first;
                }
                this.func_73866_w_();
            } else {
                PacketDispatcher.sendToServer(new CopyTechMessage(selected));
            }
        }
    }

    protected void func_73869_a(char key, int id) throws IOException {
        if (this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(id) || ProxyClient.key.isActiveAndMatches(id)) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.func_71381_h();
        } else {
            super.func_73869_a(key, id);
        }
    }

    public void func_73863_a(int x, int y, float z) {
        if (state) {
            if (Mouse.isButtonDown((int)0)) {
                int i = (this.field_146294_l - this.imageWidth) / 2;
                int j = (this.field_146295_m - this.imageHeight) / 2;
                int k = i + 8;
                int l = j + 17;
                if ((this.scrolling == 0 || this.scrolling == 1) && x >= k && x < k + 224 && y >= l && y < l + 155) {
                    if (this.scrolling == 0) {
                        this.scrolling = 1;
                    } else {
                        this.xScrollP -= (double)((float)((double)x - this.xLastScroll) * zoom.get(root.getRegistryName()).floatValue());
                        this.yScrollP -= (double)((float)((double)y - this.yLastScroll) * zoom.get(root.getRegistryName()).floatValue());
                        this.xScrollTarget = this.xScrollP;
                        this.yScrollTarget = this.yScrollP;
                        xScrollO.put(root.getRegistryName(), this.xScrollP);
                        yScrollO.put(root.getRegistryName(), this.yScrollP);
                    }
                    this.xLastScroll = x;
                    this.yLastScroll = y;
                }
            } else {
                this.scrolling = 0;
            }
            int i1 = Mouse.getDWheel();
            float f3 = zoom.get(root.getRegistryName()).floatValue();
            zoom.put(root.getRegistryName(), Float.valueOf(MathHelper.func_76131_a((float)(i1 < 0 ? f3 + 0.25f : (i1 > 0 ? f3 - 0.25f : f3)), (float)1.0f, (float)2.0f)));
            if (zoom.get(root.getRegistryName()).floatValue() != f3) {
                float f4 = f3 * (float)this.imageWidth;
                float f = f3 * (float)this.imageHeight;
                float f1 = zoom.get(root.getRegistryName()).floatValue() * (float)this.imageWidth;
                float f2 = zoom.get(root.getRegistryName()).floatValue() * (float)this.imageHeight;
                this.xScrollP -= (double)((f1 - f4) * 0.5f);
                this.yScrollP -= (double)((f2 - f) * 0.5f);
                this.xScrollTarget = this.xScrollP;
                this.yScrollTarget = this.yScrollP;
                xScrollO.put(root.getRegistryName(), this.xScrollP);
                yScrollO.put(root.getRegistryName(), this.yScrollP);
            }
            if (this.xScrollTarget < (double)this.x_min) {
                this.xScrollTarget = this.x_min;
            }
            if (this.yScrollTarget < (double)this.y_min) {
                this.yScrollTarget = this.y_min;
            }
            if (this.xScrollTarget >= (double)this.x_max) {
                this.xScrollTarget = this.x_max - 1;
            }
            if (this.yScrollTarget >= (double)this.y_max) {
                this.yScrollTarget = this.y_max - 1;
            }
        }
        this.func_146276_q_();
        this.drawResearchScreen(x, y, z);
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        this.drawTitle();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public void func_73864_a(int x, int y, int b) throws IOException {
        if (b == 0 && selected != null && selected.isResearched(this.player)) {
            state = false;
            this.func_73866_w_();
        }
        super.func_73864_a(x, y, b);
    }

    public void func_73876_c() {
        xScrollO.put(root.getRegistryName(), this.xScrollP);
        yScrollO.put(root.getRegistryName(), this.yScrollP);
        double d0 = this.xScrollTarget - this.xScrollP;
        double d1 = this.yScrollTarget - this.yScrollP;
        if (d0 * d0 + d1 * d1 < 4.0) {
            this.xScrollP += d0;
            this.yScrollP += d1;
        } else {
            this.xScrollP += d0 * 0.85;
            this.yScrollP += d1 * 0.85;
        }
    }

    private void drawTitle() {
        int i = (this.field_146294_l - this.imageWidth) / 2;
        int j = (this.field_146295_m - this.imageHeight) / 2;
        this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"item.research_book.name", (Object[])new Object[0]), i + 15, j + 5, 0x404040);
    }

    private void drawResearchScreen(int x, int y, float z) {
        int k = (this.field_146294_l - this.imageWidth) / 2;
        int l = (this.field_146295_m - this.imageHeight) / 2;
        int i1 = k + 16;
        int j1 = l + 17;
        GlStateManager.func_179143_c((int)518);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)i1, (float)j1, (float)-200.0f);
        GlStateManager.func_179098_w();
        GlStateManager.func_179140_f();
        GlStateManager.func_179091_B();
        GlStateManager.func_179142_g();
        for (int l3 = 0; l3 < 10; ++l3) {
            for (int i4 = 0; i4 < 14; ++i4) {
                if (root.getDisplayInfo().func_192293_c() == null) {
                    this.field_146297_k.func_110434_K().func_110577_a(STAINED_CLAY);
                } else {
                    this.field_146297_k.func_110434_K().func_110577_a(root.getDisplayInfo().func_192293_c());
                }
                GuiResearchBook.func_146110_a((int)(i4 * 16), (int)(l3 * 16), (float)0.0f, (float)0.0f, (int)16, (int)16, (float)16.0f, (float)16.0f);
            }
        }
        this.field_146297_k.func_110434_K().func_110577_a(ACHIEVEMENT_BACKGROUND);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)515);
        if (state) {
            GlStateManager.func_179152_a((float)(1.0f / zoom.get(root.getRegistryName()).floatValue()), (float)(1.0f / zoom.get(root.getRegistryName()).floatValue()), (float)1.0f);
            int i = MathHelper.func_76128_c((double)(xScrollO.get(root.getRegistryName()) + (this.xScrollP - xScrollO.get(root.getRegistryName())) * (double)z));
            int j = MathHelper.func_76128_c((double)(yScrollO.get(root.getRegistryName()) + (this.yScrollP - yScrollO.get(root.getRegistryName())) * (double)z));
            if (i < this.x_min) {
                i = this.x_min;
            }
            if (j < this.y_min) {
                j = this.y_min;
            }
            if (i >= this.x_max) {
                i = this.x_max - 1;
            }
            if (j >= this.y_max) {
                j = this.y_max - 1;
            }
            HashSet<Technology> tech = new HashSet<Technology>();
            root.getChildren(tech, true);
            if (tech != null) {
                try {
                    for (Technology t1 : tech) {
                        if (!t1.canResearchIgnoreResearched(this.player) || !t1.isResearched(this.player) && !t1.isUnlocked(this.player) || t1.getDisplayInfo().func_193224_j() && !t1.isResearched(this.player) || t1.getParent() == null || !tech.contains(t1.getParent())) continue;
                        int xStart = (int)(t1.getDisplayInfo().func_192299_e() * 24.0f - (float)i + 11.0f);
                        int yStart = (int)(t1.getDisplayInfo().func_192296_f() * 24.0f - (float)j + 11.0f);
                        int xStop = (int)(t1.getParent().getDisplayInfo().func_192299_e() * 24.0f - (float)i + 11.0f);
                        int yStop = (int)(t1.getParent().getDisplayInfo().func_192296_f() * 24.0f - (float)j + 11.0f);
                        boolean flag = t1.isResearched(this.player);
                        int l4 = flag ? -6250336 : -16711936;
                        this.func_73730_a(xStart, xStop, yStart, l4);
                        this.func_73728_b(xStop, yStart, yStop, l4);
                        if (xStart > xStop) {
                            this.func_73729_b(xStart - 11 - 7, yStart - 5, 114, 234, 7, 11);
                            continue;
                        }
                        if (xStart < xStop) {
                            this.func_73729_b(xStart + 11, yStart - 5, 107, 234, 7, 11);
                            continue;
                        }
                        if (yStart > yStop) {
                            this.func_73729_b(xStart - 5, yStart - 11 - 7, 96, 234, 11, 7);
                            continue;
                        }
                        if (yStart >= yStop) continue;
                        this.func_73729_b(xStart - 5, yStart + 11, 96, 241, 11, 7);
                    }
                    selected = null;
                    float f3 = (float)(x - i1) * zoom.get(root.getRegistryName()).floatValue();
                    float f4 = (float)(y - j1) * zoom.get(root.getRegistryName()).floatValue();
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179091_B();
                    GlStateManager.func_179142_g();
                    for (Technology t2 : tech) {
                        if (!t2.canResearchIgnoreResearched(this.player) || !t2.isResearched(this.player) && !t2.isUnlocked(this.player) || t2.getDisplayInfo().func_193224_j() && !t2.isResearched(this.player)) continue;
                        int l6 = (int)(t2.getDisplayInfo().func_192299_e() * 24.0f - (float)i);
                        int j7 = (int)(t2.getDisplayInfo().func_192296_f() * 24.0f - (float)j);
                        if (l6 < -24 || j7 < -24 || (float)l6 > 224.0f * zoom.get(root.getRegistryName()).floatValue() || (float)j7 > 155.0f * zoom.get(root.getRegistryName()).floatValue()) continue;
                        if (t2.isResearched(this.player)) {
                            GlStateManager.func_179131_c((float)0.75f, (float)0.75f, (float)0.75f, (float)1.0f);
                        } else {
                            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                        this.field_146297_k.func_110434_K().func_110577_a(ACHIEVEMENT_BACKGROUND);
                        GlStateManager.func_179147_l();
                        if (t2.hasCustomUnlock()) {
                            this.func_73729_b(l6 - 2, j7 - 2, 26, 202, 26, 26);
                        } else {
                            this.func_73729_b(l6 - 2, j7 - 2, 0, 202, 26, 26);
                        }
                        GlStateManager.func_179084_k();
                        GlStateManager.func_179140_f();
                        GlStateManager.func_179089_o();
                        this.field_146296_j.func_180450_b(t2.getDisplayInfo().func_192298_b(), l6 + 3, j7 + 3);
                        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                        GlStateManager.func_179140_f();
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (!(f3 >= (float)l6) || !(f3 <= (float)(l6 + 22)) || !(f4 >= (float)j7) || !(f4 <= (float)(j7 + 22)) || !t2.canResearchIgnoreResearched(this.player)) continue;
                        selected = t2;
                    }
                }
                catch (ConcurrentModificationException e) {
                    LOGGER.debug("Prevented ConcurrentModificationException while rendering GuiResearchBook");
                }
            }
        } else {
            int n;
            int wheel = Mouse.getDWheel();
            if (wheel < 0) {
                scroll = Math.min(scroll + 1, this.pages);
            }
            if (wheel > 0) {
                scroll = Math.max(scroll - 1, 1);
            }
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            List display = selected.getUnlock().stream().filter(IUnlock::isDisplayed).collect(Collectors.toList());
            for (int pos = 0; pos < 4 && (n = pos + 4 * (scroll - 1)) < display.size(); ++pos) {
                ItemStack[] list = ((IUnlock)display.get(n)).getIcon().func_193365_a();
                NonNullList[] sub = new NonNullList[list.length];
                int length = 0;
                for (int q = 0; q < list.length; ++q) {
                    if (list[q].func_77952_i() == Short.MAX_VALUE) {
                        sub[q] = NonNullList.func_191196_a();
                        list[q].func_77973_b().func_150895_a(list[q].func_77973_b().func_77640_w(), sub[q]);
                    } else {
                        sub[q] = NonNullList.func_193580_a(null, (Object[])new ItemStack[]{list[q]});
                    }
                    length += sub[q].size();
                }
                list = new ItemStack[length];
                int pp = 0;
                for (NonNullList nonNullList : sub) {
                    for (ItemStack stack : nonNullList) {
                        list[pp++] = stack;
                    }
                }
                long tick = this.field_146297_k.field_71441_e.func_82737_E() / 30L;
                int index = (int)(tick % (long)list.length);
                ItemStack item = list[index];
                this.field_146297_k.func_110434_K().func_110577_a(ACHIEVEMENT_BACKGROUND);
                GlStateManager.func_179147_l();
                this.func_73729_b(6, 37 + pos * 28, 0, 202, 26, 26);
                GlStateManager.func_179084_k();
                GlStateManager.func_179140_f();
                GlStateManager.func_179089_o();
                this.field_146296_j.func_180450_b(item, 11, 42 + pos * 28);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179140_f();
                this.field_146289_q.func_175063_a(item.func_82833_r(), 35.0f, (float)(45 + pos * 28), 0xFFFFFF);
                if (x < i1 + 6 || x >= i1 + 32 || y < j1 + 37 + pos * 28 || y >= j1 + 63 + pos * 28) continue;
                int r = 0;
                for (IRecipe recipe : ForgeRegistries.RECIPES) {
                    if (!StackUtils.INSTANCE.isStackOf(item, recipe.func_77571_b())) continue;
                    this.field_146297_k.func_110434_K().func_110577_a(RECIPE_BOOK);
                    int xp = 31 + r * 25;
                    int yp = 38 + pos * 28;
                    this.func_73729_b(xp, yp, 152, 78, 24, 24);
                    int width = 3;
                    int height = 3;
                    if (recipe instanceof IShapedRecipe) {
                        IShapedRecipe shaped = (IShapedRecipe)recipe;
                        width = shaped.getRecipeWidth();
                        height = shaped.getRecipeHeight();
                    }
                    Iterator iterator = recipe.func_192400_c().iterator();
                    block11: for (int i = 0; i < height; ++i) {
                        int kk = 3 + i * 7;
                        for (int j = 0; j < width; ++j) {
                            if (!iterator.hasNext()) break block11;
                            ItemStack[] stack = ((Ingredient)iterator.next()).func_193365_a();
                            if (stack.length == 0) continue;
                            int l1 = 3 + j * 7;
                            GlStateManager.func_179094_E();
                            int i2 = (int)((float)(xp + l1) / 0.42f - 3.0f);
                            int j2 = (int)((float)(yp + kk) / 0.42f - 3.0f);
                            GlStateManager.func_179152_a((float)0.42f, (float)0.42f, (float)1.0f);
                            GlStateManager.func_179145_e();
                            this.field_146297_k.func_175599_af().func_180450_b(stack[(int)(tick % (long)stack.length)], i2, j2);
                            GlStateManager.func_179140_f();
                            GlStateManager.func_179121_F();
                        }
                    }
                    ++r;
                }
            }
        }
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(ACHIEVEMENT_BACKGROUND);
        this.func_73729_b(k, l, 0, 0, this.imageWidth, this.imageHeight);
        this.field_73735_i = 0.0f;
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179097_i();
        GlStateManager.func_179098_w();
        super.func_73863_a(x, y, z);
        if (selected != null) {
            if (state) {
                String s = selected.getDisplayInfo().func_192297_a().func_150254_d();
                String s1 = selected.getDisplayInfo().func_193222_b().func_150254_d();
                int children = 0;
                for (ITechnology child : selected.getChildren()) {
                    if (!child.isRoot()) continue;
                    ++children;
                }
                int i7 = x + 12;
                int k7 = y - 4;
                int j8 = Math.max(this.field_146289_q.func_78256_a(s), 120);
                int i9 = this.field_146289_q.func_78267_b(s1, j8);
                if (selected.isResearched(this.player) || children > 0) {
                    i9 += 12;
                }
                this.func_73733_a(i7 - 3, k7 - 3, i7 + j8 + 3, k7 + i9 + 3 + 12, -1073741824, -1073741824);
                this.field_146289_q.func_78279_b(s1, i7, k7 + 12, j8, -6250336);
                if (selected.isResearched(this.player)) {
                    this.field_146289_q.func_175063_a(I18n.func_135052_a((String)"technology.researched", (Object[])new Object[0]), (float)i7, (float)(k7 + i9 + 4), -7302913);
                } else if (children > 0) {
                    this.field_146289_q.func_175063_a(I18n.func_135052_a((String)(children == 1 ? "technology.tab" : "technology.tabs"), (Object[])new Object[0]), (float)i7, (float)(k7 + i9 + 4), -43691);
                }
                this.field_146289_q.func_175063_a(s, (float)i7, (float)k7, -1);
            } else {
                String s1 = selected.getDisplayInfo().func_192297_a().func_150254_d();
                int x1 = (this.field_146294_l - this.field_146289_q.func_78256_a(s1)) / 2;
                this.field_146289_q.func_175063_a(s1, (float)x1, (float)(l + 22), 0xFFFFFF);
                String s2 = selected.getDisplayInfo().func_193222_b().func_150254_d();
                int x2 = this.field_146294_l / 2;
                int y2 = l + 32;
                for (String s : this.field_146289_q.func_78271_c(s2, 211)) {
                    this.field_146289_q.func_175063_a(s, (float)(x2 - this.field_146289_q.func_78256_a(s) / 2), (float)y2, -6250336);
                    y2 += this.field_146289_q.field_78288_b;
                }
                String s3 = scroll + "/" + this.pages;
                int x3 = (this.field_146294_l + this.imageWidth) / 2 - this.field_146289_q.func_78256_a(s3);
                int y3 = (this.field_146295_m + this.imageHeight) / 2;
                this.field_146289_q.func_175063_a(s3, (float)(x3 - 21), (float)(y3 - 44), -6250336);
            }
        }
        GlStateManager.func_179126_j();
        GlStateManager.func_179145_e();
        RenderHelper.func_74518_a();
    }

    public boolean func_73868_f() {
        return false;
    }

    static {
        state = true;
        scroll = 1;
    }
}

