/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.command;

import ftgumod.api.technology.ITechnology;
import ftgumod.packet.PacketDispatcher;
import ftgumod.packet.client.TechnologyInfoMessage;
import ftgumod.packet.client.TechnologyMessage;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;

public class CommandTechnology
extends CommandBase {
    public static Technology findTechnology(String id) throws CommandException {
        Technology tech = TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(id));
        if (tech == null) {
            throw new CommandException("commands.technology.technologyNotFound", new Object[]{id});
        }
        return tech;
    }

    public String func_71517_b() {
        return "technology";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.technology.usage";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equals("reload")) {
            if (args.length != 1) throw new WrongUsageException("commands.technology.reload.usage", new Object[0]);
            TechnologyManager.INSTANCE.reload(new File(sender.func_184102_h().field_71305_c[0].func_72860_G().func_75765_b(), "data"));
            PacketDispatcher.sendToAll(new TechnologyInfoMessage(TechnologyManager.INSTANCE.cache));
            CommandTechnology.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.technology.reload.success", (Object[])new Object[0]);
            return;
        } else {
            ActionType type = ActionType.byName(args[0]);
            if (type != null) {
                if (args.length < 3) {
                    throw type.wrongUsage();
                }
                EntityPlayerMP player = CommandTechnology.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
                Mode mode = Mode.byName(args[2]);
                if (mode == null) {
                    throw type.wrongUsage();
                }
                PacketDispatcher.sendTo(new TechnologyMessage((EntityPlayer)player, true, this.perform(sender, args, (EntityPlayer)player, type, mode)), player);
                return;
            } else {
                if (!args[0].equals("test")) {
                    throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
                }
                if (args.length == 3) {
                    this.testTechnology(sender, (EntityPlayer)CommandTechnology.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]), CommandTechnology.findTechnology(args[2]));
                    return;
                } else {
                    if (args.length != 4) throw new WrongUsageException("commands.technology.test.usage", new Object[0]);
                    this.testCriterion(sender, (EntityPlayer)CommandTechnology.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]), CommandTechnology.findTechnology(args[2]), args[3]);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Technology[] perform(ICommandSender sender, String[] args, EntityPlayer player, ActionType type, Mode mode) throws CommandException {
        if (mode == Mode.EVERYTHING) {
            if (args.length != 3) throw mode.usage(type);
            LinkedHashSet<ITechnology> set = new LinkedHashSet<ITechnology>(TechnologyManager.INSTANCE.getTechnologies());
            type.perform(player, set);
            if (set.isEmpty()) {
                throw mode.fail(type, new Object[]{player.func_70005_c_()});
            }
            mode.success(sender, (ICommand)this, type, new Object[]{player.func_70005_c_(), set.size()});
            if (type != ActionType.GRANT) return new Technology[0];
            return set.toArray(new Technology[set.size()]);
        }
        if (args.length < 4) {
            throw mode.usage(type);
        }
        Technology tech = CommandTechnology.findTechnology(args[3]);
        if (mode == Mode.ONLY && args.length == 5) {
            if (!tech.getCriteria().keySet().contains(args[4])) {
                throw new CommandException("commands.technology.criterionNotFound", new Object[]{tech.getRegistryName(), args[4]});
            }
            if (!type.performCriterion(player, tech, args[4])) {
                throw new CommandException(type.translation + ".criterion.failed", new Object[]{tech.getRegistryName(), player.func_70005_c_(), args[4]});
            }
            CommandTechnology.func_152373_a((ICommandSender)sender, (ICommand)this, (String)(type.translation + ".criterion.success"), (Object[])new Object[]{tech.getRegistryName(), player.func_70005_c_(), args[4]});
            return new Technology[0];
        } else {
            if (args.length != 4) {
                throw mode.usage(type);
            }
            Set<Technology> set = this.getTechnologies(tech, mode);
            type.perform(player, set);
            if (set.isEmpty()) {
                throw mode.fail(type, new Object[]{tech.getRegistryName(), player.func_70005_c_()});
            }
            mode.success(sender, (ICommand)this, type, new Object[]{tech.getRegistryName(), player.func_70005_c_(), set.size()});
            if (type != ActionType.GRANT) return new Technology[0];
            return set.toArray(new Technology[set.size()]);
        }
    }

    private void testCriterion(ICommandSender sender, EntityPlayer player, Technology tech, String criterion) throws CommandException {
        if (!tech.hasCustomUnlock()) {
            throw new CommandException("commands.technology.criterionNotFound", new Object[]{tech.getRegistryName(), criterion});
        }
        Boolean progress = TechnologyManager.INSTANCE.getProgress(player, tech).getCriterionProgress(criterion);
        if (progress == null) {
            throw new CommandException("commands.technology.criterionNotFound", new Object[]{tech.getRegistryName(), criterion});
        }
        if (!progress.booleanValue()) {
            throw new CommandException("commands.technology.test.criterion.notDone", new Object[]{player.func_70005_c_(), tech.getRegistryName(), criterion});
        }
        CommandTechnology.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.technology.test.criterion.success", (Object[])new Object[]{player.func_70005_c_(), tech.getRegistryName(), criterion});
    }

    private void testTechnology(ICommandSender sender, EntityPlayer player, Technology tech) throws CommandException {
        if (!tech.isResearched(player)) {
            throw new CommandException("commands.technology.test.technology.notDone", new Object[]{player.func_70005_c_(), tech.getRegistryName()});
        }
        CommandTechnology.func_152373_a((ICommandSender)sender, (ICommand)this, (String)"commands.technology.test.technology.success", (Object[])new Object[]{player.func_70005_c_(), tech.getRegistryName()});
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return CommandTechnology.func_71530_a((String[])args, (String[])new String[]{"grant", "revoke", "test", "reload"});
        }
        ActionType type = ActionType.byName(args[0]);
        if (type != null) {
            if (args.length == 2) {
                return CommandTechnology.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            if (args.length == 3) {
                return CommandTechnology.func_71530_a((String[])args, (String[])new String[]{"only", "through", "from", "until", "everything"});
            }
            Mode mode = Mode.byName(args[2]);
            if (mode != null && mode != Mode.EVERYTHING) {
                Technology tech;
                if (args.length == 4) {
                    return CommandTechnology.func_175762_a((String[])args, TechnologyManager.INSTANCE.getRegistryNames());
                }
                if (args.length == 5 && mode == Mode.ONLY && (tech = TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(args[3]))) != null) {
                    return CommandTechnology.func_175762_a((String[])args, tech.getCriteria().keySet());
                }
            }
        }
        if (args[0].equals("test")) {
            Technology tech;
            if (args.length == 2) {
                return CommandTechnology.func_71530_a((String[])args, (String[])server.func_71213_z());
            }
            if (args.length == 3) {
                return CommandTechnology.func_175762_a((String[])args, TechnologyManager.INSTANCE.getRegistryNames());
            }
            if (args.length == 4 && (tech = TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(args[2]))) != null) {
                return CommandTechnology.func_175762_a((String[])args, tech.getCriteria().keySet());
            }
        }
        return Collections.emptyList();
    }

    private Set<Technology> getTechnologies(Technology tech, Mode mode) {
        LinkedHashSet<Technology> set = new LinkedHashSet<Technology>();
        if (mode.parents) {
            for (Technology parent = tech.getParent(); parent != null; parent = parent.getParent()) {
                set.add(parent);
            }
        }
        if (mode.children) {
            tech.getChildren(set, false);
        } else {
            set.add(tech);
        }
        return set;
    }

    public boolean func_82358_a(String[] args, int index) {
        return args.length > 1 && ("grant".equals(args[0]) || "revoke".equals(args[0]) || "test".equals(args[0])) && index == 1;
    }

    private static enum Mode {
        ONLY("only", false, false),
        THROUGH("through", true, true),
        FROM("from", false, true),
        UNTIL("until", true, false),
        EVERYTHING("everything", true, true);

        private final String name;
        private final boolean parents;
        private final boolean children;

        private Mode(String name, boolean parents, boolean children) {
            this.name = name;
            this.parents = parents;
            this.children = children;
        }

        private static Mode byName(String name) {
            for (Mode mode : Mode.values()) {
                if (!mode.name.equals(name)) continue;
                return mode;
            }
            return null;
        }

        private CommandException fail(ActionType type, Object ... args) {
            return new CommandException(type.translation + "." + this.name + ".failed", args);
        }

        private CommandException usage(ActionType type) {
            return new CommandException(type.translation + "." + this.name + ".usage", new Object[0]);
        }

        private void success(ICommandSender sender, ICommand command, ActionType type, Object ... args) {
            CommandBase.func_152373_a((ICommandSender)sender, (ICommand)command, (String)(type.translation + "." + this.name + ".success"), (Object[])args);
        }
    }

    private static enum ActionType {
        GRANT("grant"){

            @Override
            protected boolean perform(EntityPlayer player, Technology tech) {
                if (tech.isResearched(player)) {
                    return false;
                }
                tech.setResearched(player, true);
                return true;
            }

            @Override
            protected boolean performCriterion(EntityPlayer player, Technology tech, String criterion) {
                return tech.grantCriterion(player, criterion);
            }
        }
        ,
        REVOKE("revoke"){

            @Override
            protected boolean perform(EntityPlayer player, Technology tech) {
                if (!tech.hasProgress(player)) {
                    return false;
                }
                tech.removeResearched(player);
                return true;
            }

            @Override
            protected boolean performCriterion(EntityPlayer player, Technology tech, String criterion) {
                return tech.revokeCriterion(player, criterion);
            }
        };

        private final String name;
        private final String translation;

        private ActionType(String name) {
            this.name = name;
            this.translation = "commands.technology." + name;
        }

        private static ActionType byName(String name) {
            for (ActionType type : ActionType.values()) {
                if (!type.name.equals(name)) continue;
                return type;
            }
            return null;
        }

        private CommandException wrongUsage() {
            return new CommandException(this.translation + ".usage", new Object[0]);
        }

        private void perform(EntityPlayer player, Iterable<Technology> techs) {
            Iterator<Technology> iterator = techs.iterator();
            while (iterator.hasNext()) {
                if (this.perform(player, iterator.next())) continue;
                iterator.remove();
            }
        }

        protected abstract boolean perform(EntityPlayer var1, Technology var2);

        protected abstract boolean performCriterion(EntityPlayer var1, Technology var2, String var3);
    }
}

