/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.packet.client;

import ftgumod.FTGU;
import ftgumod.api.event.FTGUClientSyncEvent;
import ftgumod.api.technology.ITechnology;
import ftgumod.packet.MessageHandler;
import ftgumod.technology.CapabilityTechnology;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class TechnologyMessage
implements IMessage {
    private Collection<String> tech;
    private boolean force;
    private ITechnology[] toasts;

    public TechnologyMessage() {
    }

    public TechnologyMessage(EntityPlayer player, boolean force, ITechnology ... toasts) {
        CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null);
        if (cap == null) {
            throw new IllegalArgumentException();
        }
        this.tech = cap.getResearched();
        this.force = force;
        this.toasts = toasts;
    }

    public void fromBytes(ByteBuf buffer) {
        int i;
        this.force = buffer.readBoolean();
        this.tech = new HashSet<String>();
        int size = buffer.readInt();
        for (i = 0; i < size; ++i) {
            this.tech.add(ByteBufUtils.readUTF8String((ByteBuf)buffer));
        }
        this.toasts = new ITechnology[buffer.readInt()];
        for (i = 0; i < this.toasts.length; ++i) {
            this.toasts[i] = TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buffer)));
        }
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeBoolean(this.force);
        if (this.tech != null) {
            buffer.writeInt(this.tech.size());
            for (String s : this.tech) {
                ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)s);
            }
        } else {
            buffer.writeInt(0);
        }
        buffer.writeInt(this.toasts.length);
        for (ITechnology toast : this.toasts) {
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)toast.getRegistryName().toString());
        }
    }

    public static class TechnologyMessageHandler
    extends MessageHandler<TechnologyMessage> {
        @Override
        public IMessage handleMessage(EntityPlayer player, TechnologyMessage message) {
            if (player == null) {
                return null;
            }
            CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null);
            if (cap != null) {
                Technology tech;
                String[] split;
                if (!message.force && cap.getResearched().size() == message.tech.size()) {
                    return null;
                }
                ArrayList<String> researched = new ArrayList<String>(cap.getResearched());
                for (String name : researched) {
                    if (message.tech.contains(name)) continue;
                    cap.removeResearched(name);
                    split = name.split("#");
                    if (split.length != 2) continue;
                    tech = TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(split[0]));
                    TechnologyManager.INSTANCE.getProgress(player, tech).revokeCriterion(split[1]);
                }
                for (String name : message.tech) {
                    if (cap.isResearched(name)) continue;
                    cap.setResearched(name);
                    split = name.split("#");
                    if (split.length != 2) continue;
                    tech = TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(split[0]));
                    TechnologyManager.INSTANCE.getProgress(player, tech).grantCriterion(split[1]);
                }
                for (ITechnology toast : message.toasts) {
                    FTGU.PROXY.displayToastTechnology(toast);
                }
                FTGU.INSTANCE.runCompat("jei", new Object[0]);
                MinecraftForge.EVENT_BUS.post((Event)new FTGUClientSyncEvent.Post());
            }
            return null;
        }
    }
}

