/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.server;

import ftgumod.technology.TechnologyManager;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeBookServerImpl
extends RecipeBookServer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final EntityPlayerMP player;

    public RecipeBookServerImpl(EntityPlayerMP player) {
        this.player = player;
    }

    public void func_193835_a(List<IRecipe> recipes, EntityPlayerMP player) {
        recipes = new LinkedList<IRecipe>(recipes);
        recipes.removeIf(recipe -> TechnologyManager.INSTANCE.isLocked(recipe.func_77571_b(), (EntityPlayer)player));
        if (!recipes.isEmpty()) {
            super.func_193835_a(recipes, player);
        }
    }

    public void func_192825_a(NBTTagCompound tag) {
        this.field_192818_b = tag.func_74767_n("isGuiOpen");
        this.field_192819_c = tag.func_74767_n("isFilteringCraftable");
        NBTTagList nbttaglist = tag.func_150295_c("recipes", 8);
        ArrayList<IRecipe> list = new ArrayList<IRecipe>();
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ResourceLocation resourcelocation = new ResourceLocation(nbttaglist.func_150307_f(i));
            IRecipe irecipe = CraftingManager.func_193373_a((ResourceLocation)resourcelocation);
            if (irecipe == null) {
                LOGGER.info("Tried to load unrecognized recipe: {} removed now.", (Object)resourcelocation);
                continue;
            }
            this.func_194073_a(irecipe);
            if (!TechnologyManager.INSTANCE.isLocked(irecipe.func_77571_b(), (EntityPlayer)this.player)) continue;
            list.add(irecipe);
        }
        NBTTagList nbttaglist1 = tag.func_150295_c("toBeDisplayed", 8);
        for (int j = 0; j < nbttaglist1.func_74745_c(); ++j) {
            ResourceLocation resourcelocation1 = new ResourceLocation(nbttaglist1.func_150307_f(j));
            IRecipe irecipe1 = CraftingManager.func_193373_a((ResourceLocation)resourcelocation1);
            if (irecipe1 == null) {
                LOGGER.info("Tried to load unrecognized recipe: {} removed now.", (Object)resourcelocation1);
                continue;
            }
            this.func_193825_e(irecipe1);
        }
        if (!list.isEmpty()) {
            this.func_193834_b(list, this.player);
        }
    }

    public void addRecipes(List<IRecipe> recipes, EntityPlayerMP player) {
        super.func_193835_a(recipes, player);
    }
}

