/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.technology;

import java.util.Collection;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityTechnology {
    @CapabilityInject(value=ITechnology.class)
    public static Capability<ITechnology> TECH_CAP;

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone evt) {
        ITechnology cap1 = (ITechnology)evt.getOriginal().getCapability(TECH_CAP, null);
        ITechnology cap2 = (ITechnology)evt.getEntityPlayer().getCapability(TECH_CAP, null);
        if (cap1 != null && cap2 != null) {
            cap2.setResearched(cap1.getResearched());
            if (!cap1.isNew()) {
                cap2.setOld();
            }
        }
    }

    @SubscribeEvent
    public void onEntityConstruct(AttachCapabilitiesEvent evt) {
        if (evt.getObject() instanceof EntityPlayer) {
            evt.addCapability(new ResourceLocation("ftgumod", "ITechnology"), (ICapabilityProvider)new ICapabilitySerializable<NBTTagCompound>(){
                private final ITechnology inst = (ITechnology)TECH_CAP.getDefaultInstance();

                public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
                    return capability == TECH_CAP;
                }

                public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
                    return (T)(capability == TECH_CAP ? TECH_CAP.cast((Object)this.inst) : null);
                }

                public NBTTagCompound serializeNBT() {
                    return (NBTTagCompound)TECH_CAP.getStorage().writeNBT(TECH_CAP, (Object)this.inst, null);
                }

                public void deserializeNBT(NBTTagCompound nbt) {
                    TECH_CAP.getStorage().readNBT(TECH_CAP, (Object)this.inst, null, (NBTBase)nbt);
                }
            });
        }
    }

    public static class DefaultImpl
    implements ITechnology {
        private final Collection<String> tech = new HashSet<String>();
        private boolean isNew = true;

        @Override
        public boolean isResearched(String tech) {
            return this.tech.contains(tech);
        }

        @Override
        public void setResearched(String tech) {
            this.tech.add(tech);
        }

        @Override
        public Collection<String> getResearched() {
            return this.tech;
        }

        @Override
        public void setResearched(Collection<String> tech) {
            this.tech.addAll(tech);
        }

        @Override
        public void clear() {
            this.tech.clear();
        }

        @Override
        public boolean isNew() {
            return this.isNew;
        }

        @Override
        public void setOld() {
            this.isNew = false;
        }

        @Override
        public void removeResearched(String tech) {
            this.tech.remove(tech);
            this.tech.removeIf(string -> string.startsWith(tech + "#"));
        }
    }

    public static class Storage
    implements Capability.IStorage<ITechnology> {
        public NBTBase writeNBT(Capability<ITechnology> capability, ITechnology instance, EnumFacing side) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTTagList list = new NBTTagList();
            for (String s : instance.getResearched()) {
                list.func_74742_a((NBTBase)new NBTTagString(s));
            }
            compound.func_74757_a("new", instance.isNew());
            compound.func_74782_a("researched", (NBTBase)list);
            return compound;
        }

        public void readNBT(Capability<ITechnology> capability, ITechnology instance, EnumFacing side, NBTBase nbt) {
            NBTTagCompound compound = (NBTTagCompound)nbt;
            if (!compound.func_74767_n("new")) {
                instance.setOld();
            }
            NBTTagList list = compound.func_150295_c("researched", 8);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                instance.setResearched(list.func_150307_f(i));
            }
        }
    }

    public static interface ITechnology {
        public boolean isResearched(String var1);

        public boolean isNew();

        public void setOld();

        public void setResearched(String var1);

        public Collection<String> getResearched();

        public void setResearched(Collection<String> var1);

        public void clear();

        public void removeResearched(String var1);
    }
}

