/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.technology;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import ftgumod.Content;
import ftgumod.FTGU;
import ftgumod.api.technology.ITechnology;
import ftgumod.api.technology.recipe.IIdeaRecipe;
import ftgumod.api.technology.recipe.IResearchRecipe;
import ftgumod.api.technology.recipe.IdeaRecipe;
import ftgumod.api.technology.unlock.IUnlock;
import ftgumod.api.util.JsonContextPublic;
import ftgumod.event.TechnologyEvent;
import ftgumod.technology.CapabilityTechnology;
import ftgumod.technology.TechnologyBuilder;
import ftgumod.technology.TechnologyManager;
import ftgumod.technology.TechnologyProgress;
import ftgumod.util.ListenerTechnology;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Technology
implements ITechnology {
    private static final Logger LOGGER = LogManager.getLogger();
    private final Set<Technology> children = new HashSet<Technology>();
    private final ResourceLocation id;
    private final int level;
    ITextComponent displayText;
    DisplayInfo display;
    NonNullList<IUnlock> unlock;
    Technology parent;
    AdvancementRewards rewards;
    Map<String, Criterion> criteria;
    String[][] requirements;
    IIdeaRecipe idea;
    IResearchRecipe research;
    String stage;
    boolean start;
    boolean copy;

    Technology(ResourceLocation id, @Nullable Technology parent, DisplayInfo display, AdvancementRewards rewards, Map<String, Criterion> criteria, String[][] requirements, boolean start, boolean copy, @Nullable NonNullList<IUnlock> unlock, @Nullable IIdeaRecipe idea, @Nullable IResearchRecipe research, String stage) {
        this.id = id;
        this.parent = parent;
        this.display = display;
        this.start = start;
        this.copy = copy;
        this.rewards = rewards;
        this.criteria = criteria;
        this.requirements = requirements;
        this.unlock = unlock == null ? NonNullList.func_191196_a() : unlock;
        this.idea = idea;
        this.research = research;
        this.stage = stage;
        this.level = parent == null ? 1 : parent.level + 1;
        this.updateDisplayText();
    }

    public static Logger getLogger() {
        return LOGGER;
    }

    void updateDisplayText() {
        this.displayText = new TextComponentString("[");
        this.displayText.func_150256_b().func_150238_a(this.display.func_192291_d().func_193229_c());
        ITextComponent itextcomponent = this.display.func_192297_a().func_150259_f();
        TextComponentString itextcomponent1 = new TextComponentString("");
        ITextComponent itextcomponent2 = itextcomponent.func_150259_f();
        itextcomponent2.func_150256_b().func_150238_a(this.display.func_192291_d().func_193229_c());
        itextcomponent1.func_150257_a(itextcomponent2);
        itextcomponent1.func_150258_a("\n");
        itextcomponent1.func_150257_a(this.display.func_193222_b());
        itextcomponent.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)itextcomponent1));
        this.displayText.func_150257_a(itextcomponent);
        this.displayText.func_150258_a("]");
    }

    @Override
    public boolean canCopy() {
        return this.copy;
    }

    @Override
    public boolean researchedAtStart() {
        return this.start;
    }

    @Override
    public Set<ITechnology> getChildren() {
        return this.children;
    }

    public void getChildren(Collection<Technology> collection, boolean tree) {
        collection.add(this);
        this.children.forEach(tech -> {
            if (!tree || !tech.isRoot()) {
                tech.getChildren(collection, tree);
            }
        });
    }

    @Override
    public IResearchRecipe getResearchRecipe() {
        return this.research;
    }

    @Override
    public boolean hasResearchRecipe() {
        return this.research != null;
    }

    @Override
    public IIdeaRecipe getIdeaRecipe() {
        return this.idea;
    }

    @Override
    public boolean hasIdeaRecipe() {
        return this.idea != null;
    }

    @Override
    public boolean isRoot() {
        return !this.hasParent() || !this.getRegistryName().func_110623_a().substring(0, this.getRegistryName().func_110623_a().indexOf(47)).equals(this.parent.getRegistryName().func_110623_a().substring(0, this.parent.getRegistryName().func_110623_a().indexOf(47)));
    }

    @Override
    public DisplayInfo getDisplayInfo() {
        return this.display;
    }

    @Override
    public Technology getParent() {
        return this.parent;
    }

    @Override
    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public NonNullList<IUnlock> getUnlock() {
        return this.unlock;
    }

    @Override
    public boolean hasCustomUnlock() {
        return this.requirements.length > 0;
    }

    @Override
    public void setResearched(EntityPlayer player, boolean announce) {
        CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null);
        if (cap != null) {
            cap.setResearched(this.getRegistryName().toString());
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                this.addRecipes(playerMP);
                if (this.rewards != null) {
                    this.rewards.func_192113_a(playerMP);
                }
                for (Technology child : this.children) {
                    if (!child.hasCustomUnlock()) continue;
                    child.registerListeners(playerMP);
                }
                Content.c_technologyResearched.trigger((EntityPlayerMP)player, this);
                MinecraftForge.EVENT_BUS.post((Event)new TechnologyEvent.Research(player, this));
            }
            if (announce) {
                player.func_184102_h().func_184103_al().func_148539_a((ITextComponent)new TextComponentTranslation("chat.type.technology", new Object[]{player.func_145748_c_(), this.displayText}));
                for (Technology child : this.children) {
                    if (!child.isRoot() || !child.isUnlocked(player)) continue;
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("technology.complete.unlock.root", new Object[]{child.displayText}));
                }
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public void addRecipes(EntityPlayerMP player) {
        this.unlock.forEach(unlock -> unlock.unlock(player));
    }

    @Override
    public void removeResearched(EntityPlayer player) {
        CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null);
        if (cap != null) {
            if (this.isResearched(player)) {
                cap.removeResearched(this.getRegistryName().toString());
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP playerMP = (EntityPlayerMP)player;
                    this.unlock.forEach(unlock -> unlock.lock(playerMP));
                    for (Technology child : this.children) {
                        if (!child.hasCustomUnlock()) continue;
                        child.unregisterListeners(playerMP);
                    }
                    MinecraftForge.EVENT_BUS.post((Event)new TechnologyEvent.Revoke(player, this));
                }
            }
            if (this.hasCustomUnlock()) {
                TechnologyProgress progress = TechnologyManager.INSTANCE.getProgress(player, this);
                for (String criterion : progress.getCompletedCriteria()) {
                    if (!progress.revokeCriterion(criterion)) continue;
                    cap.removeResearched(this.getRegistryName() + "#" + criterion);
                }
                if (player instanceof EntityPlayerMP) {
                    this.registerListeners((EntityPlayerMP)player);
                }
            }
        }
    }

    @Override
    public Map<String, Criterion> getCriteria() {
        return this.criteria;
    }

    @Override
    public String[][] getRequirements() {
        return this.requirements;
    }

    @Override
    public boolean grantCriterion(EntityPlayer player, String name) {
        TechnologyProgress progress = TechnologyManager.INSTANCE.getProgress(player, this);
        boolean done = progress.isDone();
        if (progress.grantCriterion(name)) {
            ((CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null)).setResearched(this.getRegistryName() + "#" + name);
            if (player instanceof EntityPlayerMP) {
                EntityPlayerMP playerMP = (EntityPlayerMP)player;
                this.unregisterListeners(playerMP);
                if (!done && progress.isDone() && this.unlockedStage(player)) {
                    this.unlock(playerMP);
                }
            }
            return true;
        }
        return false;
    }

    public void unlock(EntityPlayerMP player) {
        MinecraftForge.EVENT_BUS.post((Event)new TechnologyEvent.Unlock((EntityPlayer)player, this));
        player.func_145747_a((ITextComponent)new TextComponentTranslation(this.isRoot() ? "technology.complete.unlock.root" : "technology.complete.unlock", new Object[]{this.displayText}));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 1.0f, 1.0f);
        Content.c_technologyUnlocked.trigger(player, this);
    }

    @Override
    public boolean revokeCriterion(EntityPlayer player, String name) {
        TechnologyProgress progress = TechnologyManager.INSTANCE.getProgress(player, this);
        boolean done = progress.isDone();
        if (progress.revokeCriterion(name)) {
            ((CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null)).removeResearched(this.getRegistryName() + "#" + name);
            if (player instanceof EntityPlayerMP) {
                this.registerListeners((EntityPlayerMP)player);
                if (done && !progress.isDone()) {
                    MinecraftForge.EVENT_BUS.post((Event)new TechnologyEvent.Revoke(player, this));
                }
            }
            return true;
        }
        return false;
    }

    public void registerListeners(EntityPlayerMP player) {
        TechnologyProgress progress = TechnologyManager.INSTANCE.getProgress((EntityPlayer)player, this);
        if (!progress.isDone()) {
            for (Map.Entry<String, Criterion> entry : this.criteria.entrySet()) {
                ICriterionTrigger trigger;
                ICriterionInstance instance;
                Boolean criterionProgress = progress.getCriterionProgress(entry.getKey());
                if (criterionProgress == null || criterionProgress.booleanValue() || (instance = entry.getValue().func_192143_a()) == null || (trigger = CriteriaTriggers.func_192119_a((ResourceLocation)instance.func_192244_a())) == null) continue;
                trigger.func_192165_a(player.func_192039_O(), new ListenerTechnology<ICriterionInstance>(instance, this, entry.getKey()));
            }
        }
    }

    public void unregisterListeners(EntityPlayerMP player) {
        boolean parent = this.parent != null && !this.parent.isResearched((EntityPlayer)player);
        TechnologyProgress progress = TechnologyManager.INSTANCE.getProgress((EntityPlayer)player, this);
        for (Map.Entry<String, Criterion> entry : this.criteria.entrySet()) {
            ICriterionTrigger trigger;
            ICriterionInstance instance;
            Boolean criterionProgress = progress.getCriterionProgress(entry.getKey());
            if (criterionProgress == null || !parent && !criterionProgress.booleanValue() && !progress.isDone() || (instance = entry.getValue().func_192143_a()) == null || (trigger = CriteriaTriggers.func_192119_a((ResourceLocation)instance.func_192244_a())) == null) continue;
            trigger.func_192164_b(player.func_192039_O(), new ListenerTechnology<ICriterionInstance>(instance, this, entry.getKey()));
        }
    }

    @Override
    public ITextComponent getDisplayText() {
        return this.displayText;
    }

    public boolean hasProgress(EntityPlayer player) {
        return this.isResearched(player) || this.hasCustomUnlock() && TechnologyManager.INSTANCE.getProgress(player, this).hasProgress();
    }

    @Override
    public boolean isResearched(EntityPlayer player) {
        CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null);
        return cap != null && cap.isResearched(this.getRegistryName().toString());
    }

    public boolean isUnlockedIgnoreStage(EntityPlayer player) {
        return !this.hasCustomUnlock() || TechnologyManager.INSTANCE.getProgress(player, this).isDone();
    }

    @Override
    public boolean isUnlocked(EntityPlayer player) {
        return this.unlockedStage(player) && this.isUnlockedIgnoreStage(player);
    }

    @Override
    public boolean canResearch(EntityPlayer player) {
        return !this.isResearched(player) && this.isUnlocked(player) && (this.parent == null || this.parent.isResearched(player));
    }

    @Override
    public TechnologyBuilder toBuilder() {
        return new TechnologyBuilder(this);
    }

    @Override
    public String getGameStage() {
        return this.stage;
    }

    private boolean unlockedStage(EntityPlayer player) {
        return this.stage == null || !FTGU.INSTANCE.runCompat("gamestages", player, this.stage);
    }

    public boolean canResearchIgnoreCustomUnlock(EntityPlayer player) {
        return !this.isResearched(player) && (this.parent == null || this.parent.isResearched(player));
    }

    public boolean canResearchIgnoreResearched(EntityPlayer player) {
        return this.isResearched(player) || this.isUnlocked(player) && (this.parent == null || this.parent.isResearched(player));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.id;
    }

    public static class Deserializer
    implements JsonDeserializer<Builder> {
        public Builder deserialize(JsonElement element, Type ignore, JsonDeserializationContext context) throws JsonParseException {
            if (!element.isJsonObject()) {
                throw new JsonSyntaxException("Expected technology to be an object");
            }
            JsonObject json = element.getAsJsonObject();
            ResourceLocation parent = json.has("parent") ? new ResourceLocation(JsonUtils.func_151200_h((JsonObject)json, (String)"parent")) : null;
            JsonObject displayObject = JsonUtils.func_152754_s((JsonObject)json, (String)"display");
            DisplayInfo display = DisplayInfo.func_192294_a((JsonObject)displayObject, (JsonDeserializationContext)context);
            if (displayObject.has("x") || displayObject.has("y")) {
                display.func_192292_a((float)JsonUtils.func_151203_m((JsonObject)displayObject, (String)"x"), (float)JsonUtils.func_151203_m((JsonObject)displayObject, (String)"y"));
            }
            AdvancementRewards rewards = (AdvancementRewards)JsonUtils.func_188177_a((JsonObject)json, (String)"rewards", (Object)AdvancementRewards.field_192114_a, (JsonDeserializationContext)context, AdvancementRewards.class);
            Map criteria = json.has("criteria") ? Criterion.func_192144_b((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"criteria"), (JsonDeserializationContext)context) : Collections.emptyMap();
            JsonArray array = JsonUtils.func_151213_a((JsonObject)json, (String)"requirements", (JsonArray)new JsonArray());
            String[][] requirements = new String[array.size()][];
            for (int i = 0; i < array.size(); ++i) {
                JsonArray subarray = JsonUtils.func_151207_m((JsonElement)array.get(i), (String)("requirements[" + i + "]"));
                requirements[i] = new String[subarray.size()];
                for (int j = 0; j < subarray.size(); ++j) {
                    requirements[i][j] = JsonUtils.func_151206_a((JsonElement)subarray.get(j), (String)("requirements[" + i + "][" + j + "]"));
                }
            }
            if (requirements.length == 0) {
                requirements = new String[criteria.size()][];
                int k = 0;
                for (String s2 : criteria.keySet()) {
                    requirements[k++] = new String[]{s2};
                }
            }
            for (String[] subarray : requirements) {
                if (subarray.length == 0 && criteria.isEmpty()) {
                    throw new JsonSyntaxException("Requirement entry cannot be empty");
                }
                String[] stringArray = subarray;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String s = stringArray[i];
                    if (criteria.containsKey(s)) continue;
                    throw new JsonSyntaxException("Unknown required criterion '" + s + "'");
                }
            }
            for (String s1 : criteria.keySet()) {
                boolean flag = false;
                for (String string : requirements) {
                    if (!ArrayUtils.contains((Object[])string, (Object)s1)) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                throw new JsonSyntaxException("Criterion '" + s1 + "' isn't a requirement for completion. This isn't supported behaviour, all criteria must be required.");
            }
            JsonArray unlock = json.has("unlock") ? JsonUtils.func_151214_t((JsonObject)json, (String)"unlock") : null;
            JsonObject idea = json.has("idea") ? JsonUtils.func_152754_s((JsonObject)json, (String)"idea") : null;
            JsonObject research = json.has("research") ? JsonUtils.func_152754_s((JsonObject)json, (String)"research") : null;
            String stage = JsonUtils.func_151219_a((JsonObject)json, (String)"gamestage", null);
            boolean start = JsonUtils.func_151209_a((JsonObject)json, (String)"start", (boolean)false);
            boolean copy = JsonUtils.func_151209_a((JsonObject)json, (String)"copy", (boolean)true);
            return new Builder(parent, display, rewards, criteria, requirements, start, copy, unlock, idea, research, stage);
        }
    }

    public static class Builder {
        private final ResourceLocation parentId;
        private final DisplayInfo display;
        private final AdvancementRewards rewards;
        private final Map<String, Criterion> criteria;
        private final String[][] requirements;
        private final JsonArray unlock;
        private final JsonObject idea;
        private final JsonObject research;
        private final String stage;
        private final boolean start;
        private final boolean copy;
        private Technology parent;

        private Builder(@Nullable ResourceLocation parent, DisplayInfo display, AdvancementRewards rewards, Map<String, Criterion> criteria, String[][] requirements, boolean start, boolean copy, @Nullable JsonArray unlock, @Nullable JsonObject idea, @Nullable JsonObject research, String stage) {
            this.parentId = parent;
            this.display = display;
            this.rewards = rewards;
            this.criteria = criteria;
            this.requirements = requirements;
            this.start = start;
            this.copy = copy;
            this.unlock = unlock;
            this.idea = idea;
            this.research = research;
            this.stage = stage;
        }

        public boolean resolveParent(Map<ResourceLocation, Technology> map) {
            if (this.parentId == null) {
                return true;
            }
            this.parent = map.get(this.parentId);
            return this.parent != null;
        }

        public Technology build(ResourceLocation location, JsonContextPublic context) {
            NonNullList unlock = NonNullList.func_191196_a();
            if (this.unlock != null) {
                for (JsonElement element : this.unlock) {
                    unlock.add((Object)TechnologyManager.INSTANCE.getUnlock(element, context, location));
                }
            }
            IdeaRecipe idea = this.idea == null ? null : IdeaRecipe.deserialize(this.idea, context);
            IResearchRecipe research = this.research == null ? null : TechnologyManager.INSTANCE.getPuzzle((JsonElement)this.research, context, location);
            Technology r = new Technology(location, this.parent, this.display, this.rewards, this.criteria, this.requirements, this.start, this.copy, (NonNullList<IUnlock>)unlock, idea, research, this.stage);
            if (research != null) {
                research.setTechnology(r);
            }
            return r;
        }
    }
}

