/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.technology;

import ftgumod.api.technology.ITechnologyBuilder;
import ftgumod.api.technology.recipe.IIdeaRecipe;
import ftgumod.api.technology.recipe.IResearchRecipe;
import ftgumod.api.technology.unlock.IUnlock;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class TechnologyBuilder
implements ITechnologyBuilder {
    private final ResourceLocation id;
    private Technology original;
    private ResourceLocation parent;
    private DisplayInfo display;
    private AdvancementRewards rewards;
    private Map<String, Criterion> criteria;
    private String[][] requirements;
    private boolean start;
    private boolean copy;
    private NonNullList<IUnlock> unlock;
    private IIdeaRecipe idea;
    private IResearchRecipe research;
    private String stage;

    public TechnologyBuilder(ResourceLocation id) {
        this.original = null;
        this.id = id;
        this.rewards = AdvancementRewards.field_192114_a;
        this.criteria = Collections.emptyMap();
        this.requirements = new String[0][];
        this.start = false;
        this.copy = true;
        this.unlock = NonNullList.func_191196_a();
    }

    public TechnologyBuilder(Technology tech) {
        this.original = tech;
        this.id = tech.getRegistryName();
        if (tech.hasParent()) {
            this.parent = tech.parent.getRegistryName();
        }
        this.display = tech.display;
        this.rewards = tech.rewards;
        this.criteria = tech.criteria;
        this.requirements = tech.requirements;
        this.start = tech.start;
        this.copy = tech.copy;
        this.unlock = tech.unlock;
        this.idea = tech.idea;
        this.research = tech.research;
        this.stage = tech.stage;
    }

    @Override
    public ITechnologyBuilder setParent(@Nullable ResourceLocation parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public ITechnologyBuilder setDisplayInfo(DisplayInfo display) {
        this.display = display;
        return this;
    }

    @Override
    public ITechnologyBuilder setRewards(AdvancementRewards rewards) {
        this.rewards = rewards;
        return this;
    }

    @Override
    public ITechnologyBuilder setCriteria(Map<String, Criterion> criteria, String[][] requirements) {
        this.criteria = criteria;
        this.requirements = requirements;
        return this;
    }

    @Override
    public ITechnologyBuilder setResearchedAtStart(boolean start) {
        this.start = start;
        return this;
    }

    @Override
    public ITechnologyBuilder setCanCopy(boolean copy) {
        this.copy = copy;
        return this;
    }

    @Override
    public ITechnologyBuilder addUnlock(IUnlock ... ingredients) {
        this.unlock.addAll(Arrays.asList(ingredients));
        return this;
    }

    @Override
    public ITechnologyBuilder setIdeaRecipe(IIdeaRecipe idea) {
        this.idea = idea;
        return this;
    }

    @Override
    public ITechnologyBuilder setResearchRecipe(IResearchRecipe research) {
        this.research = research;
        return this;
    }

    @Override
    public ITechnologyBuilder setGameStage(String stage) {
        this.stage = stage;
        return this;
    }

    @Override
    public void save() {
        Technology parent;
        if (this.original == null) {
            throw new NullPointerException("Trying to save to a null technology");
        }
        Technology technology = parent = this.parent == null ? null : TechnologyManager.INSTANCE.getTechnology(this.parent);
        if (this.parent != null && parent == null) {
            throw new NullPointerException("Unknown technology '" + this.parent + "'");
        }
        if (parent != this.original.parent) {
            if (this.original.parent != null) {
                this.original.parent.getChildren().remove(this.original);
            }
            if (parent != null) {
                parent.getChildren().add(this.original);
            }
        }
        this.original.parent = parent;
        this.original.display = this.display;
        this.original.rewards = this.rewards;
        this.original.criteria = this.criteria;
        this.original.requirements = this.requirements;
        this.original.start = this.start;
        this.original.copy = this.copy;
        this.original.unlock = this.unlock;
        this.original.idea = this.idea;
        this.original.research = this.research;
        this.original.updateDisplayText();
    }

    @Override
    public Technology build() {
        Technology parent;
        Technology technology = parent = this.parent == null ? null : TechnologyManager.INSTANCE.getTechnology(this.parent);
        if (this.parent != null && parent == null) {
            throw new NullPointerException("Unknown technology '" + this.parent + "'");
        }
        this.original = new Technology(this.id, parent, this.display, this.rewards, this.criteria, this.requirements, this.start, this.copy, this.unlock, this.idea, this.research, this.stage);
        return this.original;
    }
}

