/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.technology;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import ftgumod.FTGU;
import ftgumod.api.FTGUAPI;
import ftgumod.api.technology.ITechnology;
import ftgumod.api.technology.ITechnologyManager;
import ftgumod.api.technology.recipe.IResearchRecipe;
import ftgumod.api.technology.unlock.IUnlock;
import ftgumod.api.technology.unlock.UnlockCompound;
import ftgumod.api.technology.unlock.UnlockRecipe;
import ftgumod.api.util.JsonContextPublic;
import ftgumod.packet.PacketDispatcher;
import ftgumod.packet.client.TechnologyMessage;
import ftgumod.server.RecipeBookServerImpl;
import ftgumod.technology.CapabilityTechnology;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyBuilder;
import ftgumod.technology.TechnologyProgress;
import ftgumod.util.StackUtils;
import ftgumod.util.SubCollection;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.stats.RecipeBookServer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class TechnologyManager
implements ITechnologyManager,
Iterable<Technology> {
    public static final TechnologyManager INSTANCE = new TechnologyManager();
    private final Map<UUID, Map<Technology, TechnologyProgress>> progress = new HashMap<UUID, Map<Technology, TechnologyProgress>>();
    private final Map<ResourceLocation, Technology> technologies = new LinkedHashMap<ResourceLocation, Technology>();
    private final Collection<Technology> roots = new SubCollection<Technology>(this.technologies.values(), Technology::isRoot);
    private final Collection<Technology> start = new SubCollection<Technology>(this.technologies.values(), Technology::researchedAtStart);
    private final Map<ResourceLocation, IUnlock.Factory<?>> unlocks = new HashMap();
    private final Map<ResourceLocation, IResearchRecipe.Factory<?>> puzzles = new HashMap();
    private final List<Predicate<? super ITechnology>> removeCallback = new LinkedList<Predicate<? super ITechnology>>();
    private final List<Consumer<? super ITechnology>> addCallback = new LinkedList<Consumer<? super ITechnology>>();
    private final List<Runnable> createCallback = new LinkedList<Runnable>();
    public Map<String, Pair<String, Map<ResourceLocation, String>>> cache;

    private Map<JsonContextPublic, Map<ResourceLocation, String>> loadBuiltin() {
        HashMap<JsonContextPublic, Map<ResourceLocation, String>> json = new HashMap<JsonContextPublic, Map<ResourceLocation, String>>();
        Loader.instance().getActiveModList().forEach(mod -> {
            JsonContextPublic context = new JsonContextPublic(mod.getModId());
            HashMap map = new HashMap();
            CraftingHelper.findFiles((ModContainer)mod, (String)("assets/" + mod.getModId() + "/technologies"), root -> {
                Path path = root.resolve("_constants.json");
                if (path != null && Files.exists(path, new LinkOption[0])) {
                    BufferedReader reader = null;
                    try {
                        reader = Files.newBufferedReader(path);
                        JsonObject[] array = (JsonObject[])JsonUtils.func_193839_a((Gson)FTGU.GSON, (Reader)reader, JsonObject[].class);
                        context.loadConstants(array);
                    }
                    catch (JsonParseException | IOException e) {
                        Technology.getLogger().error("Couldn't read _constants.json from {}", (Object)mod.getModId(), (Object)e);
                        Boolean bl = false;
                        return bl;
                    }
                    finally {
                        IOUtils.closeQuietly((Reader)reader);
                    }
                }
                return true;
            }, (root, file) -> {
                String relative = root.relativize((Path)file).toString();
                if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_") || !relative.contains("/")) {
                    return true;
                }
                String name = FilenameUtils.removeExtension((String)relative);
                ResourceLocation id = new ResourceLocation(mod.getModId(), name);
                try {
                    map.put(id, new String(Files.readAllBytes(file)));
                }
                catch (JsonParseException | IOException e) {
                    Technology.getLogger().error("Couldn't read technology {} from {}", (Object)id, file, (Object)e);
                    return false;
                }
                return true;
            }, (boolean)true, (boolean)true);
            json.put(context, map);
        });
        return json;
    }

    public void unloadProgress(EntityPlayer player) {
        this.progress.remove(player.func_110124_au());
    }

    public IUnlock getUnlock(JsonElement element, JsonContextPublic context, ResourceLocation tech) {
        ResourceLocation type;
        JsonObject object;
        if (element.isJsonArray()) {
            NonNullList unlocks = NonNullList.func_191196_a();
            element.getAsJsonArray().forEach(json -> unlocks.add((Object)this.getUnlock((JsonElement)json, context, tech)));
            return new UnlockCompound((NonNullList<IUnlock>)unlocks);
        }
        if (element.isJsonObject() && (object = element.getAsJsonObject()).has("type") && this.unlocks.containsKey(type = new ResourceLocation(context.appendModId(JsonUtils.func_151200_h((JsonObject)object, (String)"type"))))) {
            return this.unlocks.get(type).deserialize(object, context, tech);
        }
        return new UnlockRecipe(StackUtils.INSTANCE.getItemPredicate(element, context));
    }

    public IResearchRecipe getPuzzle(JsonElement element, JsonContextPublic context, ResourceLocation technology) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            if (object.has("type")) {
                ResourceLocation type = new ResourceLocation(context.appendModId(JsonUtils.func_151200_h((JsonObject)object, (String)"type")));
                if (this.puzzles.containsKey(type)) {
                    return this.puzzles.get(type).deserialize(object, context, technology);
                }
                throw new JsonSyntaxException("Unknown puzzle type " + type);
            }
            throw new JsonSyntaxException("IPuzzle missing required field 'type'");
        }
        throw new JsonSyntaxException("Expected puzzle to be an object");
    }

    public Collection<Technology> getRoots() {
        return this.roots;
    }

    public Collection<Technology> getStart() {
        return this.start;
    }

    @Override
    public boolean isLocked(ItemStack stack, @Nullable EntityPlayer player) {
        boolean tech = false;
        if (!stack.func_190926_b()) {
            block0: for (Technology t : this.technologies.values()) {
                for (IUnlock unlock : t.getUnlock()) {
                    if (!unlock.unlocks(stack)) continue;
                    if (player == null) {
                        return true;
                    }
                    if (t.isResearched(player)) {
                        return false;
                    }
                    tech = true;
                    continue block0;
                }
            }
        }
        return tech;
    }

    @Override
    public void removeCallback(Predicate<? super ITechnology> predicate) {
        this.removeCallback.add(predicate);
    }

    @Override
    public void addCallback(Consumer<? super ITechnology> action) {
        this.addCallback.add(action);
    }

    @Override
    public void createCallback(Runnable action) {
        this.createCallback.add(action);
    }

    public TechnologyProgress getProgress(EntityPlayer player, Technology technology) {
        return this.progress.computeIfAbsent(player.func_110124_au(), uuid -> new HashMap()).computeIfAbsent(technology, tech -> {
            TechnologyProgress progress = new TechnologyProgress();
            progress.update(tech.getCriteria(), tech.getRequirements());
            CapabilityTechnology.ITechnology cap = (CapabilityTechnology.ITechnology)player.getCapability(CapabilityTechnology.TECH_CAP, null);
            for (String criterion : progress.getRemaningCriteria()) {
                if (!cap.isResearched(tech.getRegistryName().toString() + "#" + criterion)) continue;
                progress.grantCriterion(criterion);
            }
            return progress;
        });
    }

    public void clear() {
        this.progress.clear();
        this.technologies.clear();
        this.createCallback.forEach(Runnable::run);
    }

    public void reload(File data) {
        this.clear();
        this.cache = new HashMap<String, Pair<String, Map<ResourceLocation, String>>>();
        this.load(new File(FTGU.folder, "technologies"));
        this.load(new File(data, "technologies"));
        this.load();
    }

    private void load(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            for (File child : dir.listFiles(File::isDirectory)) {
                File constants = new File(child, "_constants.json");
                String context = null;
                if (constants.exists() && constants.isFile()) {
                    try {
                        context = new String(Files.readAllBytes(constants.toPath()));
                    }
                    catch (IOException e) {
                        Technology.getLogger().error("Couldn't read _constants.json from {}", (Object)child.getName(), (Object)e);
                    }
                }
                HashMap<ResourceLocation, String> techs = new HashMap<ResourceLocation, String>();
                for (File file : FileUtils.listFiles((File)child, (String[])new String[]{"json"}, (boolean)true)) {
                    if (file.getParentFile().equals(child)) continue;
                    ResourceLocation id = new ResourceLocation(child.getName(), FilenameUtils.removeExtension((String)child.toPath().relativize(file.toPath()).toString().replace('\\', '/')));
                    try {
                        techs.put(id, new String(Files.readAllBytes(file.toPath())));
                    }
                    catch (IOException e) {
                        Technology.getLogger().error("Couldn't read technology {} from {}", (Object)id, (Object)file, (Object)e);
                    }
                }
                if (this.cache.containsKey(child.getName())) {
                    ((Map)this.cache.get(child.getName()).getRight()).forEach(techs::putIfAbsent);
                    if (context == null) {
                        context = (String)this.cache.get(child.getName()).getLeft();
                    }
                }
                this.cache.put(child.getName(), (Pair<String, Map<ResourceLocation, String>>)Pair.of((Object)(context == null ? "[]" : context), techs));
            }
        } else {
            dir.mkdirs();
        }
    }

    public void removeFromCache(ResourceLocation tech) {
        if (this.cache.containsKey(tech.func_110624_b())) {
            Map map = (Map)this.cache.get(tech.func_110624_b()).getRight();
            map.remove(tech);
            if (map.isEmpty()) {
                this.cache.remove(tech.func_110624_b());
            }
        }
    }

    public void load() {
        Map<JsonContextPublic, Map> json = this.cache.entrySet().stream().collect(Collectors.toMap(entry -> {
            JsonContextPublic context = new JsonContextPublic((String)entry.getKey());
            try {
                JsonObject[] array = (JsonObject[])FTGU.GSON.fromJson((String)((Pair)entry.getValue()).getLeft(), JsonObject[].class);
                context.loadConstants(array);
            }
            catch (JsonParseException e) {
                Technology.getLogger().error("Couldn't read _constants.json from {}", (Object)context.getModId(), (Object)e);
            }
            return context;
        }, entry -> (Map)((Pair)entry.getValue()).getRight()));
        if (!FTGU.custom) {
            this.loadBuiltin().forEach((? super K context, ? super V map) -> {
                if (!json.containsKey(context)) {
                    json.put((JsonContextPublic)((Object)((Object)context)), (Map)map);
                } else {
                    map.forEach(((Map)json.get(context))::putIfAbsent);
                }
            });
        }
        HashMap builders = new HashMap();
        LinkedHashMap<ResourceLocation, Technology> technologies = new LinkedHashMap<ResourceLocation, Technology>();
        for (Map.Entry<JsonContextPublic, Map> entry2 : json.entrySet()) {
            HashMap map2 = new HashMap();
            for (Map.Entry file : entry2.getValue().entrySet()) {
                try {
                    map2.put(file.getKey(), FTGU.GSON.fromJson((String)file.getValue(), Technology.Builder.class));
                }
                catch (JsonParseException e) {
                    this.removeFromCache((ResourceLocation)file.getKey());
                    Technology.getLogger().error("Couldn't load technology " + file.getKey(), (Throwable)e);
                }
            }
            builders.put(entry2.getKey(), map2);
        }
        boolean load = true;
        while (!builders.isEmpty() && load) {
            load = false;
            for (Map.Entry domain : builders.entrySet()) {
                Iterator iterator = ((Map)domain.getValue()).entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry2 = iterator.next();
                    if (!((Technology.Builder)entry2.getValue()).resolveParent(technologies)) continue;
                    try {
                        Technology technology = ((Technology.Builder)entry2.getValue()).build((ResourceLocation)entry2.getKey(), (JsonContextPublic)((Object)domain.getKey()));
                        technologies.put(technology.getRegistryName(), technology);
                        load = true;
                    }
                    catch (JsonParseException e) {
                        this.removeFromCache((ResourceLocation)entry2.getKey());
                        Technology.getLogger().error("Couldn't load technology " + entry2.getKey(), (Throwable)e);
                    }
                    iterator.remove();
                }
            }
            if (load) continue;
            for (Map.Entry domain : builders.entrySet()) {
                for (Map.Entry entry3 : ((Map)domain.getValue()).entrySet()) {
                    this.removeFromCache((ResourceLocation)entry3.getKey());
                    Technology.getLogger().error("Couldn't load technology " + entry3.getKey());
                }
            }
        }
        this.registerAll(technologies.values().toArray(new Technology[technologies.size()]));
        int n = this.technologies.size();
        Technology.getLogger().info("Loaded " + n + " technolog" + (n != 1 ? "ies" : "y"));
    }

    @Override
    public void register(ITechnology value) {
        if (value instanceof Technology) {
            if (this._register((Technology)value)) {
                this.addCallback.forEach(action -> action.accept(value));
            }
        } else {
            throw new IllegalArgumentException("Technology instance is of unexpected class");
        }
    }

    private boolean _register(Technology value) {
        if (value == null || value.getRegistryName() == null) {
            throw new NullPointerException("Tried to register a technology that is null or has a null registry name");
        }
        for (Predicate<? super ITechnology> predicate : this.removeCallback) {
            if (!predicate.test(value)) continue;
            return false;
        }
        if (value.hasParent()) {
            value.getParent().getChildren().add(value);
        }
        this.technologies.put(value.getRegistryName(), value);
        if (value.start) {
            FTGU.PROXY.autoResearch(value);
        }
        return true;
    }

    @Override
    public void registerAll(ITechnology ... values) {
        for (ITechnology tech : values) {
            this.register(tech);
        }
    }

    @Override
    public boolean contains(ResourceLocation key) {
        return this.technologies.containsKey(key);
    }

    @Override
    public boolean contains(ITechnology value) {
        return this.technologies.containsValue(value);
    }

    @Override
    @Nullable
    public Technology getTechnology(ResourceLocation key) {
        return this.technologies.get(key);
    }

    @Override
    public TechnologyBuilder createBuilder(ResourceLocation id) {
        return new TechnologyBuilder(id);
    }

    @Override
    public Collection<ITechnology> getTechnologies() {
        return this.technologies.values();
    }

    @Override
    public Set<ResourceLocation> getRegistryNames() {
        return this.technologies.keySet();
    }

    @Override
    public void sync(EntityPlayerMP player, ITechnology ... toasts) {
        PacketDispatcher.sendTo(new TechnologyMessage((EntityPlayer)player, false, toasts), player);
    }

    @Override
    public void addRecipes(List<IRecipe> recipes, EntityPlayerMP player) {
        RecipeBookServer book = player.field_192041_cq;
        if (book instanceof RecipeBookServerImpl) {
            ((RecipeBookServerImpl)book).addRecipes(recipes, player);
        } else {
            book.func_193835_a(recipes, player);
        }
    }

    @Override
    public void registerUnlock(ResourceLocation name, IUnlock.Factory<?> factory) {
        this.unlocks.put(name, factory);
    }

    @Override
    public void registerPuzzle(ResourceLocation name, IResearchRecipe.Factory<?> factory) {
        this.puzzles.put(name, factory);
    }

    @Override
    public Iterator<Technology> iterator() {
        return this.technologies.values().iterator();
    }

    static {
        FTGUAPI.technologyManager = INSTANCE;
    }

    public static enum GUI {
        IDEATABLE,
        RESEARCHTABLE;

    }
}

