/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ftgumod.Content;
import ftgumod.api.FTGUAPI;
import ftgumod.api.technology.ITechnology;
import ftgumod.api.util.BlockSerializable;
import ftgumod.api.util.IStackUtils;
import ftgumod.api.util.JsonContextPublic;
import ftgumod.api.util.predicate.ItemCompound;
import ftgumod.api.util.predicate.ItemIngredient;
import ftgumod.api.util.predicate.ItemPredicate;
import ftgumod.item.ItemMagnifyingGlass;
import ftgumod.technology.Technology;
import ftgumod.technology.TechnologyManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.advancements.critereon.ItemPredicates;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class StackUtils
implements IStackUtils {
    public static final StackUtils INSTANCE = new StackUtils();
    private static final Map<ResourceLocation, ItemPredicate.Factory> REGISTRY = new HashMap<ResourceLocation, ItemPredicate.Factory>();

    public NBTTagCompound getItemData(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        return nbt;
    }

    @Override
    public boolean isStackOf(ItemStack ingredient, ItemStack stack) {
        return !(ingredient.func_77973_b() != stack.func_77973_b() || ingredient.func_77952_i() != Short.MAX_VALUE && ingredient.func_77952_i() != stack.func_77952_i() || ingredient.func_77942_o() && !ItemStack.func_77970_a((ItemStack)ingredient, (ItemStack)stack));
    }

    @Override
    public boolean isEqual(ItemStack s1, ItemStack s2) {
        return s1.func_77973_b() == s2.func_77973_b() && s1.func_77952_i() == s2.func_77952_i() && ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    @Override
    public ItemPredicate getItemPredicate(JsonElement element, JsonContextPublic context) {
        LinkedList<ItemPredicate> predicates = new LinkedList<ItemPredicate>();
        if (element.isJsonPrimitive()) {
            String item = element.getAsString();
            if (item.startsWith("#")) {
                ItemPredicate constant = context.getConstant(item.substring(1));
                if (constant == null) {
                    throw new JsonSyntaxException("Predicate referenced invalid constant: " + item);
                }
                return constant;
            }
            JsonObject object = new JsonObject();
            object.add("item", element);
            object.addProperty("data", (Number)Short.MAX_VALUE);
            return new ItemIngredient(CraftingHelper.getIngredient((JsonElement)object, (JsonContext)context));
        }
        if (element.isJsonArray()) {
            for (JsonElement json : element.getAsJsonArray()) {
                predicates.add(this.getItemPredicate(json, context));
            }
        } else {
            if (element.isJsonObject()) {
                ResourceLocation type;
                String item;
                JsonObject object = element.getAsJsonObject();
                if (!object.has("type") && object.has("item") && (item = JsonUtils.func_151200_h((JsonObject)object, (String)"item")).startsWith("#")) {
                    ItemPredicate constant = context.getConstant(item.substring(1));
                    if (constant == null) {
                        throw new JsonSyntaxException("Predicate referenced invalid constant: " + item);
                    }
                    return constant;
                }
                if (object.has("type") && REGISTRY.containsKey(type = new ResourceLocation(context.appendModId(JsonUtils.func_151200_h((JsonObject)object, (String)"type"))))) {
                    return (ItemPredicate)((Object)REGISTRY.get(type).apply(object));
                }
                return new ItemIngredient(CraftingHelper.getIngredient((JsonElement)object, (JsonContext)context));
            }
            throw new JsonSyntaxException("Expected predicate to be an object or an array of objects");
        }
        return new ItemCompound(predicates);
    }

    @Override
    public void registerItemPredicate(ResourceLocation location, ItemPredicate.Factory factory) {
        REGISTRY.put(location, factory);
        CraftingHelper.register((ResourceLocation)location, (IIngredientFactory)factory);
        ItemPredicates.register((ResourceLocation)location, factory.andThen());
    }

    @Override
    public ItemStack getParchment(ITechnology tech, IStackUtils.Parchment type) {
        ItemStack stack = new ItemStack(type == IStackUtils.Parchment.IDEA ? Content.i_parchmentIdea : Content.i_parchmentResearch);
        this.getItemData(stack).func_74778_a("FTGU", tech.getRegistryName().toString());
        return stack;
    }

    @Override
    @Nullable
    public Technology getTechnology(ItemStack parchment) {
        return TechnologyManager.INSTANCE.getTechnology(new ResourceLocation(this.getItemData(parchment).func_74779_i("FTGU")));
    }

    @Override
    public List<BlockSerializable> getInspected(ItemStack inspector) {
        return ItemMagnifyingGlass.getInspected(inspector);
    }

    static {
        FTGUAPI.stackUtils = INSTANCE;
    }
}

