/*
 * Decompiled with CFR 0.152.
 */
package ftgumod.util;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.function.Predicate;

public class SubCollection<T>
extends AbstractCollection<T> {
    private final Iterable<? extends T> iterable;
    private final Predicate<T> predicate;

    public SubCollection(Iterable<? extends T> iterable, Predicate<T> predicate) {
        this.iterable = iterable;
        this.predicate = predicate;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private final Iterator<? extends T> iterator;
            private T next;
            {
                this.iterator = SubCollection.this.iterable.iterator();
                this.next = this.getNext();
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object t = this.next;
                this.next = this.getNext();
                return t;
            }

            private T getNext() {
                Object t;
                while ((t = this.iterator.hasNext() ? (Object)this.iterator.next() : null) != null && !SubCollection.this.predicate.test(t)) {
                }
                return t;
            }
        };
    }

    @Override
    public int size() {
        int i = 0;
        for (T t : this.iterable) {
            if (!this.predicate.test(t)) continue;
            ++i;
        }
        return i;
    }
}

