/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.gci;

import de.cas_ual_ty.gci.GunCus;
import de.cas_ual_ty.gci.item.ItemGun;
import de.cas_ual_ty.gci.item.attachment.Attachment;
import de.cas_ual_ty.gci.item.attachment.EnumAttachmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ContainerGunTable
extends Container {
    public InventoryCrafting craftMatrix = new InventoryCrafting((Container)this, 3, 3);
    public EntityPlayer entityPlayer;
    public World world;
    public BlockPos pos;
    public Slot gunSlot;
    public SlotAttachment[] attachmentSlots;
    private boolean changing = false;
    private int attachmentAmmount = 0;

    public ContainerGunTable(EntityPlayer entityPlayer, World world, BlockPos pos) {
        this.entityPlayer = entityPlayer;
        this.world = world;
        this.pos = pos;
        this.gunSlot = new Slot((IInventory)this.craftMatrix, 4, 80, 35){

            public boolean func_75214_a(ItemStack itemStack) {
                if (!this.func_75216_d() && itemStack.func_77973_b() instanceof ItemGun) {
                    for (EnumAttachmentType attachmentType : EnumAttachmentType.values()) {
                        if (!ContainerGunTable.this.attachmentSlots[attachmentType.getSlot()].func_75216_d()) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
        this.func_75146_a(this.gunSlot);
        this.attachmentSlots = new SlotAttachment[EnumAttachmentType.values().length];
        for (EnumAttachmentType attachmentType : EnumAttachmentType.values()) {
            this.attachmentSlots[attachmentType.getSlot()] = new SlotAttachment(this.gunSlot, attachmentType.getSlot(), (IInventory)this.craftMatrix, attachmentType.getX() + attachmentType.getY() * 3, 8 + (attachmentType.getX() + 3) * 18, 17 + attachmentType.getY() * 18);
            this.func_75146_a(this.attachmentSlots[attachmentType.getSlot()]);
        }
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, l, 8 + l * 18, 142));
        }
    }

    public void func_75130_a(IInventory inventory) {
        if (!this.changing) {
            this.changing = true;
            if (inventory == this.craftMatrix) {
                if (this.gunSlot.func_75216_d()) {
                    int attachmentAmmount = 0;
                    for (EnumAttachmentType attachmentType : EnumAttachmentType.values()) {
                        if (!this.attachmentSlots[attachmentType.getSlot()].func_75216_d()) continue;
                        ++attachmentAmmount;
                    }
                    ItemStack gunStack = this.gunSlot.func_75211_c();
                    ItemGun gun = (ItemGun)gunStack.func_77973_b();
                    if (this.attachmentAmmount == 0) {
                        int n;
                        if (attachmentAmmount == 0) {
                            EnumAttachmentType[] enumAttachmentTypeArray = EnumAttachmentType.values();
                            int n2 = enumAttachmentTypeArray.length;
                            for (n = 0; n < n2; ++n) {
                                EnumAttachmentType attachmentType = enumAttachmentTypeArray[n];
                                this.attachmentSlots[attachmentType.getSlot()].func_75215_d(gun.getAttachment(gunStack, attachmentType.getSlot()).createItemStack());
                            }
                        } else {
                            EnumAttachmentType[] enumAttachmentTypeArray = EnumAttachmentType.values();
                            n = enumAttachmentTypeArray.length;
                            for (int attachmentType = 0; attachmentType < n; ++attachmentType) {
                                EnumAttachmentType attachmentType2 = enumAttachmentTypeArray[attachmentType];
                                if (this.attachmentSlots[attachmentType2.getSlot()].func_75216_d()) {
                                    Attachment attachment = (Attachment)this.attachmentSlots[attachmentType2.getSlot()].func_75211_c().func_77973_b();
                                    gun.setAttachment(gunStack, attachmentType2.getSlot(), attachment.getID());
                                    continue;
                                }
                                gun.setAttachment(gunStack, attachmentType2.getSlot(), 0);
                            }
                        }
                        this.attachmentAmmount = 0;
                        for (EnumAttachmentType attachmentType : EnumAttachmentType.values()) {
                            if (!this.attachmentSlots[attachmentType.getSlot()].func_75216_d()) continue;
                            ++this.attachmentAmmount;
                        }
                    } else {
                        for (EnumAttachmentType attachmentType : EnumAttachmentType.values()) {
                            if (this.attachmentSlots[attachmentType.getSlot()].func_75216_d()) {
                                Attachment attachment = (Attachment)this.attachmentSlots[attachmentType.getSlot()].func_75211_c().func_77973_b();
                                gun.setAttachment(gunStack, attachmentType.getSlot(), attachment.getID());
                                continue;
                            }
                            gun.setAttachment(gunStack, attachmentType.getSlot(), 0);
                        }
                    }
                } else {
                    for (EnumAttachmentType attachmentType : EnumAttachmentType.values()) {
                        this.attachmentSlots[attachmentType.getSlot()].func_75215_d(ItemStack.field_190927_a);
                    }
                    this.attachmentAmmount = 0;
                }
            }
            super.func_75130_a(inventory);
            this.changing = false;
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.world.func_180495_p(this.pos).func_177230_c() != GunCus.BLOCK_GUN_TABLE) {
            return false;
        }
        return playerIn.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    protected void clearContainer(EntityPlayer playerIn, World worldIn) {
        if (!playerIn.func_70089_S() || playerIn instanceof EntityPlayerMP && ((EntityPlayerMP)playerIn).func_193105_t()) {
            if (this.gunSlot.func_75216_d()) {
                playerIn.func_71019_a(this.gunSlot.func_75211_c(), false);
            } else {
                for (SlotAttachment slot : this.attachmentSlots) {
                    playerIn.func_71019_a(slot.func_75211_c(), false);
                }
            }
        } else if (this.gunSlot.func_75216_d()) {
            playerIn.field_71071_by.func_191975_a(worldIn, this.gunSlot.func_75211_c());
        } else {
            for (SlotAttachment slot : this.attachmentSlots) {
                playerIn.field_71071_by.func_191975_a(worldIn, slot.func_75211_c());
            }
        }
    }

    public void func_75134_a(EntityPlayer playerIn) {
        super.func_75134_a(playerIn);
        if (!this.world.field_72995_K) {
            this.clearContainer(playerIn, this.world);
        }
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        return super.func_184996_a(slotId, dragType, clickTypeIn, player);
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        Slot slot = this.func_75139_a(index);
        ItemStack itemStack = slot.func_75211_c();
        if (index >= 9) {
            Attachment attachment;
            if (itemStack.func_77973_b() instanceof ItemGun) {
                if (this.gunSlot.func_75214_a(itemStack)) {
                    this.gunSlot.func_75215_d(itemStack);
                    slot.func_75215_d(ItemStack.field_190927_a);
                }
            } else if (itemStack.func_77973_b() instanceof Attachment && this.attachmentSlots[(attachment = (Attachment)itemStack.func_77973_b()).getSlot()].func_75214_a(itemStack)) {
                this.attachmentSlots[attachment.getSlot()].func_75215_d(itemStack);
                slot.func_75215_d(ItemStack.field_190927_a);
            }
        } else if (playerIn.field_71071_by.func_70441_a(itemStack)) {
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        return ItemStack.field_190927_a;
    }

    public static class SlotAttachment
    extends Slot {
        public Slot main;
        public int slot;

        public SlotAttachment(Slot main, int slot, IInventory inventory, int id, int x, int y) {
            super(inventory, id, x, y);
            this.main = main;
            this.slot = slot;
        }

        public boolean func_75214_a(ItemStack itemStack) {
            if (this.main.func_75216_d() && !this.func_75216_d() && itemStack.func_77973_b() instanceof Attachment) {
                ItemGun gun = (ItemGun)this.main.func_75211_c().func_77973_b();
                Attachment attachment = (Attachment)itemStack.func_77973_b();
                return attachment.getSlot() == this.slot && gun.canSetAttachment(attachment);
            }
            return false;
        }
    }
}

