/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.gci.client;

import de.cas_ual_ty.gci.EntityBullet;
import de.cas_ual_ty.gci.GunCus;
import de.cas_ual_ty.gci.client.render.GuiSight;
import de.cas_ual_ty.gci.item.ItemGun;
import de.cas_ual_ty.gci.item.attachment.Accessory;
import de.cas_ual_ty.gci.item.attachment.EnumAttachmentType;
import de.cas_ual_ty.gci.item.attachment.Optic;
import de.cas_ual_ty.gci.network.MessageShoot;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EventHandlerClient {
    public static final GuiSight GUI_SIGHT = new GuiSight();
    private static final ModelRendererTransformationHelper TRANSFORMATION_HELPER = new ModelRendererTransformationHelper();
    private int tabCounter = 0;
    private static final int TAB_ITEM_INTERVAL = 20;

    public void onEvent(RenderPlayerEvent.Pre event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (!entityPlayer.func_70051_ag() && !entityPlayer.func_70093_af()) {
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun) {
                event.getRenderer().func_177087_b().field_178723_h.field_78807_k = true;
                if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_190926_b()) {
                    event.getRenderer().func_177087_b().field_178724_i.field_78807_k = true;
                }
            } else if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                event.getRenderer().func_177087_b().field_178724_i.field_78807_k = true;
            }
        }
    }

    public void onEvent(RenderPlayerEvent.Post event) {
        EntityPlayer entityPlayer = event.getEntityPlayer();
        if (!entityPlayer.func_70051_ag() && !entityPlayer.func_70093_af()) {
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(event.getRenderer().func_110775_a((AbstractClientPlayer)entityPlayer));
                if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                    event.getRenderer().func_177087_b().field_178723_h.field_78807_k = false;
                    TRANSFORMATION_HELPER.set(-MathHelper.func_76134_b((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, 20.0f, -MathHelper.func_76126_a((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, (float)Math.toRadians(90.0), (float)(-Math.toRadians(entityPlayer.field_70761_aq)), 0.0f).transformAndRender(entityPlayer, event.getRenderer().func_177087_b().field_178723_h, 0.0625f);
                    event.getRenderer().func_177087_b().field_178724_i.field_78807_k = false;
                    TRANSFORMATION_HELPER.set(MathHelper.func_76134_b((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, 20.0f, MathHelper.func_76126_a((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, (float)Math.toRadians(90.0), (float)(-Math.toRadians(entityPlayer.field_70761_aq)), 0.0f).transformAndRender(entityPlayer, event.getRenderer().func_177087_b().field_178724_i, 0.0625f);
                } else if (!entityPlayer.func_184592_cb().func_190926_b()) {
                    event.getRenderer().func_177087_b().field_178723_h.field_78807_k = false;
                    TRANSFORMATION_HELPER.set(-MathHelper.func_76134_b((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, 20.0f, -MathHelper.func_76126_a((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, (float)Math.toRadians(90.0), (float)(-Math.toRadians(entityPlayer.field_70761_aq)), 0.0f).transformAndRender(entityPlayer, event.getRenderer().func_177087_b().field_178723_h, 0.0625f);
                } else {
                    event.getRenderer().func_177087_b().field_178723_h.field_78807_k = false;
                    TRANSFORMATION_HELPER.set(-MathHelper.func_76134_b((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, 20.0f, -MathHelper.func_76126_a((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, (float)Math.toRadians(90.0), (float)(-Math.toRadians(entityPlayer.field_70761_aq)), 0.0f).transformAndRender(entityPlayer, event.getRenderer().func_177087_b().field_178723_h, 0.0625f);
                    event.getRenderer().func_177087_b().field_178724_i.field_78807_k = false;
                    TRANSFORMATION_HELPER.set(MathHelper.func_76134_b((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, 20.0f, MathHelper.func_76126_a((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, (float)Math.toRadians(90.0), (float)(-Math.toRadians((double)entityPlayer.field_70761_aq + 45.0)), 0.0f).transformAndRender(entityPlayer, event.getRenderer().func_177087_b().field_178724_i, 0.0625f);
                }
            } else if (entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(event.getRenderer().func_110775_a((AbstractClientPlayer)entityPlayer));
                event.getRenderer().func_177087_b().field_178724_i.field_78807_k = false;
                TRANSFORMATION_HELPER.set(MathHelper.func_76134_b((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, 20.0f, MathHelper.func_76126_a((float)((float)Math.toRadians(entityPlayer.field_70761_aq))) * 4.5f, (float)Math.toRadians(90.0), (float)(-Math.toRadians(entityPlayer.field_70761_aq)), 0.0f).transformAndRender(entityPlayer, event.getRenderer().func_177087_b().field_178724_i, 0.0625f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && Minecraft.func_71410_x().field_71439_g != null) {
                Optic optic;
                ItemStack itemStack;
                ItemGun gun;
                boolean aiming = false;
                EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
                if (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !entityPlayer.func_70051_ag() && entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun && entityPlayer.func_184592_cb().func_190926_b() && (gun = (ItemGun)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getCanAim(itemStack) && (optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC.getSlot()))) != null && optic.canAim()) {
                    aiming = true;
                }
                GunCus.channel.sendToServer((IMessage)new MessageShoot(aiming, !entityPlayer.field_70122_E || entityPlayer.field_70159_w != 0.0 || entityPlayer.field_70181_x != 0.0));
            }
            ++this.tabCounter;
            if (this.tabCounter >= 20) {
                GunCus.TAB_GUNCUS.shuffleItemStack();
                this.tabCounter = 0;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void renderGameOverlay(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP entityPlayer = Minecraft.func_71410_x().field_71439_g;
            Optic optic = null;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                ItemStack itemStack;
                ItemGun gun;
                if (entityPlayer.func_184592_cb().func_190926_b() && (gun = (ItemGun)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getCanAim(itemStack)) {
                    optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC.getSlot()));
                }
                event.setCanceled(true);
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                ItemStack itemStack = entityPlayer.func_184614_ca();
                optic = (Optic)itemStack.func_77973_b();
            }
            if (!entityPlayer.func_70051_ag() && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && optic != null && optic.canAim()) {
                GUI_SIGHT.draw(optic, event.getResolution());
                if (!event.isCanceled()) {
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void fovUpdate(FOVUpdateEvent event) {
        EntityPlayerSP entityPlayer;
        if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !(entityPlayer = Minecraft.func_71410_x().field_71439_g).func_70051_ag() && Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d()) {
            Optic optic = null;
            float modifier = 1.0f;
            float extra = 0.0f;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                if (entityPlayer.func_184592_cb().func_190926_b()) {
                    ItemStack itemStack = entityPlayer.func_184614_ca();
                    ItemGun gun = (ItemGun)itemStack.func_77973_b();
                    if (gun.getCanAim(itemStack)) {
                        optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC.getSlot()));
                    }
                    if (optic != null && gun.isAccessoryTurnedOn(itemStack) && gun.getAttachment(itemStack, EnumAttachmentType.ACCESSORY.getSlot()) != null) {
                        Accessory accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY.getSlot()));
                        if (optic.isCompatibleWithMagnifiers()) {
                            modifier = accessory.getZoomModifier();
                        }
                        if (optic.isCompatibleWithExtraZoom()) {
                            extra = accessory.getExtraZoom();
                        }
                    }
                }
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                ItemStack itemStack = entityPlayer.func_184614_ca();
                optic = (Optic)itemStack.func_77973_b();
            }
            if (optic != null && optic.canAim()) {
                event.setNewfov(EventHandlerClient.calculateFov(optic.getZoom() * modifier + 0.1f, event.getFov()));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            EntityPlayerSP clientPlayer = Minecraft.func_71410_x().field_71439_g;
            Accessory accessory = null;
            Vec3d subtract = new Vec3d(clientPlayer.field_70165_t, clientPlayer.field_70163_u, clientPlayer.field_70161_v);
            boolean renderPoint = false;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder b = tessellator.func_178180_c();
            for (EntityPlayer entityPlayer : world.field_73010_i) {
                if (entityPlayer.field_70128_L) continue;
                for (EnumHand hand : EnumHand.values()) {
                    Accessory.Laser laser;
                    accessory = null;
                    ItemStack itemStack = entityPlayer.func_184586_b(hand);
                    if (itemStack.func_77973_b() instanceof ItemGun) {
                        ItemGun gun = (ItemGun)itemStack.func_77973_b();
                        if (gun.isAccessoryTurnedOn(itemStack)) {
                            accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY.getSlot()));
                            laser = accessory.getLaser();
                        }
                    } else if (itemStack.func_77973_b() instanceof Accessory) {
                        accessory = (Accessory)itemStack.func_77973_b();
                    }
                    if (accessory == null || accessory.getLaser() == null) continue;
                    laser = accessory.getLaser();
                    Vec3d start = new Vec3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityPlayer.field_70161_v);
                    Vec3d end = entityPlayer.func_70040_Z().func_72432_b().func_186678_a(laser.getMaxRange()).func_178787_e(start).func_178787_e(EventHandlerClient.getOffsetForHandRaw(entityPlayer, hand));
                    RayTraceResult resultBlock = EventHandlerClient.findBlockOnPath((World)world, entityPlayer, start, end);
                    RayTraceResult resultEntity = EventHandlerClient.findEntityOnPath((World)world, entityPlayer, start, end);
                    if (resultBlock != null && resultEntity != null) {
                        double rangeEntitySq;
                        double rangeBlockSq = resultBlock.field_72307_f.func_72438_d(start);
                        end = rangeBlockSq < (rangeEntitySq = resultEntity.field_72307_f.func_72438_d(start)) ? resultBlock.field_72307_f : resultEntity.field_72307_f;
                        renderPoint = laser.isPoint();
                    } else if (resultBlock != null) {
                        end = resultBlock.field_72307_f;
                        renderPoint = laser.isPoint();
                    } else if (resultEntity != null) {
                        end = resultEntity.field_72307_f;
                        renderPoint = laser.isPoint();
                    }
                    start = new Vec3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)(entityPlayer.func_70047_e() * 0.8f), entityPlayer.field_70161_v).func_178787_e(EventHandlerClient.getOffsetForHand(entityPlayer, hand));
                    start = start.func_178788_d(subtract);
                    end = end.func_178788_d(subtract);
                    GlStateManager.func_179090_x();
                    if (renderPoint) {
                        b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    if (laser.isBeam()) {
                        b.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                        b.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        b.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
                        tessellator.func_78381_a();
                    }
                    GlStateManager.func_179098_w();
                }
            }
        }
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vec3d getOffsetForHandRaw(EntityPlayer entityPlayer, EnumHand hand) {
        Vec3d vec = EventHandlerClient.getVectorForRotation(entityPlayer.field_70125_A, entityPlayer.field_70177_z + 90.0f);
        if (hand == EnumHand.OFF_HAND) {
            vec = vec.func_186678_a(-1.0);
        }
        return new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c).func_72432_b().func_186678_a(0.4);
    }

    public static Vec3d getOffsetForHand(EntityPlayer entityPlayer, EnumHand hand) {
        Vec3d vec = EventHandlerClient.getOffsetForHandRaw(entityPlayer, hand);
        return vec.func_178787_e(EventHandlerClient.getVectorForRotation(entityPlayer.field_70125_A, entityPlayer.field_70177_z).func_186678_a(0.4));
    }

    @Nullable
    public static RayTraceResult findBlockOnPath(World world, EntityPlayer entityPlayer, Vec3d start, Vec3d end) {
        return world.func_147447_a(start, end, false, false, true);
    }

    @Nullable
    public static RayTraceResult findEntityOnPath(World world, EntityPlayer entityPlayer, Vec3d start, Vec3d end) {
        RayTraceResult result = null;
        double rangeSq = 0.0;
        for (Entity entity : world.field_72996_f) {
            double currentRangeSq;
            AxisAlignedBB axisalignedbb;
            RayTraceResult result1;
            if (entity.func_145782_y() == entityPlayer.func_145782_y() || entity instanceof EntityBullet || (result1 = (axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((currentRangeSq = start.func_72436_e(result1.field_72307_f)) < rangeSq) && result != null) continue;
            result = result1;
            rangeSq = currentRangeSq;
        }
        return result;
    }

    public static float calculateFov(float zoom, float fov) {
        return (float)Math.atan(Math.tan(fov) / (double)zoom);
    }

    public static class ModelRendererTransformationHelper {
        private float rotationPointX;
        private float rotationPointY;
        private float rotationPointZ;
        private float rotateAngleX;
        private float rotateAngleY;
        private float rotateAngleZ;

        public ModelRendererTransformationHelper set(float rotationPointX, float rotationPointY, float rotationPointZ, float rotateAngleX, float rotateAngleY, float rotateAngleZ) {
            this.rotationPointX = rotationPointX;
            this.rotationPointY = rotationPointY;
            this.rotationPointZ = rotationPointZ;
            this.rotateAngleX = rotateAngleX;
            this.rotateAngleY = rotateAngleY;
            this.rotateAngleZ = rotateAngleZ;
            return this;
        }

        public ModelRendererTransformationHelper transform(EntityPlayer entityPlayer, ModelRenderer model) {
            float temp = model.field_78800_c;
            model.field_78800_c = this.getRotationPointX();
            this.rotationPointX = temp;
            temp = model.field_78797_d;
            model.field_78797_d = this.getRotationPointY();
            this.rotationPointY = temp;
            temp = model.field_78798_e;
            model.field_78798_e = this.getRotationPointZ();
            this.rotationPointZ = temp;
            temp = model.field_78795_f;
            model.field_78795_f = this.getRotateAngleX();
            this.rotateAngleX = temp;
            temp = model.field_78796_g;
            model.field_78796_g = this.getRotateAngleY();
            this.rotateAngleY = temp;
            temp = model.field_78808_h;
            model.field_78808_h = this.getRotateAngleZ();
            this.rotateAngleZ = temp;
            return this;
        }

        public ModelRendererTransformationHelper render(EntityPlayer entityPlayer, ModelRenderer model, float f) {
            model.func_78791_b(f);
            return this;
        }

        public ModelRendererTransformationHelper transformAndRender(EntityPlayer entityPlayer, ModelRenderer model, float f) {
            this.transform(entityPlayer, model);
            this.render(entityPlayer, model, f);
            this.transform(entityPlayer, model);
            return this;
        }

        public float getRotationPointX() {
            return this.rotationPointX;
        }

        public float getRotationPointY() {
            return this.rotationPointY;
        }

        public float getRotationPointZ() {
            return this.rotationPointZ;
        }

        public float getRotateAngleX() {
            return this.rotateAngleX;
        }

        public float getRotateAngleY() {
            return this.rotateAngleY;
        }

        public float getRotateAngleZ() {
            return this.rotateAngleZ;
        }
    }
}

