/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.gci.client;

import de.cas_ual_ty.gci.Proxy;
import de.cas_ual_ty.gci.block.BlockGCI;
import de.cas_ual_ty.gci.client.BakeHandler;
import de.cas_ual_ty.gci.client.EventHandlerClient;
import de.cas_ual_ty.gci.item.ItemBlockGCI;
import de.cas_ual_ty.gci.item.ItemGCI;
import de.cas_ual_ty.gci.item.ItemGun;
import de.cas_ual_ty.gci.item.attachment.Attachment;
import de.cas_ual_ty.gci.item.attachment.EnumAttachmentType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.registries.IForgeRegistry;

public class ProxyClient
extends Proxy {
    public void registerItemRenderer(ItemGCI item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("gci:" + item.getModelRL(), "inventory"));
    }

    public void registerItemRenderer(ItemBlockGCI item) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("gci:" + item.getModelRL(), "inventory"));
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry, ItemGCI item) {
        super.registerItem(registry, item);
        this.registerItemRenderer(item);
    }

    @Override
    public void registerItem(IForgeRegistry<Item> registry, ItemBlockGCI item) {
        super.registerItem(registry, item);
        this.registerItemRenderer(item);
    }

    @Override
    public void registerGun(IForgeRegistry<Item> registry, ItemGun gun) {
        super.registerGun(registry, gun);
        ModelResourceLocation main = new ModelResourceLocation("gci:" + gun.getModelRL() + "/gun", "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)gun, (int)0, (ModelResourceLocation)main);
        ArrayList<ModelResourceLocation> list = new ArrayList<ModelResourceLocation>();
        list.add(main);
        for (int i = 0; i < EnumAttachmentType.values().length; ++i) {
            for (int j = 0; j < Attachment.getAmmountForSlot(i); ++j) {
                Attachment attachment;
                if (!gun.canSetAttachment(i, j) || (attachment = Attachment.getAttachment(i, j)) == null || !attachment.shouldLoadModel()) continue;
                list.add(new ModelResourceLocation("gci:" + gun.getModelRL() + "/" + attachment.getModelRL(), "inventory"));
            }
        }
        list.add(new ModelResourceLocation("gci:" + gun.getModelRL() + "/aim", "inventory"));
        ModelBakery.registerItemVariants((Item)gun, (ResourceLocation[])((ResourceLocation[])list.toArray(new ModelResourceLocation[list.size()])));
    }

    @Override
    public void registerBlock(IForgeRegistry<Block> registry, BlockGCI block) {
        super.registerBlock(registry, block);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new BakeHandler());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerClient());
    }

    @Override
    public EntityPlayer getClientPlayer(MessageContext ctx) {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void generateAttachmentModels() {
        for (ItemGun gun : ItemGun.GUNS_LIST) {
            try {
                ProxyClient.generateAttachmentModelsForGun(gun);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void generateAttachmentModelsForGun(String path, ItemGun gun) throws IOException {
        String gunName = gun.getModelRL();
        File baseAttachmentFile = new File(path + "/models/item/base/attachment_name.json");
        File baseGunFile = new File(path + "/models/item/base/gun_name.json");
        if (baseAttachmentFile.exists()) {
            BufferedWriter writer;
            String line;
            ArrayList<String> lines = new ArrayList<String>();
            BufferedReader reader = new BufferedReader(new FileReader(baseAttachmentFile));
            while ((line = reader.readLine()) != null) {
                lines.add(line.replaceAll("gun_name", gunName));
            }
            reader.close();
            String itemDirPath = path + "/models/item/" + gun.getModelRL();
            File itemDir = new File(itemDirPath);
            if (!itemDir.exists()) {
                itemDir.mkdirs();
            }
            for (int i = 0; i < EnumAttachmentType.values().length; ++i) {
                for (int j = 0; j < Attachment.getAmmountForSlot(i); ++j) {
                    String attachmentModelPath;
                    File attachmentModel;
                    Attachment attachment;
                    if (!gun.canSetAttachment(i, j) || (attachment = Attachment.getAttachment(i, j)) == null || !attachment.shouldLoadModel() || (attachmentModel = new File(attachmentModelPath = itemDirPath + "/" + attachment.getModelRL() + ".json")).exists()) continue;
                    attachmentModel.createNewFile();
                    writer = new BufferedWriter(new FileWriter(attachmentModel));
                    for (String line1 : lines) {
                        writer.write(line1.replaceAll("attachment_name", attachment.getModelRL()));
                        writer.newLine();
                    }
                    writer.close();
                }
            }
            File gunModel = new File(itemDirPath + "/gun.json");
            if (!gunModel.exists()) {
                gunModel.createNewFile();
                lines.clear();
                reader = new BufferedReader(new FileReader(baseGunFile));
                while ((line = reader.readLine()) != null) {
                    lines.add(line.replaceAll("gun_name", gunName));
                }
                reader.close();
                writer = new BufferedWriter(new FileWriter(gunModel));
                for (String line1 : lines) {
                    writer.write(line1);
                    writer.newLine();
                }
                writer.close();
            }
        } else {
            baseAttachmentFile.mkdirs();
            baseAttachmentFile.createNewFile();
        }
    }

    public static void generateAttachmentModelsForGun(ItemGun gun) throws IOException {
        ProxyClient.generateAttachmentModelsForGun("C:\\Minecraft Coding 1.12.2\\src\\main\\resources\\assets\\gci", gun);
    }
}

