/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.gci.item;

import de.cas_ual_ty.gci.CreativeTabsGCIGun;
import de.cas_ual_ty.gci.EntityBullet;
import de.cas_ual_ty.gci.GunCus;
import de.cas_ual_ty.gci.SoundEventGCI;
import de.cas_ual_ty.gci.item.ItemCartridge;
import de.cas_ual_ty.gci.item.ItemGCI;
import de.cas_ual_ty.gci.item.attachment.Accessory;
import de.cas_ual_ty.gci.item.attachment.Ammo;
import de.cas_ual_ty.gci.item.attachment.Attachment;
import de.cas_ual_ty.gci.item.attachment.Auxiliary;
import de.cas_ual_ty.gci.item.attachment.Barrel;
import de.cas_ual_ty.gci.item.attachment.EnumAttachmentType;
import de.cas_ual_ty.gci.item.attachment.Underbarrel;
import de.cas_ual_ty.gci.network.MessageRecoil;
import de.cas_ual_ty.gci.network.MessageSound;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ItemGun
extends ItemGCI {
    public static final ArrayList<ItemGun> GUNS_LIST = new ArrayList();
    public static final String NBT_SHOOT_TIME = "ShootTime";
    public static final String NBT_AMMO = "Ammo";
    public static final String NBT_RELOADING = "Reloading";
    public static final String NBT_INACCURACY = "Inaccuracy";
    public static final String NBT_ATTACHMENT_PREFIX = "Attachment";
    public static final String NBT_ACCESSORY_SWITCH = "AccessorySwitch";
    protected int fireRate;
    protected int maxAmmo;
    protected float damage;
    protected ItemCartridge cartridge;
    protected CreativeTabs gunTab;
    protected boolean[][] attachments;
    protected SoundEventGCI soundShoot;
    protected SoundEventGCI soundShootSilenced;
    protected SoundEventGCI soundReload;

    public ItemGun(String rl, int fireRate, int maxAmmo, float damage, ItemCartridge cartridge) {
        super(rl);
        this.func_77625_d(1);
        this.fireRate = fireRate;
        this.maxAmmo = maxAmmo;
        this.damage = damage;
        this.cartridge = cartridge;
        this.gunTab = new CreativeTabsGCIGun(rl, this);
        this.attachments = new boolean[EnumAttachmentType.values().length][];
        for (int i = 0; i < this.attachments.length; ++i) {
            this.attachments[i] = new boolean[Attachment.getAmmountForSlot(i)];
        }
        this.soundShoot = GunCus.SOUND_SHOOT;
        this.soundShootSilenced = GunCus.SOUND_SHOOT_SILENCED;
        this.soundReload = GunCus.SOUND_RELOAD;
        GUNS_LIST.add(this);
    }

    public ItemGun addAttachment(Attachment attachment) {
        return this.addAttachment(attachment.getSlot(), attachment.getID());
    }

    public ItemGun addAttachment(int slot, int id) {
        this.attachments[slot][id] = true;
        if (!this.isSlotAvailable(slot)) {
            this.setSlotAvailable(slot);
        }
        return this;
    }

    public boolean isSlotAvailable(int slot) {
        return this.attachments[slot][0];
    }

    public void setSlotAvailable(int slot) {
        this.attachments[slot][0] = true;
    }

    public Item getCurrentlyUsedCardridge(ItemStack itemStack) {
        return ((Ammo)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.AMMO.getSlot()))).getUsedCartrige(itemStack, this);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityPlayer, EnumHand hand) {
        return new ActionResult(EnumActionResult.PASS, (Object)entityPlayer.func_184586_b(hand));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int idk, boolean flag) {
        int time = this.getShootTime(itemStack);
        if (time > 0) {
            this.setShootTime(itemStack, --time);
        }
        if (time == 0) {
            if (this.getIsReloading(itemStack)) {
                this.setIsReloading(itemStack, false);
            } else {
                time = this.getInaccuracy(itemStack);
                if (time > 0) {
                    this.setInaccuracy(itemStack, --time);
                }
            }
        }
    }

    public EnumActionResult tryShootOrReload(EntityPlayer entityPlayer, ItemStack itemStack, boolean aiming, boolean moving) {
        if (this.getShootTime(itemStack) <= 0) {
            if (this.getAmmo(itemStack) > 0 || entityPlayer.field_71075_bZ.field_75098_d) {
                return this.doShoot(entityPlayer, itemStack, aiming, moving);
            }
            return this.tryReload(entityPlayer, itemStack);
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult doShoot(EntityPlayer entityPlayer, ItemStack itemStack, boolean aiming, boolean moving) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            EntityBullet bullet = new EntityBullet(entityPlayer.field_70170_p, (EntityLivingBase)entityPlayer);
            bullet.setDamage(this.getDamage());
            int inaccuracyInt = this.getInaccuracy(itemStack);
            float inaccuracy = inaccuracyInt;
            float pitch = entityPlayer.field_70125_A;
            float yaw = entityPlayer.field_70177_z;
            float pitchRecoil = -GunCus.RANDOM.nextFloat() * 5.0f;
            float yawRecoil = (GunCus.RANDOM.nextFloat() - 0.5f) * 5.0f;
            if (inaccuracy > 10.0f) {
                inaccuracy = 10.0f;
            }
            inaccuracy = aiming ? (inaccuracy *= 0.75f) : (inaccuracy *= 1.5f * ((Accessory)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY.getSlot()))).getHipFireInccuracyModifier());
            if (moving) {
                inaccuracy *= 1.5f * ((Underbarrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.UNDERBARREL.getSlot()))).getInaccuracyModifierMoving();
            } else {
                inaccuracy *= 0.8f * ((Underbarrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.UNDERBARREL.getSlot()))).getInaccuracyModifierStill();
                if (entityPlayer.func_70093_af()) {
                    inaccuracy *= 0.8f * ((Auxiliary)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.AUXILIARY.getSlot()))).getInaccuracyModifierWhenShiftAndStill();
                    pitchRecoil *= ((Auxiliary)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.AUXILIARY.getSlot()))).getDriftModifierWhenShiftAndStill();
                    yawRecoil *= ((Auxiliary)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.AUXILIARY.getSlot()))).getDriftModifierWhenShiftAndStill();
                }
            }
            pitchRecoil *= ((Underbarrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.UNDERBARREL.getSlot()))).getDriftModifier();
            yawRecoil *= ((Underbarrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.UNDERBARREL.getSlot()))).getDriftModifier();
            bullet.func_184547_a((Entity)entityPlayer, pitch += (inaccuracy *= ((Barrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.BARREL.getSlot()))).getInaccuracyModifier()) * ((Barrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.BARREL.getSlot()))).getVerticalSpreadModifier() / 10.0f * (2.0f * GunCus.RANDOM.nextFloat() - 1.0f) * 15.0f, yaw += inaccuracy * ((Barrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.BARREL.getSlot()))).getHorizontalSpreadModifier() / 10.0f * (2.0f * GunCus.RANDOM.nextFloat() - 1.0f) * 15.0f, 0.0f, this.getBulletVelocity(itemStack, entityPlayer), 1.0f);
            entityPlayer.field_70170_p.func_72838_d((Entity)bullet);
            this.setShootTime(itemStack, this.fireRate);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                this.setAmmo(itemStack, this.getAmmo(itemStack) - 1);
            }
            this.setInaccuracy(itemStack, inaccuracyInt + 2);
            GunCus.channel.sendTo((IMessage)new MessageRecoil(pitchRecoil, yawRecoil), (EntityPlayerMP)entityPlayer);
        }
        if (this.getAttachmentCalled(itemStack, EnumAttachmentType.BARREL.getSlot()) != null && ((Barrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.BARREL.getSlot()))).getIsSilenced()) {
            GunCus.channel.sendToAllAround((IMessage)new MessageSound((Entity)entityPlayer, this.soundShootSilenced, 1.0f, 1.0f), new NetworkRegistry.TargetPoint(entityPlayer.field_70170_p.field_73011_w.getDimension(), entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, 10.0));
        } else {
            GunCus.channel.sendToAllAround((IMessage)new MessageSound((Entity)entityPlayer, this.soundShoot, 10.0f, 1.0f), new NetworkRegistry.TargetPoint(entityPlayer.field_70170_p.field_73011_w.getDimension(), entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, 100.0));
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult tryReload(EntityPlayer entityPlayer, ItemStack itemStack) {
        int ammount = 0;
        NonNullList list = NonNullList.func_191197_a((int)(entityPlayer.field_71071_by.field_70462_a.size() + entityPlayer.field_71071_by.field_184439_c.size()), (Object)ItemStack.field_190927_a);
        int index = 0;
        for (ItemStack i : entityPlayer.field_71071_by.field_70462_a) {
            list.set(index, (Object)i);
            ++index;
        }
        for (ItemStack i : entityPlayer.field_71071_by.field_184439_c) {
            list.set(index, (Object)i);
            ++index;
        }
        for (ItemStack i : list) {
            if (i.func_77973_b() == this.getCurrentlyUsedCardridge(itemStack)) {
                int needed = this.maxAmmo - ammount;
                if (i.func_190916_E() > needed) {
                    i.func_190920_e(i.func_190916_E() - needed);
                    ammount += needed;
                } else {
                    ammount += i.func_190916_E();
                    i.func_190920_e(0);
                }
            }
            if (ammount < this.maxAmmo) continue;
            break;
        }
        if (ammount > 0) {
            return this.doReload(entityPlayer, itemStack, ammount);
        }
        return EnumActionResult.PASS;
    }

    public EnumActionResult doReload(EntityPlayer entityPlayer, ItemStack itemStack, int ammount) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.setAmmo(itemStack, ammount);
            this.setShootTime(itemStack, 100);
            this.setIsReloading(itemStack, true);
        }
        GunCus.channel.sendTo((IMessage)new MessageSound((Entity)entityPlayer, this.soundReload, 1.0f, 1.0f), (EntityPlayerMP)entityPlayer);
        return EnumActionResult.SUCCESS;
    }

    public float getBulletVelocity(ItemStack itemStack, EntityPlayer entityPlayer) {
        return 30.0f * this.getCartridge().getBulletSpeedModifier() * ((Barrel)((Object)this.getAttachmentCalled(itemStack, EnumAttachmentType.BARREL.getSlot()))).getBulletSpeedModifier();
    }

    public NBTTagCompound getNBT(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        return itemStack.func_77978_p();
    }

    public boolean isAccessoryTurnedOn(ItemStack itemStack) {
        return true;
    }

    public void setAccessoryTurnedOn(ItemStack itemStack, boolean b) {
        this.getNBT(itemStack).func_74757_a(NBT_ACCESSORY_SWITCH, b);
    }

    public int getShootTime(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e(NBT_SHOOT_TIME);
    }

    public void setShootTime(ItemStack itemStack, int i) {
        this.getNBT(itemStack).func_74768_a(NBT_SHOOT_TIME, i);
    }

    public boolean getCanAim(ItemStack itemStack) {
        return !this.getIsReloading(itemStack);
    }

    public boolean getIsReloading(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74767_n(NBT_RELOADING);
    }

    public void setIsReloading(ItemStack itemStack, boolean isReloading) {
        this.getNBT(itemStack).func_74757_a(NBT_RELOADING, isReloading);
    }

    public int getAmmo(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e(NBT_AMMO);
    }

    public void setAmmo(ItemStack itemStack, int i) {
        this.getNBT(itemStack).func_74768_a(NBT_AMMO, i);
    }

    public int getInaccuracy(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e(NBT_INACCURACY);
    }

    public void setInaccuracy(ItemStack itemStack, int i) {
        this.getNBT(itemStack).func_74768_a(NBT_INACCURACY, i);
    }

    @Nullable
    public Attachment getAttachment(ItemStack itemStack, int slot) {
        return Attachment.getAttachment(slot, this.getAttachmentID(itemStack, slot));
    }

    public int getAttachmentID(ItemStack itemStack, int slot) {
        return this.getNBT(itemStack).func_74762_e(ItemGun.getAttachmentNBTKey(slot));
    }

    public void setAttachment(ItemStack itemStack, Attachment attachment) {
        this.setAttachment(itemStack, attachment.getSlot(), attachment.getID());
    }

    public void setAttachment(ItemStack itemStack, int slot, int id) {
        this.getNBT(itemStack).func_74768_a(ItemGun.getAttachmentNBTKey(slot), id);
    }

    public void removeAttachment(ItemStack itemStack, int slot) {
        this.setAttachment(itemStack, slot, 0);
    }

    public boolean canSetAttachment(Attachment attachment) {
        return this.canSetAttachment(attachment.getSlot(), attachment.getID());
    }

    public boolean canSetAttachment(int slot, int id) {
        return this.attachments[slot][id];
    }

    public <A extends Attachment> A getAttachmentCalled(ItemStack itemStack, int slot) {
        return (A)((Object)this.getAttachment(itemStack, slot));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        super.func_150895_a(tab, list);
        if (tab == this.gunTab) {
            int j;
            list.add((Object)new ItemStack((Item)this));
            list.add((Object)new ItemStack((Item)this.getCartridge()));
            for (int i = 0; i < EnumAttachmentType.values().length; ++i) {
                boolean[] current = this.attachments[i];
                for (j = 1; j < current.length; ++j) {
                    if (!current[j]) continue;
                    list.add((Object)new ItemStack((Item)Attachment.getAttachment(i, j)));
                }
            }
            if (GunCus.fullCreativeTabs) {
                int[] array = new int[Attachment.ATTACHMENTS_LIST.length];
                j = 0;
                boolean include = true;
                boolean finalBreak = false;
                ArrayList<Integer> availableSlots = new ArrayList<Integer>();
                for (j = 0; j < array.length; ++j) {
                    if (!this.isSlotAvailable(j)) continue;
                    availableSlots.add(j);
                }
                block3: while (!finalBreak) {
                    for (j = 0; j < availableSlots.size(); ++j) {
                        int slot;
                        int n = slot = ((Integer)availableSlots.get(j)).intValue();
                        array[n] = array[n] + 1;
                        if (array[slot] < Attachment.getAmmountForSlot(slot)) {
                            include = true;
                            for (slot = 0; slot < array.length; ++slot) {
                                if (array[slot] == 0 || this.canSetAttachment(slot, array[slot])) continue;
                                include = false;
                                break;
                            }
                            if (!include) continue block3;
                            ItemStack itemStack = new ItemStack((Item)this);
                            for (slot = 0; slot < array.length; ++slot) {
                                this.setAttachment(itemStack, slot, array[slot]);
                            }
                            list.add((Object)itemStack);
                            continue block3;
                        }
                        array[slot] = 0;
                        if (slot != (Integer)availableSlots.get(availableSlots.size() - 1)) continue;
                        finalBreak = true;
                    }
                }
            }
        }
    }

    public void func_77624_a(ItemStack itemStack, World world, List<String> list, ITooltipFlag flag) {
        int i;
        super.func_77624_a(itemStack, world, list, flag);
        list.add("\u00a7e" + this.getAmmo(itemStack) + "\u00a7f/" + this.maxAmmo + " \u00a7e" + ItemGun.getCardridgeTranslated(this.getCurrentlyUsedCardridge(itemStack)));
        int ammount = 0;
        for (i = 0; i < this.attachments.length; ++i) {
            if (!this.attachments[i][0]) continue;
            ++ammount;
        }
        if (ammount > 0) {
            list.add("\u00a78" + Attachment.getAttachmentTranslated(ammount > 1) + ":");
            for (i = 0; i < EnumAttachmentType.values().length; ++i) {
                if (!this.isSlotAvailable(i)) continue;
                Attachment attachment = this.getAttachment(itemStack, i);
                if (attachment != null) {
                    list.add("\u00a7e" + attachment.getInformationString(this, itemStack) + " \u00a78(" + Attachment.getSlotTranslated(i) + ")");
                    continue;
                }
                list.add("-- \u00a78(" + Attachment.getSlotTranslated(i) + ")");
            }
        }
    }

    public static String getAttachmentNBTKey(int slot) {
        return NBT_ATTACHMENT_PREFIX + slot;
    }

    public static String getCardridgeTranslated(Item cardridge) {
        return I18n.func_74838_a((String)(cardridge.func_77658_a() + ".name")).trim();
    }

    public int getFireRate() {
        return this.fireRate;
    }

    public int getMaxAmmo() {
        return this.maxAmmo;
    }

    public float getDamage() {
        return this.damage + this.getCartridge().getDamage();
    }

    public ItemCartridge getCartridge() {
        return this.cartridge;
    }

    public int getVariants() {
        int j;
        int ammount = 0;
        int[] array = new int[Attachment.ATTACHMENTS_LIST.length];
        boolean include = true;
        boolean finalBreak = false;
        ArrayList<Integer> availableSlots = new ArrayList<Integer>();
        for (j = 0; j < array.length; ++j) {
            if (!this.isSlotAvailable(j)) continue;
            availableSlots.add(j);
        }
        block1: while (!finalBreak) {
            for (j = 0; j < availableSlots.size(); ++j) {
                int slot;
                int n = slot = ((Integer)availableSlots.get(j)).intValue();
                array[n] = array[n] + 1;
                if (array[slot] < Attachment.getAmmountForSlot(slot)) {
                    include = true;
                    for (slot = 0; slot < array.length; ++slot) {
                        if (array[slot] == 0 || this.canSetAttachment(slot, array[slot])) continue;
                        include = false;
                        break;
                    }
                    if (!include) continue block1;
                    ++ammount;
                    continue block1;
                }
                array[slot] = 0;
                if (slot != (Integer)availableSlots.get(availableSlots.size() - 1)) continue;
                finalBreak = true;
            }
        }
        return ammount;
    }

    public boolean onEntitySwing(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        return true;
    }
}

