/*
 * Decompiled with CFR 0.152.
 */
package lykrast.glassential;

import java.util.ArrayList;
import java.util.List;
import lykrast.glassential.BlockCustomGlass;
import lykrast.glassential.GlassentialConfig;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class ModBlocks {
    public static Block clear;
    public static Block light;
    public static Block redstone;
    public static Block dark;
    private static List<Item> itemBlocks;

    private static Block registerBlock(IForgeRegistry<Block> reg, Block block, String name, CreativeTabs tab) {
        block.setRegistryName(name);
        block.func_149663_c("glassential." + name);
        if (tab != null) {
            block.func_149647_a(tab);
        }
        reg.register((IForgeRegistryEntry)block);
        ItemBlock item = new ItemBlock(block);
        item.setRegistryName(block.getRegistryName());
        itemBlocks.add((Item)item);
        return block;
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        itemBlocks = new ArrayList<Item>();
        if (GlassentialConfig.clear) {
            clear = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockCustomGlass(), "glass_clear", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.light) {
            light = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockCustomGlass().func_149715_a(1.0f), "glass_light", CreativeTabs.field_78030_b);
        }
        if (GlassentialConfig.redstone) {
            redstone = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, (Block)new BlockCustomGlass(){

                public boolean func_149744_f(IBlockState state) {
                    return true;
                }

                public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
                    return 15;
                }
            }, "glass_redstone", CreativeTabs.field_78028_d);
        }
        if (GlassentialConfig.dark) {
            dark = ModBlocks.registerBlock((IForgeRegistry<Block>)registry, new BlockCustomGlass().func_149713_g(255), "glass_dark", CreativeTabs.field_78030_b);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry reg = event.getRegistry();
        for (Item i : itemBlocks) {
            reg.register((IForgeRegistryEntry)i);
        }
        ModBlocks.registerOreDict();
    }

    private static void registerOreDict() {
        if (GlassentialConfig.clear) {
            OreDictionary.registerOre((String)"blockGlass", (Block)clear);
        }
        if (GlassentialConfig.light) {
            OreDictionary.registerOre((String)"blockGlass", (Block)light);
        }
        if (GlassentialConfig.redstone) {
            OreDictionary.registerOre((String)"blockGlass", (Block)redstone);
        }
        if (GlassentialConfig.dark) {
            OreDictionary.registerOre((String)"blockGlass", (Block)dark);
        }
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (GlassentialConfig.clear) {
            GameRegistry.addSmelting((Block)Blocks.field_150359_w, (ItemStack)new ItemStack(clear), (float)0.1f);
        }
    }

    private static void initModel(Block b) {
        ModBlocks.initModel(Item.func_150898_a((Block)b));
    }

    private static void initModel(Item i) {
        ModelLoader.setCustomModelResourceLocation((Item)i, (int)0, (ModelResourceLocation)new ModelResourceLocation(i.getRegistryName(), "inventory"));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void registerModels(ModelRegistryEvent evt) {
        if (GlassentialConfig.clear) {
            ModBlocks.initModel(clear);
        }
        if (GlassentialConfig.light) {
            ModBlocks.initModel(light);
        }
        if (GlassentialConfig.redstone) {
            ModBlocks.initModel(redstone);
        }
        if (GlassentialConfig.dark) {
            ModBlocks.initModel(dark);
        }
        for (Item i : itemBlocks) {
            ModBlocks.initModel(i);
        }
        itemBlocks = null;
    }
}

