/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.ClientProxy;
import alpvax.mc.goprone.PacketHandler;
import alpvax.mc.goprone.config.ConfigOptions;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.Pose;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="goprone")
public class GoProne {
    public static final String MODID = "goprone";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Method setPose = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_213301_b", (Class[])new Class[]{Pose.class});
    static Map<UUID, Boolean> entityProneStates = Maps.newConcurrentMap();

    public GoProne() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientProxy.init());
        PacketHandler.register();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, ConfigOptions.SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ConfigOptions::onModConfigEvent);
    }

    public static void setProne(UUID playerID, boolean prone) {
        entityProneStates.put(playerID, prone);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.field_70170_p.field_72995_K) {
                DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ClientProxy.updateProneState(event.player));
            }
            if (entityProneStates.getOrDefault(event.player.func_110124_au(), false).booleanValue() && ConfigOptions.test(event.player)) {
                try {
                    setPose.invoke((Object)event.player, Pose.SWIMMING);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    LOGGER.error("Error setting player prone: " + event.player.func_208017_dF(), (Throwable)e);
                }
            }
        }
    }
}

