/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone.config;

import alpvax.mc.goprone.config.ConfigExceptionList;
import alpvax.mc.goprone.config.ConfigResult;
import alpvax.mc.goprone.config.ConfigSetting;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigOptions {
    public static final ForgeConfigSpec SPEC;
    private static final ConfigSetting[] ALLOW_SETTINGS;

    public static Void makeConfig(ForgeConfigSpec.Builder builder) {
        for (ConfigSetting s : ALLOW_SETTINGS) {
            s.createConfigValue(builder);
        }
        return null;
    }

    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SPEC) {
            for (ConfigSetting s : ALLOW_SETTINGS) {
                s.bakeConfigValue();
            }
        }
    }

    public static boolean test(PlayerEntity player) {
        for (ConfigSetting s : ALLOW_SETTINGS) {
            if (s.test(player) != ConfigResult.DENY) continue;
            return false;
        }
        return true;
    }

    static {
        ALLOW_SETTINGS = new ConfigSetting[]{new ConfigSetting("flying", true, p -> !p.field_70122_E, "Allow while flying"), new ConfigSetting("riding", false, Entity::func_184218_aH, "Allow while riding another entity").withException(new ConfigExceptionList.Builder<EntityType>(e -> e.getRegistryName().toString(), s -> (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(s))).setComment("A list of exceptions to the rule.", "If allowed is true, this works as a blacklist", "If allowed is false, this works as a whitelist").build((value, player) -> player.func_184218_aH() && player.func_184187_bx().func_200600_R() == value))};
        SPEC = (ForgeConfigSpec)new ForgeConfigSpec.Builder().configure(ConfigOptions::makeConfig).getRight();
    }
}

