/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.guards;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.pathfinding.GroundPathNavigator;

public class TemptGoalGuard
extends Goal {
    private static final EntityPredicate ENTITY_PREDICATE = new EntityPredicate().func_221013_a(10.0).func_221008_a().func_221011_b().func_221009_d().func_221014_c();
    protected final CreatureEntity creature;
    private final double speed;
    private double targetX;
    private double targetY;
    private double targetZ;
    private double pitch;
    private double yaw;
    protected PlayerEntity closestPlayer;
    private int delayTemptCounter;
    private boolean isRunning;
    private final Ingredient temptItem;
    private final boolean scaredByPlayerMovement;

    public TemptGoalGuard(CreatureEntity creatureIn, double speedIn, Ingredient temptItemsIn, boolean p_i47822_5_) {
        this(creatureIn, speedIn, p_i47822_5_, temptItemsIn);
    }

    public TemptGoalGuard(CreatureEntity creatureIn, double speedIn, boolean scaredByPlayerMovement, Ingredient temptItemsIn) {
        this.creature = creatureIn;
        this.speed = speedIn;
        this.temptItem = temptItemsIn;
        this.scaredByPlayerMovement = scaredByPlayerMovement;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        if (!(creatureIn.func_70661_as() instanceof GroundPathNavigator)) {
            throw new IllegalArgumentException("Unsupported mob type for TemptGoal");
        }
    }

    public boolean func_75250_a() {
        if (this.delayTemptCounter > 0) {
            --this.delayTemptCounter;
            return false;
        }
        this.closestPlayer = this.creature.field_70170_p.func_217370_a(ENTITY_PREDICATE, (LivingEntity)this.creature);
        if (this.closestPlayer == null) {
            return false;
        }
        return this.isTempting(this.closestPlayer.func_184614_ca()) || this.isTempting(this.closestPlayer.func_184592_cb());
    }

    protected boolean isTempting(ItemStack stack) {
        return this.temptItem.test(stack);
    }

    public boolean func_75253_b() {
        if (this.isScaredByPlayerMovement()) {
            if (this.creature.func_70068_e((Entity)this.closestPlayer) < 36.0) {
                if (this.closestPlayer.func_70092_e(this.targetX, this.targetY, this.targetZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double)this.closestPlayer.field_70125_A - this.pitch) > 5.0 || Math.abs((double)this.closestPlayer.field_70177_z - this.yaw) > 5.0) {
                    return false;
                }
            } else {
                this.targetX = this.closestPlayer.field_70165_t;
                this.targetY = this.closestPlayer.field_70163_u;
                this.targetZ = this.closestPlayer.field_70161_v;
            }
            this.pitch = this.closestPlayer.field_70125_A;
            this.yaw = this.closestPlayer.field_70177_z;
        }
        return this.func_75250_a();
    }

    protected boolean isScaredByPlayerMovement() {
        return this.scaredByPlayerMovement;
    }

    public void func_75249_e() {
        this.targetX = this.closestPlayer.field_70165_t;
        this.targetY = this.closestPlayer.field_70163_u;
        this.targetZ = this.closestPlayer.field_70161_v;
        this.isRunning = true;
    }

    public void func_75251_c() {
        this.closestPlayer = null;
        this.creature.func_70661_as().func_75499_g();
        this.delayTemptCounter = 0;
        this.isRunning = false;
    }

    public void func_75246_d() {
        this.creature.func_70671_ap().func_75651_a((Entity)this.closestPlayer, (float)(this.creature.func_184649_cE() + 20), (float)this.creature.func_70646_bf());
        if (this.creature.func_70068_e((Entity)this.closestPlayer) < 3.0) {
            this.creature.func_70661_as().func_75499_g();
        } else {
            this.creature.func_70661_as().func_75497_a((Entity)this.closestPlayer, this.speed);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

