/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.guards.distance;

import com.mojang.blaze3d.platform.GlStateManager;
import net.mattbaker.guardscraft.guards.GuardEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.RendererModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.item.BowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;

public class DistanceBowGuardModel<T extends GuardEntity>
extends BipedModel<T> {
    public final RendererModel bipedLeftArmwear;
    public final RendererModel bipedRightArmwear;
    public final RendererModel bipedLeftLegwear;
    public final RendererModel bipedRightLegwear;
    public final RendererModel bipedBodyWear;
    private final RendererModel bipedCape;
    private final RendererModel bipedDeadmau5Head;
    private final boolean smallArms;

    public DistanceBowGuardModel() {
        this(0.0f, false);
    }

    public DistanceBowGuardModel(float modelSize, boolean smallArmsIn) {
        super(modelSize, 0.0f, 64, 64);
        this.smallArms = smallArmsIn;
        this.bipedDeadmau5Head = new RendererModel((Model)this, 24, 0);
        this.bipedDeadmau5Head.func_78790_a(-3.0f, -6.0f, -1.0f, 6, 6, 1, modelSize);
        this.bipedCape = new RendererModel((Model)this, 0, 0);
        this.bipedCape.func_78787_b(64, 32);
        this.bipedCape.func_78790_a(-5.0f, 0.0f, -1.0f, 10, 16, 1, modelSize);
        if (smallArmsIn) {
            this.field_178724_i = new RendererModel((Model)this, 32, 48);
            this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, modelSize);
            this.field_178724_i.func_78793_a(5.0f, 2.5f, 0.0f);
            this.field_178723_h = new RendererModel((Model)this, 40, 16);
            this.field_178723_h.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, modelSize);
            this.field_178723_h.func_78793_a(-5.0f, 2.5f, 0.0f);
            this.bipedLeftArmwear = new RendererModel((Model)this, 48, 48);
            this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 3, 12, 4, modelSize + 0.25f);
            this.bipedLeftArmwear.func_78793_a(5.0f, 2.5f, 0.0f);
            this.bipedRightArmwear = new RendererModel((Model)this, 40, 32);
            this.bipedRightArmwear.func_78790_a(-2.0f, -2.0f, -2.0f, 3, 12, 4, modelSize + 0.25f);
            this.bipedRightArmwear.func_78793_a(-5.0f, 2.5f, 10.0f);
        } else {
            this.field_178724_i = new RendererModel((Model)this, 32, 48);
            this.field_178724_i.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, modelSize);
            this.field_178724_i.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedLeftArmwear = new RendererModel((Model)this, 48, 48);
            this.bipedLeftArmwear.func_78790_a(-1.0f, -2.0f, -2.0f, 4, 12, 4, modelSize + 0.25f);
            this.bipedLeftArmwear.func_78793_a(5.0f, 2.0f, 0.0f);
            this.bipedRightArmwear = new RendererModel((Model)this, 40, 32);
            this.bipedRightArmwear.func_78790_a(-3.0f, -2.0f, -2.0f, 4, 12, 4, modelSize + 0.25f);
            this.bipedRightArmwear.func_78793_a(-5.0f, 2.0f, 10.0f);
        }
        this.field_178722_k = new RendererModel((Model)this, 16, 48);
        this.field_178722_k.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize);
        this.field_178722_k.func_78793_a(1.9f, 12.0f, 0.0f);
        this.bipedLeftLegwear = new RendererModel((Model)this, 0, 48);
        this.bipedLeftLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize + 0.25f);
        this.bipedLeftLegwear.func_78793_a(1.9f, 12.0f, 0.0f);
        this.bipedRightLegwear = new RendererModel((Model)this, 0, 32);
        this.bipedRightLegwear.func_78790_a(-2.0f, 0.0f, -2.0f, 4, 12, 4, modelSize + 0.25f);
        this.bipedRightLegwear.func_78793_a(-1.9f, 12.0f, 0.0f);
        this.bipedBodyWear = new RendererModel((Model)this, 16, 32);
        this.bipedBodyWear.func_78790_a(-4.0f, 0.0f, -2.0f, 8, 12, 4, modelSize + 0.25f);
        this.bipedBodyWear.func_78793_a(0.0f, 0.0f, 0.0f);
    }

    public void render(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        super.func_78088_a(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        GlStateManager.pushMatrix();
        if (this.field_217114_e) {
            float f = 2.0f;
            GlStateManager.scalef((float)0.5f, (float)0.5f, (float)0.5f);
            GlStateManager.translatef((float)0.0f, (float)(24.0f * scale), (float)0.0f);
            this.bipedLeftLegwear.func_78785_a(scale);
            this.bipedRightLegwear.func_78785_a(scale);
            this.bipedLeftArmwear.func_78785_a(scale);
            this.bipedRightArmwear.func_78785_a(scale);
            this.bipedBodyWear.func_78785_a(scale);
        } else {
            if (entityIn.func_213287_bg()) {
                GlStateManager.translatef((float)0.0f, (float)0.2f, (float)0.0f);
            }
            this.bipedLeftLegwear.func_78785_a(scale);
            this.bipedRightLegwear.func_78785_a(scale);
            this.bipedLeftArmwear.func_78785_a(scale);
            this.bipedRightArmwear.func_78785_a(scale);
            this.bipedBodyWear.func_78785_a(scale);
        }
        GlStateManager.popMatrix();
    }

    public void renderDeadmau5Head(float scale) {
        this.bipedDeadmau5Head.func_217177_a(this.field_78116_c);
        this.bipedDeadmau5Head.field_78800_c = 0.0f;
        this.bipedDeadmau5Head.field_78797_d = 0.0f;
        this.bipedDeadmau5Head.func_78785_a(scale);
    }

    public void renderCape(float scale) {
        this.bipedCape.func_78785_a(scale);
    }

    public void setRotationAngles(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float scaleFactor) {
        super.func_212844_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scaleFactor);
        this.bipedLeftLegwear.func_217177_a(this.field_178722_k);
        this.bipedRightLegwear.func_217177_a(this.field_178721_j);
        this.bipedLeftArmwear.func_217177_a(this.field_178724_i);
        this.bipedRightArmwear.func_217177_a(this.field_178723_h);
        this.bipedBodyWear.func_217177_a(this.field_78115_e);
        this.bipedCape.field_78797_d = entityIn.func_213287_bg() ? 2.0f : 0.0f;
    }

    public void func_178719_a(boolean visible) {
        super.func_178719_a(visible);
        this.bipedLeftArmwear.field_78806_j = visible;
        this.bipedRightArmwear.field_78806_j = visible;
        this.bipedLeftLegwear.field_78806_j = visible;
        this.bipedRightLegwear.field_78806_j = visible;
        this.bipedBodyWear.field_78806_j = visible;
        this.bipedCape.field_78806_j = visible;
        this.bipedDeadmau5Head.field_78806_j = visible;
    }

    public void func_187073_a(float scale, HandSide side) {
        RendererModel renderermodel = this.func_187074_a(side);
        if (this.smallArms) {
            float f = 0.5f * (float)(side == HandSide.RIGHT ? 1 : -1);
            renderermodel.field_78800_c += f;
            renderermodel.func_78794_c(scale);
            renderermodel.field_78800_c -= f;
        } else {
            renderermodel.func_78794_c(scale);
        }
    }

    public void setLivingAnimations(T entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        this.field_187076_m = BipedModel.ArmPose.EMPTY;
        this.field_187075_l = BipedModel.ArmPose.EMPTY;
        ItemStack itemstack = entityIn.func_184586_b(Hand.MAIN_HAND);
        if (itemstack.func_77973_b() instanceof BowItem && entityIn.func_213398_dR()) {
            if (entityIn.func_184591_cq() == HandSide.RIGHT) {
                this.field_187076_m = BipedModel.ArmPose.BOW_AND_ARROW;
            } else {
                this.field_187075_l = BipedModel.ArmPose.BOW_AND_ARROW;
            }
        }
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
    }
}

