/*
 * Decompiled with CFR 0.152.
 */
package net.mattbaker.guardscraft.network;

import java.util.function.Supplier;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class PacketSpawn {
    private final String id;
    private final DimensionType type;
    private final BlockPos pos;

    public PacketSpawn(PacketBuffer buf) {
        this.id = buf.func_218666_n();
        this.type = DimensionType.func_186069_a((int)buf.readInt());
        this.pos = buf.func_179259_c();
    }

    public PacketSpawn(String id, DimensionType type, BlockPos pos) {
        this.id = id;
        this.type = type;
        this.pos = pos;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_180714_a(this.id);
        buf.writeInt(this.type.func_186068_a());
        buf.func_179255_a(this.pos);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerWorld spawnWorld = ((NetworkEvent.Context)ctx.get()).getSender().field_70170_p.func_73046_m().func_71218_a(this.type);
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(this.id));
            if (entityType == null) {
                throw new IllegalStateException("This cannot happen! Unknown id '" + this.id + "'!");
            }
            entityType.func_220331_a((World)spawnWorld, null, null, this.pos, SpawnReason.SPAWN_EGG, true, true);
        });
        ctx.get().setPacketHandled(true);
    }
}

