/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.client;

import com.mojang.blaze3d.platform.GlStateManager;
import de.cas_ual_ty.guncus.GunCus;
import de.cas_ual_ty.guncus.IProxy;
import de.cas_ual_ty.guncus.client.BakedModelGun;
import de.cas_ual_ty.guncus.client.BakedModelOptic;
import de.cas_ual_ty.guncus.client.gui.GuiContainerGunTable;
import de.cas_ual_ty.guncus.entity.EntityBullet;
import de.cas_ual_ty.guncus.item.ItemAttachment;
import de.cas_ual_ty.guncus.item.ItemGun;
import de.cas_ual_ty.guncus.item.attachments.Accessory;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.item.attachments.Optic;
import de.cas_ual_ty.guncus.itemgroup.ItemGroupShuffle;
import de.cas_ual_ty.guncus.network.MessageShoot;
import de.cas_ual_ty.guncus.registries.GunCusContainerTypes;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.Blocks;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.network.NetworkEvent;

public class ProxyClient
implements IProxy {
    public static final Supplier<KeyBinding> BUTTON_AIM = () -> ProxyClient.getMC().field_71474_y.field_74313_G;
    public static final Supplier<KeyBinding> BUTTON_SHOOT = () -> ProxyClient.getMC().field_71474_y.field_74312_F;
    public static final Supplier<Boolean> BUTTON_AIM_DOWN = () -> BUTTON_AIM.get().func_151470_d();
    public static final Supplier<Boolean> BUTTON_SHOOT_DOWN = () -> BUTTON_SHOOT.get().func_151470_d();
    public static final ResourceLocation HITMARKER_TEXTURE = new ResourceLocation("guncus", "textures/gui/hitmarker.png");
    public static final int HITMARKER_RESET = 4;
    private static int hitmarkerTick = 0;
    private static int[] shootTime = new int[GunCusUtility.HANDS.length];
    private static int inaccuracyTime = 0;
    private static int prevSelectedMain = -1;
    private static boolean tmpHitNothing = false;

    @Override
    public void registerModEventListeners(IEventBus bus) {
        bus.addListener(this::clientSetup);
        bus.addListener(this::modelBake);
        bus.addListener(this::modelRegistry);
    }

    @Override
    public void registerForgeEventListeners(IEventBus bus) {
        bus.addListener(this::clientTick);
        bus.addListener(this::fovUpdate);
        bus.addListener(this::renderGameOverlayPre);
        bus.addListener(this::renderWorldLast);
    }

    @Override
    public void init() {
        ScreenManager.func_216911_a(GunCusContainerTypes.GUN_TABLE, GuiContainerGunTable::new);
    }

    @Override
    public void addHitmarker(PlayerEntity player) {
        hitmarkerTick = 4;
    }

    @Override
    public PlayerEntity getPlayerFromContext(@Nullable NetworkEvent.Context context) {
        return ProxyClient.getClientPlayer();
    }

    @Override
    public void shot(ItemStack itemStack, ItemGun gun, PlayerEntity player, Hand hand) {
        int fireRate = gun.calcCurrentFireRate(gun.getCurrentAttachments(itemStack));
        ProxyClient.shootTime[hand == Hand.MAIN_HAND ? 0 : 1] = fireRate;
        inaccuracyTime = Math.min(15, inaccuracyTime + 2 + fireRate);
    }

    public void clientSetup(FMLClientSetupEvent event) {
    }

    public void modelBake(ModelBakeEvent event) {
        IBakedModel main;
        ModelResourceLocation mrl;
        for (ItemAttachment attachment : ItemAttachment.ATTACHMENTS_LIST) {
            Optic optic;
            if (attachment.getType() != EnumAttachmentType.OPTIC || (optic = (Optic)attachment) == null || !optic.canAim()) continue;
            mrl = new ModelResourceLocation(optic.getRegistryName().toString(), "inventory");
            main = (IBakedModel)event.getModelRegistry().get(mrl);
            event.getModelRegistry().put(mrl, new BakedModelOptic(main));
        }
        for (ItemGun gun : ItemGun.GUNS_LIST) {
            IBakedModel[][] models = new IBakedModel[EnumAttachmentType.LENGTH][];
            for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
                int i = type.getSlot();
                models[i] = new IBakedModel[gun.getAmmountForSlot(type)];
                for (int j = 0; j < models[i].length; ++j) {
                    ItemAttachment attachment = gun.getAttachment(type, j);
                    if (attachment == null || !attachment.shouldLoadModel()) continue;
                    models[i][j] = (IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(gun.getRegistryName().toString() + "/" + attachment.getRegistryName().func_110623_a(), "inventory"));
                }
            }
            mrl = new ModelResourceLocation(gun.getRegistryName().toString(), "inventory");
            main = (IBakedModel)event.getModelRegistry().get(mrl);
            Matrix4f aimMatrix = (Matrix4f)((IBakedModel)event.getModelRegistry().get(new ModelResourceLocation(gun.getRegistryName().toString() + "/aim", "inventory"))).handlePerspective(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND).getRight();
            event.getModelRegistry().put(mrl, new BakedModelGun(main, models, aimMatrix));
        }
    }

    public void modelRegistry(ModelRegistryEvent event) {
        for (ItemGun gun : ItemGun.GUNS_LIST) {
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/gun", "inventory"));
            for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
                for (int i = 0; i < gun.getAmmountForSlot(type); ++i) {
                    ItemAttachment attachment = gun.getAttachment(type, i);
                    if (attachment == null || !attachment.shouldLoadModel()) continue;
                    ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/" + attachment.getRegistryName().func_110623_a(), "inventory"));
                }
            }
            ModelLoader.addSpecialModel((ResourceLocation)new ModelResourceLocation(gun.getRegistryName().toString() + "/aim", "inventory"));
        }
    }

    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ItemGun gun;
            ItemStack itemStack;
            PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
            if (entityPlayer == null) {
                return;
            }
            int i = 0;
            for (Hand hand : GunCusUtility.HANDS) {
                if (shootTime[i] > 0) {
                    int n = i;
                    shootTime[n] = shootTime[n] - 1;
                }
                if ((itemStack = entityPlayer.func_184586_b(hand)).func_77973_b() instanceof ItemGun) {
                    gun = (ItemGun)itemStack.func_77973_b();
                    if (gun.getNBTIsReloading(itemStack)) {
                        ProxyClient.shootTime[i] = 1;
                    } else if (hand == Hand.MAIN_HAND && entityPlayer.field_71071_by.field_70461_c != prevSelectedMain) {
                        int n = i;
                        shootTime[n] = shootTime[n] + gun.calcCurrentSwitchTime(gun.getCurrentAttachments(itemStack));
                    }
                }
                ++i;
            }
            prevSelectedMain = entityPlayer.field_71071_by.field_70461_c;
            if (inaccuracyTime > 0) {
                --inaccuracyTime;
            }
            if (BUTTON_SHOOT_DOWN.get().booleanValue() && (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun)) {
                boolean aiming = false;
                if (BUTTON_AIM_DOWN.get().booleanValue() && !entityPlayer.func_70051_ag() && entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun && entityPlayer.func_184592_cb().func_190926_b() && (gun = (ItemGun)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getNBTCanAimGun(itemStack)) {
                    Optic optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                    aiming = optic.canAim();
                }
                i = 0;
                int handsInt = 0;
                for (i = 0; i < shootTime.length; ++i) {
                    if (!(entityPlayer.func_184586_b(GunCusUtility.HANDS[i]).func_77973_b() instanceof ItemGun) || shootTime[i] > 0) continue;
                    handsInt += i + 1;
                }
                if (handsInt > 0) {
                    GunCus.channel.sendToServer((Object)new MessageShoot(aiming, inaccuracyTime, handsInt));
                    ItemGun.tryShoot(entityPlayer, aiming, inaccuracyTime, GunCusUtility.intToHands(handsInt));
                }
            }
            for (ItemGroupShuffle group : ItemGroupShuffle.GROUPS_LIST) {
                group.tick();
            }
        } else if (event.phase == TickEvent.Phase.END && hitmarkerTick > 0) {
            --hitmarkerTick;
        }
    }

    public void fovUpdate(FOVUpdateEvent event) {
        PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
        if (entityPlayer != null && BUTTON_AIM_DOWN.get().booleanValue() && !entityPlayer.func_70051_ag()) {
            Optic optic = null;
            float modifier = 1.0f;
            float extra = 0.0f;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                if (entityPlayer.func_184592_cb().func_190926_b()) {
                    ItemStack itemStack = entityPlayer.func_184614_ca();
                    ItemGun gun = (ItemGun)itemStack.func_77973_b();
                    if (gun.getNBTCanAimGun(itemStack)) {
                        optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                    }
                    if (optic != null && gun.isNBTAccessoryTurnedOn(itemStack) && !gun.getAttachment(itemStack, EnumAttachmentType.ACCESSORY).isDefault()) {
                        Accessory accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                        if (optic.isCompatibleWithMagnifiers()) {
                            modifier = accessory.getZoomModifier();
                        }
                        if (optic.isCompatibleWithExtraZoom()) {
                            extra = accessory.getExtraZoom();
                        }
                    }
                }
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                ItemStack itemStack = entityPlayer.func_184614_ca();
                optic = (Optic)itemStack.func_77973_b();
            }
            if (optic != null && optic.canAim()) {
                event.setNewfov(ProxyClient.calculateFov(optic.getZoom() * modifier + 0.1f + extra, event.getFov()));
            }
        }
    }

    public static float calculateFov(float zoom, float fov) {
        return (float)Math.atan(Math.tan(fov) / (double)zoom);
    }

    public void renderGameOverlayPre(RenderGameOverlayEvent.Pre event) {
        PlayerEntity entityPlayer = ProxyClient.getClientPlayer();
        if (event.getType() == RenderGameOverlayEvent.ElementType.CROSSHAIRS && entityPlayer != null) {
            ItemStack itemStack;
            ItemGun gun;
            Optic optic = null;
            if (entityPlayer.func_184614_ca().func_77973_b() instanceof ItemGun || entityPlayer.func_184592_cb().func_77973_b() instanceof ItemGun) {
                if (entityPlayer.func_184592_cb().func_190926_b() && (gun = (ItemGun)(itemStack = entityPlayer.func_184614_ca()).func_77973_b()).getNBTCanAimGun(itemStack)) {
                    optic = (Optic)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.OPTIC));
                }
                event.setCanceled(true);
            } else if (entityPlayer.func_184614_ca().func_77973_b() instanceof Optic) {
                optic = (Optic)entityPlayer.func_184614_ca().func_77973_b();
            }
            if (optic != null && optic.canAim() && !entityPlayer.func_70051_ag() && BUTTON_AIM_DOWN.get().booleanValue()) {
                ProxyClient.drawSight(optic, event.getWindow());
                if (!event.isCanceled()) {
                    event.setCanceled(true);
                }
            }
            Vec3d start = new Vec3d(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityPlayer.field_70161_v);
            for (Hand hand : GunCusUtility.HANDS) {
                Accessory accessory;
                itemStack = entityPlayer.func_184586_b(hand);
                if (itemStack.func_77973_b() instanceof ItemGun) {
                    gun = (ItemGun)itemStack.func_77973_b();
                    accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                } else {
                    accessory = itemStack.func_77973_b() instanceof Accessory ? (Accessory)itemStack.func_77973_b() : (Accessory)EnumAttachmentType.ACCESSORY.getDefault();
                }
                if (accessory.getLaser() == null || !accessory.getLaser().isRangeFinder()) continue;
                Vec3d end = start.func_178787_e(entityPlayer.func_70040_Z().func_72432_b().func_186678_a(accessory.getLaser().getMaxRange()));
                Vec3d hit = ProxyClient.findHit(entityPlayer.field_70170_p, (Entity)entityPlayer, start, end);
                hit = hit.func_178788_d(start);
                ProxyClient.drawRangeFinder(event.getWindow(), hand, hit.func_72433_c());
            }
            if (hitmarkerTick > 0) {
                ProxyClient.drawHitmarker(event.getWindow());
            }
        }
    }

    public static void drawSight(Optic optic, MainWindow sr) {
        ProxyClient.drawDrawFullscreenImage(optic.getOverlay(), 1024, 256, sr);
    }

    public static void drawRangeFinder(MainWindow sr, Hand hand, double range) {
        ProxyClient.drawRangeFinder(sr, hand, (int)range + "");
    }

    public static void drawRangeFinder(MainWindow sr, Hand hand, String text) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int off = 8;
        FontRenderer font = ProxyClient.getMC().field_71466_p;
        off = hand == Hand.OFF_HAND ? -(font.func_78256_a(text) + 1 + off) : off;
        font.func_175063_a(text, (float)(sr.func_198107_o() / 2 + off), (float)(sr.func_198087_p() / 2), 0xFFFFFF);
        GlStateManager.disableBlend();
        GlStateManager.popMatrix();
    }

    public static void drawHitmarker(MainWindow sr) {
        ProxyClient.drawDrawFullscreenImage(HITMARKER_TEXTURE, 1024, 256, sr);
    }

    public static void drawDrawFullscreenImage(ResourceLocation rl, int texWidth, int texHeight, MainWindow sr) {
        GlStateManager.pushMatrix();
        GlStateManager.enableBlend();
        GlStateManager.disableDepthTest();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.disableAlphaTest();
        ProxyClient.getMC().func_110434_K().func_110577_a(rl);
        double x = sr.func_198107_o();
        double y = sr.func_198087_p();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder b = tessellator.func_178180_c();
        b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        b.func_181662_b(x * 0.5 - 2.0 * y, y, -90.0).func_187315_a(0.0, 1.0).func_181675_d();
        b.func_181662_b(x * 0.5 + 2.0 * y, y, -90.0).func_187315_a(1.0, 1.0).func_181675_d();
        b.func_181662_b(x * 0.5 + 2.0 * y, 0.0, -90.0).func_187315_a(1.0, 0.0).func_181675_d();
        b.func_181662_b(x * 0.5 - 2.0 * y, 0.0, -90.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.depthMask((boolean)true);
        GlStateManager.enableDepthTest();
        GlStateManager.enableAlphaTest();
        GlStateManager.popMatrix();
    }

    public void renderWorldLast(RenderWorldLastEvent event) {
        GlStateManager.pushMatrix();
        if (ProxyClient.getMC().func_175606_aa() != null) {
            Vec3d projectedView = ProxyClient.getMC().func_175606_aa().func_174824_e(1.0f);
            GlStateManager.translated((double)(-projectedView.field_72450_a), (double)(-projectedView.field_72448_b), (double)(-projectedView.field_72449_c));
        }
        if (ProxyClient.getMC().func_175606_aa() != null) {
            World world = ProxyClient.getMC().func_175606_aa().field_70170_p;
            for (PlayerEntity player : world.func_217369_A()) {
                Vec3d playerPos = player.func_174824_e(1.0f);
                Vec3d playerLook = player.func_70040_Z().func_72432_b();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder b = tessellator.func_178180_c();
                for (PlayerEntity entityPlayer : world.func_217369_A()) {
                    if (!entityPlayer.func_70089_S()) continue;
                    for (Hand hand : GunCusUtility.HANDS) {
                        Accessory accessory = null;
                        ItemStack itemStack = entityPlayer.func_184586_b(hand);
                        if (itemStack.func_77973_b() instanceof ItemGun) {
                            ItemGun gun = (ItemGun)itemStack.func_77973_b();
                            if (gun.isNBTAccessoryTurnedOn(itemStack)) {
                                accessory = (Accessory)((Object)gun.getAttachmentCalled(itemStack, EnumAttachmentType.ACCESSORY));
                            }
                        } else if (itemStack.func_77973_b() instanceof Accessory) {
                            accessory = (Accessory)itemStack.func_77973_b();
                        }
                        if (accessory == null || accessory.getLaser() == null) continue;
                        Accessory.Laser laser = accessory.getLaser();
                        Vec3d handOff = ProxyClient.getOffsetForHand(entityPlayer, hand);
                        Vec3d start = playerPos.func_178787_e(handOff);
                        Vec3d end = start.func_178787_e(playerLook.func_186678_a(laser.getMaxRange()));
                        end = ProxyClient.findHit(world, (Entity)entityPlayer, start, end);
                        GlStateManager.disableTexture();
                        if (laser.isPoint() && !tmpHitNothing) {
                            ProxyClient.renderLaserPoint(b, tessellator, laser, start, end);
                        }
                        if (laser.isBeam()) {
                            ProxyClient.renderLaserBeam(b, tessellator, laser, start.func_178787_e(ProxyClient.getVectorForRotation(entityPlayer.field_70125_A + -345.0f, entityPlayer.field_70177_z)), end);
                        }
                        GlStateManager.enableTexture();
                    }
                }
            }
        }
        GlStateManager.popMatrix();
    }

    public static void renderLaserPoint(BufferBuilder b, Tessellator tessellator, Accessory.Laser laser, Vec3d start, Vec3d end) {
        b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        double size = 0.05;
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c + 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a - 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b + 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a + 0.05, end.field_72448_b - 0.05, end.field_72449_c - 0.05).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void renderLaserBeam(BufferBuilder b, Tessellator tessellator, Accessory.Laser laser, Vec3d start, Vec3d end) {
        b.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        b.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        b.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_181666_a(laser.getR(), laser.getG(), laser.getB(), 1.0f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static Vec3d getVectorForRotation(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vec3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static Vec3d getOffsetForHandRaw(PlayerEntity entityPlayer, Hand hand) {
        Vec3d vec = ProxyClient.getVectorForRotation(entityPlayer.field_70125_A + 1.0f, entityPlayer.field_70177_z + 90.0f);
        if (hand == Hand.OFF_HAND) {
            vec = vec.func_186678_a(-1.0);
        }
        if (entityPlayer.field_70125_A >= 89.0f) {
            vec = vec.func_186678_a(-1.0);
        }
        return new Vec3d(vec.field_72450_a, 0.0, vec.field_72449_c).func_72432_b().func_186678_a(0.4);
    }

    public static Vec3d getOffsetForHand(PlayerEntity entityPlayer, Hand hand) {
        Vec3d vec = ProxyClient.getOffsetForHandRaw(entityPlayer, hand);
        return vec.func_178787_e(ProxyClient.getVectorForRotation(entityPlayer.field_70125_A, entityPlayer.field_70177_z).func_186678_a(0.4));
    }

    public static Vec3d findHit(World world, Entity entity, Vec3d start, Vec3d end) {
        tmpHitNothing = false;
        BlockRayTraceResult resultBlock = ProxyClient.findBlockOnPath(world, entity, start, end);
        EntityRayTraceResult resultEntity = ProxyClient.findEntityOnPath(world, entity, start, end);
        if (resultEntity != null) {
            double rangeEntitySq;
            double rangeBlockSq = resultBlock.func_216347_e().func_72436_e(start);
            if (rangeBlockSq < (rangeEntitySq = resultEntity.func_216347_e().func_72436_e(start))) {
                return resultBlock.func_216347_e();
            }
            return resultEntity.func_216347_e();
        }
        tmpHitNothing = world.func_180495_p(resultBlock.func_216350_a()).func_177230_c() == Blocks.field_150350_a;
        return resultBlock.func_216347_e();
    }

    public static BlockRayTraceResult findBlockOnPath(World world, Entity entity, Vec3d start, Vec3d end) {
        return world.func_217299_a(new RayTraceContext(start, end, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
    }

    public static EntityRayTraceResult findEntityOnPath(World world, Entity entity0, Vec3d start, Vec3d end) {
        EntityRayTraceResult result = null;
        double rangeSq = 0.0;
        for (Entity entity : world.func_175674_a(entity0, GunCusUtility.aabbFromVec3ds(start, end), entity1 -> true)) {
            double currentRangeSq;
            AxisAlignedBB axisalignedbb;
            Optional opt;
            if (entity == null || entity.func_145782_y() == entity0.func_145782_y() || entity instanceof EntityBullet || !(opt = (axisalignedbb = entity.func_174813_aQ().func_186662_g((double)0.3f)).func_216365_b(start, end)).isPresent() || !((currentRangeSq = start.func_72436_e(entity.func_213303_ch())) < rangeSq) && result != null) continue;
            result = new EntityRayTraceResult(entity, (Vec3d)opt.get());
            rangeSq = currentRangeSq;
        }
        return result;
    }

    public static Minecraft getMC() {
        return Minecraft.func_71410_x();
    }

    @Nullable
    public static PlayerEntity getClientPlayer() {
        return ProxyClient.getMC().field_71439_g;
    }
}

