/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.entity;

import de.cas_ual_ty.guncus.GunCus;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityBullet
extends ThrowableEntity {
    public static final float BASE_SPEED = 20.0f;
    public static final int TICKS = 1;
    protected static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(EntityBullet.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> GRAVITY = EntityDataManager.func_187226_a(EntityBullet.class, (IDataSerializer)DataSerializers.field_187193_c);

    public EntityBullet(EntityType<EntityBullet> type, World worldIn) {
        super(type, worldIn);
    }

    public EntityBullet(EntityType<EntityBullet> type, LivingEntity livingEntityIn, World worldIn) {
        super(type, livingEntityIn, worldIn);
    }

    public EntityBullet setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
        return this;
    }

    public EntityBullet setGravity(float gravity) {
        this.field_70180_af.func_187227_b(GRAVITY, (Object)Float.valueOf(gravity));
        return this;
    }

    public void func_70071_h_() {
        this.func_213317_d(this.func_213322_ci().func_186678_a(1.0));
        for (int i = 0; i < 1; ++i) {
            super.func_70071_h_();
        }
        this.func_213317_d(this.func_213322_ci().func_186678_a(1.0));
        this.spawnParticles();
        if (this.field_70173_aa >= 20) {
            this.func_70106_y();
        }
    }

    public void spawnParticles() {
        Vec3d vec3d = this.func_213322_ci();
        double d1 = vec3d.field_72450_a;
        double d2 = vec3d.field_72448_b;
        double d0 = vec3d.field_72449_c;
        for (int i = 0; i < 4; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.field_70165_t + d1 * (double)i / 4.0, this.field_70163_u + d2 * (double)i / 4.0, this.field_70161_v + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.field_70165_t + d1 * (double)i / 4.0, this.field_70163_u + d2 * (double)i / 4.0, this.field_70161_v + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197627_t, this.field_70165_t + d1 * (double)i / 4.0, this.field_70163_u + d2 * (double)i / 4.0, this.field_70161_v + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.field_70165_t + d1 * (double)i / 4.0, this.field_70163_u + d2 * (double)i / 4.0, this.field_70161_v + d0 * (double)i / 4.0, -d1, -d2 + 0.2, -d0);
        }
    }

    protected void func_70184_a(RayTraceResult result) {
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY) {
            EntityRayTraceResult hit = (EntityRayTraceResult)result;
            if (hit.func_216348_a() == this.func_85052_h() && this.field_70173_aa <= 5) {
                return;
            }
            if (!this.field_70170_p.field_72995_K && hit.func_216348_a() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)hit.func_216348_a();
                entity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.func_85052_h()), this.getBulletDamage());
                if (this.func_85052_h() instanceof PlayerEntity) {
                    GunCus.proxy.addHitmarker((PlayerEntity)this.func_85052_h());
                }
            }
        }
        this.func_70106_y();
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(4.0f));
        this.field_70180_af.func_187214_a(GRAVITY, (Object)Float.valueOf(1.0f));
    }

    protected float func_70185_h() {
        return super.func_70185_h() * this.getBulletGravity() / 1.0f;
    }

    protected float getBulletDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    protected float getBulletGravity() {
        return ((Float)this.field_70180_af.func_187225_a(GRAVITY)).floatValue();
    }
}

