/*
 * Decompiled with CFR 0.152.
 */
package de.cas_ual_ty.guncus.item;

import de.cas_ual_ty.guncus.GunCus;
import de.cas_ual_ty.guncus.entity.EntityBullet;
import de.cas_ual_ty.guncus.item.ItemAttachment;
import de.cas_ual_ty.guncus.item.ItemBullet;
import de.cas_ual_ty.guncus.item.attachments.Ammo;
import de.cas_ual_ty.guncus.item.attachments.Auxiliary;
import de.cas_ual_ty.guncus.item.attachments.Barrel;
import de.cas_ual_ty.guncus.item.attachments.EnumAttachmentType;
import de.cas_ual_ty.guncus.item.attachments.Magazine;
import de.cas_ual_ty.guncus.item.attachments.Underbarrel;
import de.cas_ual_ty.guncus.itemgroup.ItemGroupGun;
import de.cas_ual_ty.guncus.registries.GunCusEntityTypes;
import de.cas_ual_ty.guncus.registries.GunCusSoundEvents;
import de.cas_ual_ty.guncus.util.GunCusUtility;
import de.cas_ual_ty.guncus.util.RandomTradeBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ItemGun
extends Item {
    public static final ArrayList<ItemGun> GUNS_LIST = new ArrayList();
    public static final String NBT_RELOAD_TIME = "ReloadTime";
    public static final String NBT_RELOAD_TYPE = "ReloadType";
    public static final String NBT_AMMO = "Ammo";
    public static final String NBT_ACCESSORY_SWITCH = "AccessorySwitch";
    protected int fireRate;
    protected int maxAmmo;
    protected float baseDamage;
    protected Supplier<ItemBullet> bullet;
    protected Supplier<Integer> switchTime;
    protected int reloadTime;
    protected EnumFireMode fireMode;
    protected EnumReloadType fullReloadType;
    protected Supplier<SoundEvent> soundShoot;
    protected Supplier<SoundEvent> soundShootSilenced;
    protected Supplier<SoundEvent> soundReload;
    protected Supplier<SoundEvent> soundReloadBolt;
    public Supplier<ItemAttachment[][]> supplierAttachments;
    protected ItemAttachment[][] attachments;
    public ItemGroupGun gunTab;

    public ItemGun(Item.Properties properties, int fireRate, int maxAmmo, float baseDamage, Supplier<ItemBullet> bullet) {
        super(properties);
        this.fireRate = fireRate;
        this.maxAmmo = maxAmmo;
        this.baseDamage = baseDamage;
        this.bullet = bullet;
        this.switchTime = () -> this.getBaseFireRate() * 3;
        this.reloadTime = 100;
        this.fireMode = EnumFireMode.FULL_AUTO;
        this.fullReloadType = EnumReloadType.MAGAZINE;
        this.supplierAttachments = ItemAttachment::buildDefaultArray;
        this.attachments = null;
        this.soundShoot = () -> GunCusSoundEvents.SHOOT;
        this.soundShootSilenced = () -> GunCusSoundEvents.SHOOT_SILENCED;
        this.soundReload = () -> GunCusSoundEvents.RELOAD;
        this.gunTab = null;
        GUNS_LIST.add(this);
    }

    public ItemGun setDefaultTradeable(int price, int level) {
        new RandomTradeBuilder(1, 5 * level, 0.1f).setEmeraldPriceFor(price, this, 1).registerLevel(level);
        return this;
    }

    public ItemGun createGunTab(String label) {
        this.gunTab = new ItemGroupGun(label, this);
        return this;
    }

    public int getBaseFireRate() {
        return this.fireRate;
    }

    public int getBaseMaxAmmo() {
        return this.maxAmmo;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public ItemBullet getBaseBullet() {
        return this.bullet.get();
    }

    public int getBaseSwitchTime() {
        return this.switchTime.get();
    }

    public int getBaseReloadTime() {
        return this.reloadTime;
    }

    public EnumFireMode getBaseFireMode() {
        return this.fireMode;
    }

    public EnumReloadType getBaseFullReloadType() {
        return this.fullReloadType;
    }

    public ItemBullet calcCurrentBullet(ItemAttachment[] attachments) {
        return ((Ammo)attachments[EnumAttachmentType.AMMO.getSlot()]).getUsedBullet(this);
    }

    public int calcCurrentMaxAmmo(ItemAttachment[] attachments) {
        return ((Magazine)attachments[EnumAttachmentType.MAGAZINE.getSlot()]).getExtraCapacity() + this.getBaseMaxAmmo();
    }

    public int calcCurrentFireRate(ItemAttachment[] attachments) {
        return Math.max(1, this.getBaseFireRate() - ((Auxiliary)attachments[EnumAttachmentType.AUXILIARY.getSlot()]).getExtraFireRare());
    }

    public int calcCurrentReloadTime(ItemAttachment[] attachments) {
        return (int)(((Magazine)attachments[EnumAttachmentType.MAGAZINE.getSlot()]).getReloadTimeModifier() * (float)this.getBaseReloadTime());
    }

    public boolean calcIsAllowingReloadWhileZoomed(ItemAttachment[] attachments) {
        return ((Auxiliary)attachments[EnumAttachmentType.AUXILIARY.getSlot()]).getIsAllowingReloadWhileZoomed();
    }

    public int calcCurrentSwitchTime(ItemAttachment[] attachments) {
        return this.getBaseSwitchTime();
    }

    public ItemGun setSoundShoot(Supplier<SoundEvent> soundShoot) {
        this.soundShoot = soundShoot;
        return this;
    }

    public ItemGun setSoundShootSilenced(Supplier<SoundEvent> soundShootSilenced) {
        this.soundShootSilenced = soundShootSilenced;
        return this;
    }

    public ItemGun setSoundReload(Supplier<SoundEvent> soundReload) {
        this.soundReload = soundReload;
        return this;
    }

    public ItemGun setBoltAction(Supplier<SoundEvent> soundReloadBolt) {
        this.soundReloadBolt = soundReloadBolt;
        return this.setFireMode(EnumFireMode.BOLT_ACTION);
    }

    public ItemGun setSemiAuto() {
        return this.setFireMode(EnumFireMode.SEMI_AUTO);
    }

    protected ItemGun setFireMode(EnumFireMode fireMode) {
        this.fireMode = fireMode;
        return this;
    }

    public ItemGun setAttachments(Supplier<ItemAttachment[][]> attachments) {
        this.supplierAttachments = attachments;
        this.attachments = null;
        return this;
    }

    public ItemAttachment[][] getAttachments() {
        if (this.attachments == null) {
            this.attachments = this.supplierAttachments.get();
        }
        return this.attachments;
    }

    public ItemAttachment getAttachment(EnumAttachmentType type, int index) {
        return this.getAttachments()[type.getSlot()][index];
    }

    public int getIndexForAttachment(ItemAttachment attachment) {
        for (int i = 0; i < this.getAttachments()[attachment.getSlot()].length; ++i) {
            if (this.getAttachments()[attachment.getSlot()][i] != attachment) continue;
            return i;
        }
        return -1;
    }

    public int getAmmountForSlot(EnumAttachmentType type) {
        return this.getAttachments()[type.getSlot()].length;
    }

    public boolean isSlotAvailable(EnumAttachmentType type) {
        return this.getAttachments()[type.getSlot()].length > 1;
    }

    public ItemStack getAttachmentStack(ItemStack itemStack, EnumAttachmentType type) {
        ItemAttachment attachment = this.getAttachment(itemStack, type);
        return attachment.isDefault() || attachment == this.getAttachments()[type.getSlot()][0] ? ItemStack.field_190927_a : new ItemStack((IItemProvider)attachment);
    }

    public ItemAttachment getAttachment(ItemStack itemStack, EnumAttachmentType type) {
        return this.getAttachment(type, this.getNBT(itemStack).func_74762_e(type.getKey()));
    }

    public ItemStack getAttachmentItemStack(ItemStack itemStack, EnumAttachmentType type) {
        ItemAttachment attachment = this.getAttachment(itemStack, type);
        return attachment.isDefault() ? ItemStack.field_190927_a : new ItemStack((IItemProvider)attachment);
    }

    public ItemStack setAttachment(ItemStack itemStack, ItemAttachment attachment) {
        this.getNBT(itemStack).func_74768_a(attachment.getType().getKey(), this.getIndexForAttachment(attachment));
        return itemStack;
    }

    public ItemStack setAttachments(ItemStack itemStack, ItemAttachment[] attachments) {
        for (ItemAttachment attachment : attachments) {
            this.setAttachment(itemStack, attachment);
        }
        return itemStack;
    }

    public ItemStack createVariant(ItemAttachment[] attachments) {
        return this.setAttachments(new ItemStack((IItemProvider)this), attachments);
    }

    public boolean canSetAttachment(ItemAttachment attachment) {
        return this.getIndexForAttachment(attachment) >= 0;
    }

    public <A extends ItemAttachment> A getAttachmentCalled(ItemStack itemStack, EnumAttachmentType type) {
        return (A)((Object)this.getAttachment(itemStack, type));
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        return new ActionResult(ActionResultType.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity) {
            int value;
            PlayerEntity entityPlayer = (PlayerEntity)entity;
            boolean isInAnyHand = false;
            for (Hand hand : GunCusUtility.HANDS) {
                if (entityPlayer.func_184586_b(hand) != itemStack) continue;
                isInAnyHand = true;
                break;
            }
            if ((value = this.getNBTCurrentReloadTime(itemStack)) > 0) {
                EnumReloadType type = this.getNBTCurrentReloadType(itemStack);
                ItemAttachment[] attachments = this.getCurrentAttachments(itemStack);
                boolean hasAmmo = this.getHasAmmo(entityPlayer, attachments, itemStack);
                if (type == EnumReloadType.MAGAZINE) {
                    if (!isInAnyHand || !hasAmmo) {
                        value = 0;
                    } else if (--value == 0) {
                        this.tryFinishReload(entityPlayer, attachments, itemStack);
                    }
                } else if (type == EnumReloadType.BOLT) {
                    if (value == this.getBaseFireRate() && isInAnyHand) {
                        --value;
                        entityPlayer.func_184185_a(this.soundReloadBolt.get(), 1.0f, 1.0f);
                    } else if (--value > 0 && !isInAnyHand) {
                        value = this.getBaseFireRate();
                    }
                }
                this.setNBTCurrentReloadTime(itemStack, value);
            }
        }
    }

    public ActionResultType tryShootOrReload(PlayerEntity entityPlayer, Hand hand, ItemStack itemStack, boolean aiming, boolean moving, int inaccuracy) {
        ItemAttachment[] attachments = this.getCurrentAttachments(itemStack);
        if (this.getNBTCurrentReloadTime(itemStack) <= 0) {
            if (this.canShoot(entityPlayer, hand, attachments, itemStack, aiming, moving, inaccuracy)) {
                return this.doShoot(entityPlayer, hand, attachments, itemStack, aiming, moving, inaccuracy);
            }
            if (this.canReload(entityPlayer, hand, attachments, itemStack, aiming, moving, inaccuracy)) {
                return this.tryStartReload(entityPlayer, attachments, itemStack);
            }
        }
        return ActionResultType.PASS;
    }

    public boolean canShoot(PlayerEntity entityPlayer, Hand hand, ItemAttachment[] attachments, ItemStack itemStack, boolean aiming, boolean moving, int inaccuracy) {
        return this.getNBTCurrentAmmo(itemStack) > 0 || entityPlayer.func_184812_l_();
    }

    public boolean canReload(PlayerEntity entityPlayer, Hand hand, ItemAttachment[] attachments, ItemStack itemStack, boolean aiming, boolean moving, int inaccuracy) {
        return this.getHasAmmo(entityPlayer, attachments, itemStack) && (this.getBaseFireMode() != EnumFireMode.BOLT_ACTION || !aiming || this.calcIsAllowingReloadWhileZoomed(attachments));
    }

    public boolean getHasAmmo(PlayerEntity entityPlayer, ItemAttachment[] attachments, ItemStack itemStack) {
        ItemBullet bullet = this.calcCurrentBullet(attachments);
        for (int index = 0; index < entityPlayer.field_71071_by.func_70302_i_(); ++index) {
            if (entityPlayer.field_71071_by.func_70301_a(index).func_77973_b() != bullet) continue;
            return true;
        }
        return false;
    }

    public ActionResultType doShoot(PlayerEntity entityPlayer, Hand hand, ItemAttachment[] attachments, ItemStack itemStack, boolean aiming, boolean moving, int inaccuracyInt) {
        float extraDamage = 0.0f;
        float driftModifier = 1.0f;
        float speedModifier = 1.0f;
        float spreadModifierVertical = 1.0f;
        float spreadModifierHorizontal = 1.0f;
        float inaccuracyModifier = 1.0f;
        float inaccuracyModifierMoving = 1.0f;
        float inaccuracyModifierStill = 1.0f;
        for (ItemAttachment attachment : attachments) {
            extraDamage += attachment.getExtraDamage();
            driftModifier *= attachment.getDriftModifier();
            speedModifier *= attachment.getSpeedModifier();
            spreadModifierVertical *= attachment.getSpreadModifierVertical();
            spreadModifierHorizontal *= attachment.getSpreadModifierHorizontal();
            inaccuracyModifier *= attachment.getInaccuracyModifier();
            inaccuracyModifierMoving *= attachment.getInaccuracyModifierMoving();
            inaccuracyModifierStill *= attachment.getInaccuracyModifierStill();
        }
        ItemBullet bullet = this.calcCurrentBullet(attachments);
        float inaccuracy = (float)inaccuracyInt * inaccuracyModifier;
        float speed = 20.0f * speedModifier;
        float damage = this.getBaseDamage() + extraDamage + bullet.getExtraDamage();
        if (aiming) {
            inaccuracy *= 0.5f;
        }
        if (moving) {
            inaccuracy *= inaccuracyModifierMoving;
        } else {
            inaccuracy *= inaccuracyModifierStill;
            if (entityPlayer.func_70093_af()) {
                inaccuracy *= ((Underbarrel)attachments[EnumAttachmentType.UNDERBARREL.getSlot()]).getInaccuracyModifierShiftStill();
                driftModifier *= ((Underbarrel)attachments[EnumAttachmentType.UNDERBARREL.getSlot()]).getDriftModifierShiftStill();
            }
        }
        inaccuracy *= 0.0f;
        if (!entityPlayer.field_70170_p.field_72995_K) {
            for (int i = 0; i < bullet.getProjectileAmount(); ++i) {
                float randomPitch = (Item.field_77697_d.nextFloat() * 2.0f - 1.0f) * spreadModifierVertical * inaccuracy * bullet.getSpreadModifier();
                float randomYaw = (Item.field_77697_d.nextFloat() * 2.0f - 1.0f) * spreadModifierHorizontal * inaccuracy * bullet.getSpreadModifier();
                float rotationPitch = entityPlayer.field_70125_A + randomPitch;
                float rotationYaw = entityPlayer.field_70177_z + randomYaw;
                EntityBullet bulletEntity = new EntityBullet(GunCusEntityTypes.BULLET, (LivingEntity)entityPlayer, entityPlayer.field_70170_p);
                bulletEntity.func_70107_b(entityPlayer.field_70165_t, entityPlayer.field_70163_u + (double)entityPlayer.func_70047_e(), entityPlayer.field_70161_v);
                bulletEntity.func_184538_a((Entity)entityPlayer, rotationPitch, rotationYaw, 0.0f, speed, 0.0f);
                bulletEntity.setGravity(0.0f);
                entityPlayer.field_70170_p.func_217376_c((Entity)bulletEntity.setDamage(damage));
            }
            if (!entityPlayer.func_184812_l_()) {
                this.setNBTCurrentAmmo(itemStack, this.getNBTCurrentAmmo(itemStack) - 1);
            }
            if (this.getBaseFireMode() == EnumFireMode.BOLT_ACTION) {
                this.setNBTCurrentReloadTime(itemStack, this.getBaseFireRate());
                this.setNBTCurrentReloadType(itemStack, EnumReloadType.BOLT);
            }
        } else {
            entityPlayer.field_70125_A -= Item.field_77697_d.nextFloat() * driftModifier;
            entityPlayer.field_70177_z += (Item.field_77697_d.nextFloat() * 2.0f - 1.0f) * driftModifier;
        }
        if (((Barrel)attachments[EnumAttachmentType.BARREL.getSlot()]).getIsSilenced()) {
            entityPlayer.func_184185_a(this.soundShootSilenced.get(), 3.0f, 0.9f + Item.field_77697_d.nextFloat() * 0.2f);
        } else {
            entityPlayer.func_184185_a(this.soundShoot.get(), 3.0f, 0.9f + Item.field_77697_d.nextFloat() * 0.2f);
        }
        GunCus.proxy.shot(itemStack, this, entityPlayer, hand);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType tryStartReload(PlayerEntity entityPlayer, ItemAttachment[] attachments, ItemStack itemStack) {
        if (this.getHasAmmo(entityPlayer, attachments, itemStack)) {
            return this.doStartReload(entityPlayer, attachments, itemStack);
        }
        return ActionResultType.PASS;
    }

    public ActionResultType doStartReload(PlayerEntity entityPlayer, ItemAttachment[] attachments, ItemStack itemStack) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.setNBTCurrentReloadTime(itemStack, this.calcCurrentReloadTime(attachments));
            if (this.getBaseFireMode() == EnumFireMode.BOLT_ACTION) {
                this.setNBTCurrentReloadType(itemStack, this.getBaseFullReloadType());
            }
        }
        entityPlayer.func_184185_a(this.soundReload.get(), 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    public ActionResultType tryFinishReload(PlayerEntity entityPlayer, ItemAttachment[] attachments, ItemStack itemStack) {
        ItemBullet bullet = this.calcCurrentBullet(attachments);
        int maxAmmo = this.calcCurrentMaxAmmo(attachments);
        int amount = this.getNBTCurrentAmmo(itemStack);
        for (int index = 0; index < entityPlayer.field_71071_by.func_70302_i_(); ++index) {
            ItemStack i = entityPlayer.field_71071_by.func_70301_a(index);
            if (i.func_77973_b() == bullet) {
                int needed = maxAmmo - amount;
                if (i.func_190916_E() > needed) {
                    i.func_190920_e(i.func_190916_E() - needed);
                    amount += needed;
                } else {
                    amount += i.func_190916_E();
                    i.func_190920_e(0);
                }
            }
            if (amount >= maxAmmo) break;
        }
        if (amount > 0) {
            return this.doFinishReload(entityPlayer, attachments, itemStack, amount);
        }
        return ActionResultType.PASS;
    }

    public ActionResultType doFinishReload(PlayerEntity entityPlayer, ItemAttachment[] attachments, ItemStack itemStack, int ammount) {
        if (!entityPlayer.field_70170_p.field_72995_K) {
            this.setNBTCurrentAmmo(itemStack, ammount);
        }
        return ActionResultType.SUCCESS;
    }

    public boolean isNBTAccessoryTurnedOn(ItemStack itemStack) {
        if (!this.getNBT(itemStack).func_74764_b(NBT_ACCESSORY_SWITCH)) {
            this.setNBTAccessoryTurnedOn(itemStack, true);
        }
        return this.getNBT(itemStack).func_74767_n(NBT_ACCESSORY_SWITCH);
    }

    public void setNBTAccessoryTurnedOn(ItemStack itemStack, boolean b) {
        this.getNBT(itemStack).func_74757_a(NBT_ACCESSORY_SWITCH, b);
    }

    public boolean getNBTCanAimGun(ItemStack itemStack) {
        return !this.getNBTIsReloading(itemStack) || this.getBaseFireMode() == EnumFireMode.BOLT_ACTION && this.calcIsAllowingReloadWhileZoomed(this.getCurrentAttachments(itemStack));
    }

    public int getNBTCurrentReloadTime(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e(NBT_RELOAD_TIME);
    }

    public EnumReloadType getNBTCurrentReloadType(ItemStack itemStack) {
        return this.getBaseFireMode() == EnumFireMode.BOLT_ACTION ? EnumReloadType.get(this.getNBT(itemStack).func_74762_e(NBT_RELOAD_TYPE)) : EnumReloadType.MAGAZINE;
    }

    public void setNBTCurrentReloadTime(ItemStack itemStack, int i) {
        this.getNBT(itemStack).func_74768_a(NBT_RELOAD_TIME, i);
    }

    public void setNBTCurrentReloadType(ItemStack itemStack, EnumReloadType type) {
        this.getNBT(itemStack).func_74768_a(NBT_RELOAD_TYPE, type.index);
    }

    public boolean getNBTIsReloading(ItemStack itemStack) {
        return this.getNBTCurrentReloadTime(itemStack) > 0;
    }

    public int getNBTCurrentAmmo(ItemStack itemStack) {
        return this.getNBT(itemStack).func_74762_e(NBT_AMMO);
    }

    public void setNBTCurrentAmmo(ItemStack itemStack, int i) {
        this.getNBT(itemStack).func_74768_a(NBT_AMMO, i);
    }

    public CompoundNBT getNBT(ItemStack itemStack) {
        return itemStack.func_196082_o();
    }

    public ItemAttachment[] getCurrentAttachments(ItemStack itemStack) {
        ItemAttachment[] attachments = new ItemAttachment[EnumAttachmentType.LENGTH];
        for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
            attachments[type.getSlot()] = this.getAttachment(itemStack, type);
        }
        return attachments;
    }

    public boolean onEntitySwing(ItemStack itemStack, LivingEntity entityLivingBase) {
        return true;
    }

    public boolean func_195938_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        return !player.func_184812_l_();
    }

    public void func_77624_a(ItemStack itemStack, World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        ItemAttachment[] attachments = this.getCurrentAttachments(itemStack);
        int maxAmmo = this.calcCurrentMaxAmmo(attachments);
        ItemBullet bullet = this.calcCurrentBullet(attachments);
        ITextComponent tAmmo = new StringTextComponent(this.getNBTCurrentAmmo(itemStack) + "").func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        StringTextComponent tMaxAmmo = new StringTextComponent("/" + maxAmmo);
        ITextComponent tBullet = new TranslationTextComponent(bullet.func_77658_a(), new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.YELLOW));
        list.add((ITextComponent)new StringTextComponent(tAmmo.func_150254_d() + tMaxAmmo.func_150254_d() + " " + tBullet.func_150254_d()));
        int ammount = 0;
        for (int i = 0; i < attachments.length; ++i) {
            if (attachments[i].isDefault()) continue;
            ++ammount;
        }
        if (ammount > 0) {
            list.add(ItemAttachment.getAttachmentTranslated(ammount > 1).func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150258_a(":"));
            for (EnumAttachmentType type : EnumAttachmentType.VALUES) {
                if (!this.isSlotAvailable(type)) continue;
                ItemAttachment attachment = this.getAttachment(itemStack, type);
                if (attachment != null) {
                    list.add((ITextComponent)new StringTextComponent(attachment.getInformationString().func_150254_d() + ItemGun.getSlotDisplaySuffix(type)));
                    continue;
                }
                list.add((ITextComponent)new StringTextComponent("--" + ItemGun.getSlotDisplaySuffix(type)));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getNBTIsReloading(stack) || this.getNBTCurrentAmmo(stack) > 0;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (this.getNBTIsReloading(stack)) {
            EnumReloadType type = this.getNBTCurrentReloadType(stack);
            if (type == EnumReloadType.BOLT) {
                return (double)this.getNBTCurrentReloadTime(stack) / (double)this.getBaseFireRate();
            }
            return (double)this.getNBTCurrentReloadTime(stack) / (double)this.calcCurrentReloadTime(this.getCurrentAttachments(stack));
        }
        return 1.0 - (double)this.getNBTCurrentAmmo(stack) / (double)this.calcCurrentMaxAmmo(this.getCurrentAttachments(stack));
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return this.getNBTIsReloading(stack) ? 0xFF0000 : 65280;
    }

    public static void tryShoot(PlayerEntity player, boolean aiming, int inaccuracy, Hand[] hands) {
        for (Hand hand : hands) {
            ItemStack item = player.func_184586_b(hand);
            if (!(item.func_77973_b() instanceof ItemGun)) continue;
            ((ItemGun)item.func_77973_b()).tryShootOrReload(player, hand, item, aiming, player.func_213322_ci().func_189985_c() > 0.0, inaccuracy);
        }
    }

    public static String getSlotDisplaySuffix(EnumAttachmentType type) {
        return new StringTextComponent(" (" + type.getDisplayName().func_150254_d() + ")").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_GRAY)).func_150254_d();
    }

    public static enum EnumReloadType {
        MAGAZINE(0),
        BOLT(1);

        public static final EnumReloadType[] VALUES;
        public final int index;

        private EnumReloadType(int index) {
            this.index = index;
        }

        public static EnumReloadType get(int index) {
            return VALUES[index];
        }

        static {
            VALUES = EnumReloadType.values();
        }
    }

    public static enum EnumFireMode {
        BOLT_ACTION("bolt_action"),
        SEMI_AUTO("semi_auto"),
        FULL_AUTO("full_auto");

        public final String key;

        private EnumFireMode(String key) {
            this.key = key;
        }
    }
}

