/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.HT.config;

import com.mactso.HT.config.MyConfig;
import java.util.Hashtable;
import java.util.StringTokenizer;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;

public class TrailBlockManager {
    public static Hashtable<String, TrailBlockItem> trailBlockHashtable = new Hashtable();
    private static String defaultTrailBlockString;
    private static String defaultTrailBlockKey;

    public static TrailBlockItem getTrailBlockInfo(String key) {
        String iKey = key;
        if (trailBlockHashtable.isEmpty()) {
            TrailBlockManager.trailBlockInit();
        }
        TrailBlockItem t = trailBlockHashtable.get(iKey);
        return t;
    }

    public static String[] getTrailHashAsStringArray() {
        String[] returnStringArray = new String[trailBlockHashtable.size()];
        int i = 0;
        for (String key : trailBlockHashtable.keySet()) {
            int speed = TrailBlockManager.trailBlockHashtable.get((Object)key).trailBlockSpeed;
            String tempString = key + "," + speed;
            returnStringArray[i++] = tempString;
        }
        return returnStringArray;
    }

    public static void trailBlockInit() {
        trailBlockHashtable.clear();
        for (int i = 0; i < MyConfig.defaultTrailBlocks.length; ++i) {
            try {
                String modAndBlock;
                StringTokenizer st = new StringTokenizer(MyConfig.defaultTrailBlocks[i], ",");
                String key = modAndBlock = st.nextToken();
                String speed = st.nextToken();
                int tHappyTrailSpeed = Integer.parseInt(speed.trim());
                if (tHappyTrailSpeed < -11 || tHappyTrailSpeed > 11) {
                    tHappyTrailSpeed = 2;
                }
                trailBlockHashtable.put(key, new TrailBlockItem(tHappyTrailSpeed));
                if (modAndBlock.contentEquals("hbm:default") || Block.field_149771_c.func_148741_d((Object)new ResourceLocation(modAndBlock))) continue;
                System.out.println("Happy Trails: Block: " + modAndBlock + " not in Forge Registry.  Mispelled?");
                continue;
            }
            catch (Exception e) {
                System.out.println("Happy Trails:  Bad Block Config : " + MyConfig.defaultTrailBlocks[i]);
            }
        }
    }

    static {
        defaultTrailBlockKey = defaultTrailBlockString = "hbm:default";
    }

    public static class TrailBlockItem {
        int trailBlockSpeed;

        public TrailBlockItem(int trailBlockSpeed) {
            this.trailBlockSpeed = trailBlockSpeed;
        }

        public int getTrailBlockSpeed() {
            return this.trailBlockSpeed;
        }
    }
}

