/*
 * Decompiled with CFR 0.152.
 */
package com.mactso.HT.config;

import com.mactso.HT.config.TrailBlockManager;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="ht", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static int aDebugLevel;
    public static boolean aParticlesOn;
    public static String[] defaultTrailBlocks;
    public static String defaultTrailBlocks6464;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            MyConfig.bakeConfig();
            TrailBlockManager.trailBlockInit();
        }
    }

    public static void pushDebugValue() {
        if (aDebugLevel > 0) {
            System.out.println("dbgL:" + aDebugLevel);
        }
        MyConfig.SERVER.debugLevel.set((Object)aDebugLevel);
    }

    public static void pushNewParticlesOn() {
        MyConfig.SERVER.particlesOn.set((Object)aParticlesOn);
    }

    public static void pushValues() {
        MyConfig.SERVER.defaultTrailBlocksActual.set((Object)TrailBlockManager.getTrailHashAsString());
    }

    public static void bakeConfig() {
        aDebugLevel = (Integer)MyConfig.SERVER.debugLevel.get();
        defaultTrailBlocks6464 = (String)MyConfig.SERVER.defaultTrailBlocksActual.get();
        if (aDebugLevel > 0) {
            System.out.println("Happy Trails Debug: " + aDebugLevel);
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.IntValue debugLevel;
        public final ForgeConfigSpec.BooleanValue particlesOn;
        public final ForgeConfigSpec.ConfigValue<String> defaultTrailBlocksActual;
        public final String defaultTrailBlocks6464 = "minecraft:grass_path,2;\n\rminecraft:sand,-1;\n\rminecraft:stone_brick_slab,3\n\r;";

        public Server(ForgeConfigSpec.Builder builder) {
            builder.push("Happy Trail Control Values");
            this.debugLevel = builder.comment("Debug Level: 0 = Off, 1 = Log, 2 = Chat+Log").translation("ht.config.debugLevel").defineInRange("debugLevel", () -> 0, 0, 2);
            this.particlesOn = builder.comment("Particles On?: [true] / false").translation("ht.config.particlesOn").define("particlesOn", () -> true);
            builder.pop();
            builder.push("Trail Values 6464");
            this.defaultTrailBlocksActual = builder.comment("Trail Block String 6464").translation("ht.configdefaultTrailBlocksActual").define("defaultTrailBlocksActual", (Object)"minecraft:grass_path,2;\n\rminecraft:sand,-1;\n\rminecraft:stone_brick_slab,3\n\r;");
            builder.pop();
        }
    }
}

