/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.hardcorerevival.network;

import java.util.List;
import java.util.function.Supplier;
import net.blay09.mods.hardcorerevival.HardcoreRevivalConfig;
import net.blay09.mods.hardcorerevival.handler.RescueHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRevival {
    private final boolean active;

    public MessageRevival(boolean active) {
        this.active = active;
    }

    public static void encode(MessageRevival message, PacketBuffer buf) {
        buf.writeBoolean(message.active);
    }

    public static MessageRevival decode(PacketBuffer buf) {
        boolean active = buf.readBoolean();
        return new MessageRevival(active);
    }

    public static void handle(MessageRevival message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null || player.func_110143_aJ() <= 0.0f || player.func_175149_v()) {
                return;
            }
            if (message.active) {
                double range = (Double)HardcoreRevivalConfig.SERVER.maxRescueDist.get();
                List candidates = player.field_70170_p.func_175647_a(PlayerEntity.class, player.func_174813_aQ().func_186662_g(range), p -> p != null && p.func_110143_aJ() <= 0.0f);
                float minDist = Float.MAX_VALUE;
                PlayerEntity target = null;
                for (PlayerEntity candidate : candidates) {
                    float dist = candidate.func_70032_d((Entity)player);
                    if (!(dist < minDist)) continue;
                    target = candidate;
                    minDist = dist;
                }
                if (target != null) {
                    RescueHandler.startRescue((PlayerEntity)player, target);
                }
            } else {
                RescueHandler.abortRescue((PlayerEntity)player);
            }
        });
        context.setPacketHandled(true);
    }
}

