/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thesuperheroesuniverse.world;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.thesuperheroesuniverse.ElementsHeroesUniverse;
import net.mcreator.thesuperheroesuniverse.block.BlockMarsRock;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockSand;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsHeroesUniverse.ModElement.Tag
public class WorldMarsDimension
extends ElementsHeroesUniverse.ModElement {
    public static int DIMID = 3;
    public static final boolean NETHER_TYPE = false;
    public static DimensionType dtype;

    public WorldMarsDimension(ElementsHeroesUniverse instance) {
        super(instance, 147);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (DimensionManager.isDimensionRegistered((int)DIMID)) {
            DIMID = DimensionManager.getNextFreeDimId();
            System.err.println("Dimension ID for dimension marsdimension is already registered. Falling back to ID: " + DIMID);
        }
        dtype = DimensionType.register((String)"marsdimension", (String)"_marsdimension", (int)DIMID, WorldProviderMod.class, (boolean)true);
        DimensionManager.registerDimension((int)DIMID, (DimensionType)dtype);
    }

    public static class BiomeProviderCustom
    extends BiomeProvider {
        private GenLayer genBiomes;
        private GenLayer biomeIndexLayer;
        private BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);

        public BiomeProviderCustom() {
        }

        public BiomeProviderCustom(long seed) {
            GenLayer[] agenlayer = this.makeTheWorld(seed);
            this.genBiomes = agenlayer[0];
            this.biomeIndexLayer = agenlayer[1];
        }

        private GenLayer[] makeTheWorld(long seed) {
            GenLayerBiomesCustom biomes = new GenLayerBiomesCustom(1L);
            biomes = new GenLayerZoom(1000L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1001L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1002L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1003L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1004L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1005L, (GenLayer)biomes);
            GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)biomes);
            biomes.func_75905_a(seed);
            genlayervoronoizoom.func_75905_a(seed);
            return new GenLayer[]{biomes, genlayervoronoizoom};
        }

        public BiomeProviderCustom(World world) {
            this(world.func_72905_C());
        }

        public void func_76938_b() {
            this.biomeCache.func_76838_a();
        }

        public Biome func_180631_a(BlockPos pos) {
            return this.func_180300_a(pos, null);
        }

        public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
            return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
        }

        public Biome[] func_76933_b(Biome[] oldBiomeList, int x, int z, int width, int depth) {
            return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
        }

        public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
            IntCache.func_76446_a();
            if (biomes == null || biomes.length < width * height) {
                biomes = new Biome[width * height];
            }
            int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
            try {
                for (int i = 0; i < width * height; ++i) {
                    biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
                }
                return biomes;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
                crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }

        public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
            IntCache.func_76446_a();
            if (listToReuse == null || listToReuse.length < width * length) {
                listToReuse = new Biome[width * length];
            }
            if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                Biome[] abiome = this.biomeCache.func_76839_e(x, z);
                System.arraycopy(abiome, 0, listToReuse, 0, width * length);
                return listToReuse;
            }
            int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
            for (int i = 0; i < width * length; ++i) {
                listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return listToReuse;
        }

        public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
            IntCache.func_76446_a();
            int i = x - radius >> 2;
            int j = z - radius >> 2;
            int k = x + radius >> 2;
            int l = z + radius >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
            try {
                for (int k1 = 0; k1 < i1 * j1; ++k1) {
                    Biome biome = Biome.func_150568_d((int)aint[k1]);
                    if (allowed.contains(biome)) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
                crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("radius", (Object)radius);
                crashreportcategory.func_71507_a("allowed", allowed);
                throw new ReportedException(crashreport);
            }
        }

        @Nullable
        public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
            IntCache.func_76446_a();
            int i = x - range >> 2;
            int j = z - range >> 2;
            int k = x + range >> 2;
            int l = z + range >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
            BlockPos blockpos = null;
            int k1 = 0;
            for (int l1 = 0; l1 < i1 * j1; ++l1) {
                int i2 = i + l1 % i1 << 2;
                int j2 = j + l1 / i1 << 2;
                Biome biome = Biome.func_150568_d((int)aint[l1]);
                if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
                blockpos = new BlockPos(i2, 0, j2);
                ++k1;
            }
            return blockpos;
        }
    }

    public static class GenLayerBiomesCustom
    extends GenLayer {
        private Biome[] allowedBiomes = new Biome[]{(Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("thesuperheroesuniverse:mars"))};

        public GenLayerBiomesCustom(long seed) {
            super(seed);
        }

        public int[] func_75904_a(int x, int z, int width, int depth) {
            int[] dest = IntCache.func_76445_a((int)(width * depth));
            for (int dz = 0; dz < depth; ++dz) {
                for (int dx = 0; dx < width; ++dx) {
                    this.func_75903_a(dx + x, dz + z);
                    dest[dx + dz * width] = Biome.func_185362_a((Biome)this.allowedBiomes[this.func_75902_a(this.allowedBiomes.length)]);
                }
            }
            return dest;
        }
    }

    public static class ChunkProviderModded
    implements IChunkGenerator {
        private static final IBlockState STONE = Blocks.field_150348_b.func_176203_a(0);
        private static final IBlockState STONE2 = BlockMarsRock.block.func_176223_P();
        private static final IBlockState FLUID = Blocks.field_150403_cj.func_176223_P();
        private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
        private static final IBlockState BEDROCK = Blocks.field_150357_h.func_176223_P();
        private static final int SEALEVEL = 63;
        private final Random random;
        private final NoiseGeneratorOctaves perlin1;
        private final NoiseGeneratorOctaves perlin2;
        private final NoiseGeneratorOctaves perlin;
        private final NoiseGeneratorPerlin height;
        private final NoiseGeneratorOctaves depth;
        private final World world;
        private final WorldType terrainType;
        private final MapGenBase caveGenerator;
        private final MapGenBase ravineGenerator;
        private Biome[] biomesForGeneration;
        private double[] heightMap;
        private double[] depthbuff = new double[256];
        private double[] noiseRegMain;
        private double[] limitRegMin;
        private double[] limitRegMax;
        private double[] depthReg;
        private float[] biomeWeights;

        public ChunkProviderModded(World worldIn, long seed) {
            worldIn.func_181544_b(63);
            this.caveGenerator = new MapGenCaves(){

                protected boolean func_175793_a(IBlockState a, IBlockState b) {
                    if (a.func_177230_c() == STONE.func_177230_c()) {
                        return true;
                    }
                    return super.func_175793_a(a, b);
                }
            };
            this.ravineGenerator = new MapGenRavine(){

                protected void digBlock(ChunkPrimer data, int x, int y, int z, int chunkX, int chunkZ, boolean foundTop) {
                    Biome biome = this.field_75039_c.func_180494_b(new BlockPos(x + chunkX * 16, 0, z + chunkZ * 16));
                    IBlockState state = data.func_177856_a(x, y, z);
                    if (state.func_177230_c() == STONE.func_177230_c() || state.func_177230_c() == biome.field_76752_A.func_177230_c() || state.func_177230_c() == biome.field_76753_B.func_177230_c()) {
                        if (y - 1 < 10) {
                            data.func_177855_a(x, y, z, field_186135_a);
                        } else {
                            data.func_177855_a(x, y, z, field_186136_b);
                            if (foundTop && data.func_177856_a(x, y - 1, z).func_177230_c() == biome.field_76753_B.func_177230_c()) {
                                data.func_177855_a(x, y - 1, z, biome.field_76752_A.func_177230_c().func_176223_P());
                            }
                        }
                    }
                }
            };
            this.world = worldIn;
            this.terrainType = worldIn.func_72912_H().func_76067_t();
            this.random = new Random(seed);
            this.perlin1 = new NoiseGeneratorOctaves(this.random, 16);
            this.perlin2 = new NoiseGeneratorOctaves(this.random, 16);
            this.perlin = new NoiseGeneratorOctaves(this.random, 8);
            this.height = new NoiseGeneratorPerlin(this.random, 4);
            this.depth = new NoiseGeneratorOctaves(this.random, 16);
            this.heightMap = new double[825];
            this.biomeWeights = new float[25];
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    this.biomeWeights[i + 2 + (j + 2) * 5] = 10.0f / MathHelper.func_76129_c((float)((float)(i * i + j * j) + 0.2f));
                }
            }
        }

        public Chunk func_185932_a(int x, int z) {
            this.random.setSeed((long)x * 535358712L + (long)z * 347539041L);
            ChunkPrimer chunkprimer = new ChunkPrimer();
            this.setBlocksInChunk(x, z, chunkprimer);
            this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 16, z * 16, 16, 16);
            this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
            this.caveGenerator.func_186125_a(this.world, x, z, chunkprimer);
            this.ravineGenerator.func_186125_a(this.world, x, z, chunkprimer);
            Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
            byte[] abyte = chunk.func_76605_m();
            for (int i = 0; i < abyte.length; ++i) {
                abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
            }
            chunk.func_76603_b();
            return chunk;
        }

        public void func_185931_b(int x, int z) {
            BlockFalling.field_149832_M = true;
            int i = x * 16;
            int j = z * 16;
            BlockPos blockpos = new BlockPos(i, 0, j);
            Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
            this.random.setSeed(this.world.func_72905_C());
            long k = this.random.nextLong() / 2L * 2L + 1L;
            long l = this.random.nextLong() / 2L * 2L + 1L;
            this.random.setSeed((long)x * k + (long)z * l ^ this.world.func_72905_C());
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
            if (this.random.nextInt(4) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
                int i1 = this.random.nextInt(16) + 8;
                int j1 = this.random.nextInt(256);
                int k1 = this.random.nextInt(16) + 8;
                new WorldGenLakes(FLUID.func_177230_c()).func_180709_b(this.world, this.random, blockpos.func_177982_a(i1, j1, k1));
            }
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.random, blockpos));
            biome.func_180624_a(this.world, this.random, new BlockPos(i, 0, j));
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.random, blockpos));
            if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
                WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.random);
            }
            ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
            BlockFalling.field_149832_M = false;
        }

        public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
            return this.world.func_180494_b(pos).func_76747_a(creatureType);
        }

        public void func_180514_a(Chunk chunkIn, int x, int z) {
        }

        public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
            return false;
        }

        public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
            return null;
        }

        public boolean func_185933_a(Chunk chunkIn, int x, int z) {
            return false;
        }

        public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
            this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 4 - 2, z * 4 - 2, 10, 10);
            this.generateHeightmap(x * 4, 0, z * 4);
            for (int i = 0; i < 4; ++i) {
                int j = i * 5;
                int k = (i + 1) * 5;
                for (int l = 0; l < 4; ++l) {
                    int i1 = (j + l) * 33;
                    int j1 = (j + l + 1) * 33;
                    int k1 = (k + l) * 33;
                    int l1 = (k + l + 1) * 33;
                    for (int i2 = 0; i2 < 32; ++i2) {
                        double d0 = 0.125;
                        double d1 = this.heightMap[i1 + i2];
                        double d2 = this.heightMap[j1 + i2];
                        double d3 = this.heightMap[k1 + i2];
                        double d4 = this.heightMap[l1 + i2];
                        double d5 = (this.heightMap[i1 + i2 + 1] - d1) * 0.125;
                        double d6 = (this.heightMap[j1 + i2 + 1] - d2) * 0.125;
                        double d7 = (this.heightMap[k1 + i2 + 1] - d3) * 0.125;
                        double d8 = (this.heightMap[l1 + i2 + 1] - d4) * 0.125;
                        for (int j2 = 0; j2 < 8; ++j2) {
                            double d9 = 0.25;
                            double d10 = d1;
                            double d11 = d2;
                            double d12 = (d3 - d1) * 0.25;
                            double d13 = (d4 - d2) * 0.25;
                            for (int k2 = 0; k2 < 4; ++k2) {
                                double d14 = 0.25;
                                double d16 = (d11 - d10) * 0.25;
                                double lvt_45_1_ = d10 - d16;
                                for (int l2 = 0; l2 < 4; ++l2) {
                                    double d;
                                    lvt_45_1_ += d16;
                                    if (d > 0.0) {
                                        primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, STONE);
                                        continue;
                                    }
                                    if (i2 * 8 + j2 >= 63) continue;
                                    primer.func_177855_a(i * 4 + k2, i2 * 8 + j2, l * 4 + l2, FLUID);
                                }
                                d10 += d12;
                                d11 += d13;
                            }
                            d1 += d5;
                            d2 += d6;
                            d3 += d7;
                            d4 += d8;
                        }
                    }
                }
            }
        }

        private void generateHeightmap(int p_185978_1_, int p_185978_2_, int p_185978_3_) {
            this.depthReg = this.depth.func_76305_a(this.depthReg, p_185978_1_, p_185978_3_, 5, 5, 200.0, 200.0, 0.5);
            float f = 684.412f;
            float f1 = 684.412f;
            this.noiseRegMain = this.perlin.func_76304_a(this.noiseRegMain, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)(f / 80.0f), (double)(f1 / 160.0f), (double)(f / 80.0f));
            this.limitRegMin = this.perlin1.func_76304_a(this.limitRegMin, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)f, (double)f1, (double)f);
            this.limitRegMax = this.perlin2.func_76304_a(this.limitRegMax, p_185978_1_, p_185978_2_, p_185978_3_, 5, 33, 5, (double)f, (double)f1, (double)f);
            int i = 0;
            int j = 0;
            for (int k = 0; k < 5; ++k) {
                for (int l = 0; l < 5; ++l) {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    int i1 = 2;
                    Biome biome = this.biomesForGeneration[k + 2 + (l + 2) * 10];
                    for (int j1 = -2; j1 <= 2; ++j1) {
                        for (int k1 = -2; k1 <= 2; ++k1) {
                            Biome biome1 = this.biomesForGeneration[k + j1 + 2 + (l + k1 + 2) * 10];
                            float f5 = 0.0f + biome1.func_185355_j() * 1.0f;
                            float f6 = 0.0f + biome1.func_185360_m() * 1.0f;
                            if (this.terrainType == WorldType.field_151360_e && f5 > 0.0f) {
                                f5 = 1.0f + f5 * 2.0f;
                                f6 = 1.0f + f6 * 4.0f;
                            }
                            float f7 = this.biomeWeights[j1 + 2 + (k1 + 2) * 5] / (f5 + 2.0f);
                            if (biome1.func_185355_j() > biome.func_185355_j()) {
                                f7 /= 2.0f;
                            }
                            f2 += f6 * f7;
                            f3 += f5 * f7;
                            f4 += f7;
                        }
                    }
                    f2 /= f4;
                    f3 /= f4;
                    f2 = f2 * 0.9f + 0.1f;
                    f3 = (f3 * 4.0f - 1.0f) / 8.0f;
                    double d7 = this.depthReg[j] / 8000.0;
                    if (d7 < 0.0) {
                        d7 = -d7 * 0.3;
                    }
                    if ((d7 = d7 * 3.0 - 2.0) < 0.0) {
                        if ((d7 /= 2.0) < -1.0) {
                            d7 = -1.0;
                        }
                        d7 /= 1.4;
                        d7 /= 2.0;
                    } else {
                        if (d7 > 1.0) {
                            d7 = 1.0;
                        }
                        d7 /= 8.0;
                    }
                    ++j;
                    double d8 = f3;
                    double d9 = f2;
                    d8 += d7 * 0.2;
                    d8 = d8 * 8.5 / 8.0;
                    double d0 = 8.5 + d8 * 4.0;
                    for (int l1 = 0; l1 < 33; ++l1) {
                        double d1 = ((double)l1 - d0) * 12.0 * 128.0 / 256.0 / d9;
                        if (d1 < 0.0) {
                            d1 *= 4.0;
                        }
                        double d2 = this.limitRegMin[i] / 512.0;
                        double d3 = this.limitRegMax[i] / 512.0;
                        double d4 = (this.noiseRegMain[i] / 10.0 + 1.0) / 2.0;
                        double d5 = MathHelper.func_151238_b((double)d2, (double)d3, (double)d4) - d1;
                        if (l1 > 29) {
                            double d6 = (float)(l1 - 29) / 3.0f;
                            d5 = d5 * (1.0 - d6) + -10.0 * d6;
                        }
                        this.heightMap[i] = d5;
                        ++i;
                    }
                }
            }
        }

        private void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
            this.depthbuff = this.height.func_151599_a(this.depthbuff, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.generateBiomeTerrain(this.world, this.random, primer, x * 16 + i, z * 16 + j, this.depthbuff[j + i * 16], biomesIn[j + i * 16]);
                }
            }
        }

        public final void generateBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal, Biome biome) {
            int i = 63;
            IBlockState iblockstate = biome.field_76752_A;
            IBlockState iblockstate1 = biome.field_76753_B;
            int j = -1;
            int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() * 0.25);
            int l = x & 0xF;
            int i1 = z & 0xF;
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int j1 = 255; j1 >= 0; --j1) {
                if (j1 <= rand.nextInt(5)) {
                    chunkPrimerIn.func_177855_a(i1, j1, l, BEDROCK);
                    continue;
                }
                IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
                if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                    j = -1;
                    continue;
                }
                if (iblockstate2.func_177230_c() != STONE.func_177230_c()) continue;
                if (j == -1) {
                    if (k <= 0) {
                        iblockstate = AIR;
                        iblockstate1 = STONE;
                    } else if (j1 >= i - 4 && j1 <= i + 1) {
                        iblockstate = biome.field_76752_A;
                        iblockstate1 = biome.field_76753_B;
                    }
                    if (j1 < i && (iblockstate == null || iblockstate.func_185904_a() == Material.field_151579_a)) {
                        iblockstate = biome.func_180626_a((BlockPos)blockpos$mutableblockpos.func_181079_c(x, j1, z)) < 0.15f ? FLUID : FLUID;
                    }
                    j = k;
                    if (j1 >= i - 1) {
                        chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                        continue;
                    }
                    if (j1 < i - 7 - k) {
                        iblockstate = AIR;
                        iblockstate1 = STONE;
                        chunkPrimerIn.func_177855_a(i1, j1, l, STONE2);
                        continue;
                    }
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                    continue;
                }
                if (j <= 0) continue;
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                if (--j != 0 || iblockstate1.func_177230_c() != Blocks.field_150354_m || k <= 1) continue;
                j = rand.nextInt(4) + Math.max(0, j1 - 63);
                iblockstate1 = iblockstate1.func_177229_b((IProperty)BlockSand.field_176504_a) == BlockSand.EnumType.RED_SAND ? STONE2 : STONE2;
            }
        }
    }

    public static class WorldProviderMod
    extends WorldProvider {
        public void func_76572_b() {
            this.field_76578_c = new BiomeProviderCustom(this.field_76579_a.func_72905_C());
            this.field_76576_e = false;
            this.field_191067_f = true;
        }

        public void calculateInitialWeather() {
        }

        public void updateWeather() {
        }

        public boolean canDoLightning(Chunk chunk) {
            return false;
        }

        public boolean canDoRainSnowIce(Chunk chunk) {
            return false;
        }

        public DimensionType func_186058_p() {
            return dtype;
        }

        @SideOnly(value=Side.CLIENT)
        public Vec3d func_76562_b(float par1, float par2) {
            return new Vec3d(1.0, 0.545098039216, 0.239215686275);
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderModded(this.field_76579_a, this.field_76579_a.func_72905_C() - (long)DIMID);
        }

        public boolean func_76569_d() {
            return false;
        }

        public boolean func_76567_e() {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76568_b(int par1, int par2) {
            return false;
        }

        public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
            return WorldProvider.WorldSleepResult.ALLOW;
        }

        protected void func_76556_a() {
            float f = 0.5f;
            for (int i = 0; i <= 15; ++i) {
                float f1 = 1.0f - (float)i / 15.0f;
                this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            }
        }

        public boolean func_177500_n() {
            return false;
        }
    }
}

