/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thesuperheroesuniverse.world;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.mcreator.thesuperheroesuniverse.ElementsHeroesUniverse;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerVoronoiZoom;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.ChunkGeneratorEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ElementsHeroesUniverse.ModElement.Tag
public class WorldQuantumRealmDimension
extends ElementsHeroesUniverse.ModElement {
    public static int DIMID = 5;
    public static final boolean NETHER_TYPE = false;
    public static DimensionType dtype;

    public WorldQuantumRealmDimension(ElementsHeroesUniverse instance) {
        super(instance, 51);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        if (DimensionManager.isDimensionRegistered((int)DIMID)) {
            DIMID = DimensionManager.getNextFreeDimId();
            System.err.println("Dimension ID for dimension quantumrealmdimension is already registered. Falling back to ID: " + DIMID);
        }
        dtype = DimensionType.register((String)"quantumrealmdimension", (String)"_quantumrealmdimension", (int)DIMID, WorldProviderMod.class, (boolean)true);
        DimensionManager.registerDimension((int)DIMID, (DimensionType)dtype);
    }

    public static class BiomeProviderCustom
    extends BiomeProvider {
        private GenLayer genBiomes;
        private GenLayer biomeIndexLayer;
        private BiomeCache biomeCache = new BiomeCache((BiomeProvider)this);

        public BiomeProviderCustom() {
        }

        public BiomeProviderCustom(long seed) {
            GenLayer[] agenlayer = this.makeTheWorld(seed);
            this.genBiomes = agenlayer[0];
            this.biomeIndexLayer = agenlayer[1];
        }

        private GenLayer[] makeTheWorld(long seed) {
            GenLayerBiomesCustom biomes = new GenLayerBiomesCustom(1L);
            biomes = new GenLayerZoom(1000L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1001L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1002L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1003L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1004L, (GenLayer)biomes);
            biomes = new GenLayerZoom(1005L, (GenLayer)biomes);
            GenLayerVoronoiZoom genlayervoronoizoom = new GenLayerVoronoiZoom(10L, (GenLayer)biomes);
            biomes.func_75905_a(seed);
            genlayervoronoizoom.func_75905_a(seed);
            return new GenLayer[]{biomes, genlayervoronoizoom};
        }

        public BiomeProviderCustom(World world) {
            this(world.func_72905_C());
        }

        public void func_76938_b() {
            this.biomeCache.func_76838_a();
        }

        public Biome func_180631_a(BlockPos pos) {
            return this.func_180300_a(pos, null);
        }

        public Biome func_180300_a(BlockPos pos, Biome defaultBiome) {
            return this.biomeCache.func_180284_a(pos.func_177958_n(), pos.func_177952_p(), defaultBiome);
        }

        public Biome[] func_76933_b(Biome[] oldBiomeList, int x, int z, int width, int depth) {
            return this.func_76931_a(oldBiomeList, x, z, width, depth, true);
        }

        public Biome[] func_76937_a(Biome[] biomes, int x, int z, int width, int height) {
            IntCache.func_76446_a();
            if (biomes == null || biomes.length < width * height) {
                biomes = new Biome[width * height];
            }
            int[] aint = this.genBiomes.func_75904_a(x, z, width, height);
            try {
                for (int i = 0; i < width * height; ++i) {
                    biomes[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
                }
                return biomes;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
                crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)width);
                crashreportcategory.func_71507_a("h", (Object)height);
                throw new ReportedException(crashreport);
            }
        }

        public Biome[] func_76931_a(@Nullable Biome[] listToReuse, int x, int z, int width, int length, boolean cacheFlag) {
            IntCache.func_76446_a();
            if (listToReuse == null || listToReuse.length < width * length) {
                listToReuse = new Biome[width * length];
            }
            if (cacheFlag && width == 16 && length == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
                Biome[] abiome = this.biomeCache.func_76839_e(x, z);
                System.arraycopy(abiome, 0, listToReuse, 0, width * length);
                return listToReuse;
            }
            int[] aint = this.biomeIndexLayer.func_75904_a(x, z, width, length);
            for (int i = 0; i < width * length; ++i) {
                listToReuse[i] = Biome.func_180276_a((int)aint[i], (Biome)Biomes.field_180279_ad);
            }
            return listToReuse;
        }

        public boolean func_76940_a(int x, int z, int radius, List<Biome> allowed) {
            IntCache.func_76446_a();
            int i = x - radius >> 2;
            int j = z - radius >> 2;
            int k = x + radius >> 2;
            int l = z + radius >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
            try {
                for (int k1 = 0; k1 < i1 * j1; ++k1) {
                    Biome biome = Biome.func_150568_d((int)aint[k1]);
                    if (allowed.contains(biome)) continue;
                    return false;
                }
                return true;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
                crashreportcategory.func_71507_a("Layer", (Object)this.genBiomes.toString());
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("radius", (Object)radius);
                crashreportcategory.func_71507_a("allowed", allowed);
                throw new ReportedException(crashreport);
            }
        }

        @Nullable
        public BlockPos func_180630_a(int x, int z, int range, List<Biome> biomes, Random random) {
            IntCache.func_76446_a();
            int i = x - range >> 2;
            int j = z - range >> 2;
            int k = x + range >> 2;
            int l = z + range >> 2;
            int i1 = k - i + 1;
            int j1 = l - j + 1;
            int[] aint = this.genBiomes.func_75904_a(i, j, i1, j1);
            BlockPos blockpos = null;
            int k1 = 0;
            for (int l1 = 0; l1 < i1 * j1; ++l1) {
                int i2 = i + l1 % i1 << 2;
                int j2 = j + l1 / i1 << 2;
                Biome biome = Biome.func_150568_d((int)aint[l1]);
                if (!biomes.contains(biome) || blockpos != null && random.nextInt(k1 + 1) != 0) continue;
                blockpos = new BlockPos(i2, 0, j2);
                ++k1;
            }
            return blockpos;
        }
    }

    public static class GenLayerBiomesCustom
    extends GenLayer {
        private Biome[] allowedBiomes = new Biome[]{(Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("thesuperheroesuniverse:quantumrealm"))};

        public GenLayerBiomesCustom(long seed) {
            super(seed);
        }

        public int[] func_75904_a(int x, int z, int width, int depth) {
            int[] dest = IntCache.func_76445_a((int)(width * depth));
            for (int dz = 0; dz < depth; ++dz) {
                for (int dx = 0; dx < width; ++dx) {
                    this.func_75903_a(dx + x, dz + z);
                    dest[dx + dz * width] = Biome.func_185362_a((Biome)this.allowedBiomes[this.func_75902_a(this.allowedBiomes.length)]);
                }
            }
            return dest;
        }
    }

    public static class ChunkProviderModded
    implements IChunkGenerator {
        private static final IBlockState STONE = Blocks.field_150350_a.func_176223_P();
        private static final IBlockState AIR = Blocks.field_150350_a.func_176223_P();
        private static final int SEALEVEL = 63;
        private final World world;
        private Random random;
        private final NoiseGeneratorSimplex islandNoise;
        private final NoiseGeneratorOctaves perlinnoise1;
        private final NoiseGeneratorOctaves perlinnoise2;
        private final NoiseGeneratorOctaves perlinnoise3;
        private final NoiseGeneratorPerlin height;
        private Biome[] biomesForGeneration;
        private double[] buffer;
        private double[] pnr;
        private double[] ar;
        private double[] br;
        private double[] depthbuff = new double[256];
        private WorldGenerator islandGen;

        public ChunkProviderModded(World worldIn, long seed) {
            worldIn.func_181544_b(63);
            this.world = worldIn;
            this.random = new Random(seed);
            this.perlinnoise1 = new NoiseGeneratorOctaves(this.random, 16);
            this.perlinnoise2 = new NoiseGeneratorOctaves(this.random, 16);
            this.perlinnoise3 = new NoiseGeneratorOctaves(this.random, 8);
            this.height = new NoiseGeneratorPerlin(this.random, 4);
            this.islandNoise = new NoiseGeneratorSimplex(this.random);
            this.islandGen = new WorldGenerator(){

                public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
                    float f = rand.nextInt(4) + 5;
                    int i = 0;
                    while (f > 1.5f) {
                        for (int j = MathHelper.func_76141_d((float)(-f)); j <= MathHelper.func_76123_f((float)f); ++j) {
                            for (int k = MathHelper.func_76141_d((float)(-f)); k <= MathHelper.func_76123_f((float)f); ++k) {
                                if (!((float)(j * j + k * k) <= (f + 1.0f) * (f + 1.0f))) continue;
                                this.func_175903_a(worldIn, position.func_177982_a(j, i, k), STONE);
                            }
                        }
                        f = (float)((double)f - ((double)rand.nextInt(2) + 0.5));
                        --i;
                    }
                    return true;
                }
            };
        }

        public Chunk func_185932_a(int x, int z) {
            this.random.setSeed((long)x * 535358712L + (long)z * 347539041L);
            ChunkPrimer chunkprimer = new ChunkPrimer();
            this.setBlocksInChunk(x, z, chunkprimer);
            this.biomesForGeneration = this.world.func_72959_q().func_76937_a(this.biomesForGeneration, x * 16, z * 16, 16, 16);
            this.replaceBiomeBlocks(x, z, chunkprimer, this.biomesForGeneration);
            Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
            byte[] abyte = chunk.func_76605_m();
            for (int i = 0; i < abyte.length; ++i) {
                abyte[i] = (byte)Biome.func_185362_a((Biome)this.biomesForGeneration[i]);
            }
            chunk.func_76603_b();
            return chunk;
        }

        public void func_185931_b(int x, int z) {
            BlockFalling.field_149832_M = true;
            ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
            int i = x * 16;
            int j = z * 16;
            BlockPos blockpos = new BlockPos(i, 0, j);
            float f = this.getIslandHeightValue(x, z, 1, 1);
            if (f < -10.0f && this.random.nextInt(6) == 0) {
                this.islandGen.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, 55 + this.random.nextInt(16), this.random.nextInt(16) + 8));
                if (this.random.nextInt(4) == 0) {
                    this.islandGen.func_180709_b(this.world, this.random, blockpos.func_177982_a(this.random.nextInt(16) + 8, 55 + this.random.nextInt(16), this.random.nextInt(16) + 8));
                }
            }
            Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Pre(this.world, this.random, blockpos));
            biome.func_180624_a(this.world, this.random, new BlockPos(i, 0, j));
            MinecraftForge.EVENT_BUS.post((Event)new DecorateBiomeEvent.Post(this.world, this.random, blockpos));
            if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
                WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(i + 8), (int)(j + 8), (int)16, (int)16, (Random)this.random);
            }
            ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)false);
            BlockFalling.field_149832_M = false;
        }

        public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
            return this.world.func_180494_b(pos).func_76747_a(creatureType);
        }

        public void func_180514_a(Chunk chunkIn, int x, int z) {
        }

        public boolean func_193414_a(World worldIn, String structureName, BlockPos pos) {
            return false;
        }

        public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
            return null;
        }

        public boolean func_185933_a(Chunk chunkIn, int x, int z) {
            return false;
        }

        private double[] getHeights(double[] p_185963_1_, int p_185963_2_, int p_185963_3_, int p_185963_4_, int p_185963_5_, int p_185963_6_, int p_185963_7_) {
            ChunkGeneratorEvent.InitNoiseField event = new ChunkGeneratorEvent.InitNoiseField((IChunkGenerator)this, p_185963_1_, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.getResult() == Event.Result.DENY) {
                return event.getNoisefield();
            }
            if (p_185963_1_ == null) {
                p_185963_1_ = new double[p_185963_5_ * p_185963_6_ * p_185963_7_];
            }
            double d0 = 684.412;
            double d1 = 684.412;
            this.pnr = this.perlinnoise3.func_76304_a(this.pnr, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, (d0 *= 2.0) / 80.0, 4.277575000000001, d0 / 80.0);
            this.ar = this.perlinnoise1.func_76304_a(this.ar, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
            this.br = this.perlinnoise2.func_76304_a(this.br, p_185963_2_, p_185963_3_, p_185963_4_, p_185963_5_, p_185963_6_, p_185963_7_, d0, 684.412, d0);
            int i = p_185963_2_ / 2;
            int j = p_185963_4_ / 2;
            int k = 0;
            for (int l = 0; l < p_185963_5_; ++l) {
                for (int i1 = 0; i1 < p_185963_7_; ++i1) {
                    float f = this.getIslandHeightValue(i, j, l, i1);
                    for (int j1 = 0; j1 < p_185963_6_; ++j1) {
                        double d2 = this.ar[k] / 512.0;
                        double d3 = this.br[k] / 512.0;
                        double d5 = (this.pnr[k] / 10.0 + 1.0) / 2.0;
                        double d4 = d5 < 0.0 ? d2 : (d5 > 1.0 ? d3 : d2 + (d3 - d2) * d5);
                        d4 -= 8.0;
                        d4 += (double)f;
                        int k1 = 2;
                        if (j1 > p_185963_6_ / 2 - k1) {
                            double d6 = (float)(j1 - (p_185963_6_ / 2 - k1)) / 64.0f;
                            d6 = MathHelper.func_151237_a((double)d6, (double)0.0, (double)1.0);
                            d4 = d4 * (1.0 - d6) + -3000.0 * d6;
                        }
                        if (j1 < (k1 = 8)) {
                            double d7 = (float)(k1 - j1) / ((float)k1 - 1.0f);
                            d4 = d4 * (1.0 - d7) + -30.0 * d7;
                        }
                        p_185963_1_[k] = d4;
                        ++k;
                    }
                }
            }
            return p_185963_1_;
        }

        private float getIslandHeightValue(int p_185960_1_, int p_185960_2_, int p_185960_3_, int p_185960_4_) {
            float f = p_185960_1_ * 2 + p_185960_3_;
            float f1 = p_185960_2_ * 2 + p_185960_4_;
            float f2 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * 8.0f;
            if (f2 > 80.0f) {
                f2 = 80.0f;
            }
            if (f2 < -100.0f) {
                f2 = -100.0f;
            }
            for (int i = -12; i <= 12; ++i) {
                for (int j = -12; j <= 12; ++j) {
                    long k = p_185960_1_ + i;
                    long l = p_185960_2_ + j;
                    if (k * k + l * l <= 4096L || !(this.islandNoise.func_151605_a((double)k, (double)l) < (double)-0.9f)) continue;
                    float f3 = (MathHelper.func_76135_e((float)k) * 3439.0f + MathHelper.func_76135_e((float)l) * 147.0f) % 13.0f + 9.0f;
                    f = p_185960_3_ - i * 2;
                    f1 = p_185960_4_ - j * 2;
                    float f4 = 100.0f - MathHelper.func_76129_c((float)(f * f + f1 * f1)) * f3;
                    if (f4 > 80.0f) {
                        f4 = 80.0f;
                    }
                    if (f4 < -100.0f) {
                        f4 = -100.0f;
                    }
                    if (!(f4 > f2)) continue;
                    f2 = f4;
                }
            }
            return f2;
        }

        public void setBlocksInChunk(int x, int z, ChunkPrimer primer) {
            int i = 2;
            int j = 3;
            int k = 33;
            int l = 3;
            this.buffer = this.getHeights(this.buffer, x * 2, 0, z * 2, 3, 33, 3);
            for (int i1 = 0; i1 < 2; ++i1) {
                for (int j1 = 0; j1 < 2; ++j1) {
                    for (int k1 = 0; k1 < 32; ++k1) {
                        double d0 = 0.25;
                        double d1 = this.buffer[((i1 + 0) * 3 + j1 + 0) * 33 + k1 + 0];
                        double d2 = this.buffer[((i1 + 0) * 3 + j1 + 1) * 33 + k1 + 0];
                        double d3 = this.buffer[((i1 + 1) * 3 + j1 + 0) * 33 + k1 + 0];
                        double d4 = this.buffer[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 0];
                        double d5 = (this.buffer[((i1 + 0) * 3 + j1 + 0) * 33 + k1 + 1] - d1) * 0.25;
                        double d6 = (this.buffer[((i1 + 0) * 3 + j1 + 1) * 33 + k1 + 1] - d2) * 0.25;
                        double d7 = (this.buffer[((i1 + 1) * 3 + j1 + 0) * 33 + k1 + 1] - d3) * 0.25;
                        double d8 = (this.buffer[((i1 + 1) * 3 + j1 + 1) * 33 + k1 + 1] - d4) * 0.25;
                        for (int l1 = 0; l1 < 4; ++l1) {
                            double d9 = 0.125;
                            double d10 = d1;
                            double d11 = d2;
                            double d12 = (d3 - d1) * 0.125;
                            double d13 = (d4 - d2) * 0.125;
                            for (int i2 = 0; i2 < 8; ++i2) {
                                double d14 = 0.125;
                                double d15 = d10;
                                double d16 = (d11 - d10) * 0.125;
                                for (int j2 = 0; j2 < 8; ++j2) {
                                    IBlockState iblockstate = AIR;
                                    if (d15 > 0.0) {
                                        iblockstate = STONE;
                                    }
                                    int k2 = i2 + i1 * 8;
                                    int l2 = l1 + k1 * 4;
                                    int i3 = j2 + j1 * 8;
                                    primer.func_177855_a(k2, l2, i3, iblockstate);
                                    d15 += d16;
                                }
                                d10 += d12;
                                d11 += d13;
                            }
                            d1 += d5;
                            d2 += d6;
                            d3 += d7;
                            d4 += d8;
                        }
                    }
                }
            }
        }

        private void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
            this.depthbuff = this.height.func_151599_a(this.depthbuff, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    this.generateBiomeTerrain(this.world, this.random, primer, x * 16 + i, z * 16 + j, this.depthbuff[j + i * 16], biomesIn[j + i * 16]);
                }
            }
        }

        private void generateBiomeTerrain(World worldIn, Random rand, ChunkPrimer chunkPrimerIn, int x, int z, double noiseVal, Biome biome) {
            int i = 63;
            IBlockState iblockstate = biome.field_76752_A;
            IBlockState iblockstate1 = biome.field_76753_B;
            int j = -1;
            int k = (int)(noiseVal / 3.0 + 3.0 + rand.nextDouble() / 4.0);
            int l = x & 0xF;
            int i1 = z & 0xF;
            for (int j1 = 255; j1 >= 0; --j1) {
                IBlockState iblockstate2 = chunkPrimerIn.func_177856_a(i1, j1, l);
                if (iblockstate2.func_185904_a() == Material.field_151579_a) {
                    j = -1;
                    continue;
                }
                if (iblockstate2.func_177230_c() != STONE.func_177230_c()) continue;
                if (j == -1) {
                    if (k <= 0) {
                        iblockstate = AIR;
                        iblockstate1 = STONE;
                    }
                    j = k;
                    if (j1 >= i - 1) {
                        chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate);
                        continue;
                    }
                    if (j1 < i - 7 - k) {
                        iblockstate1 = STONE;
                        continue;
                    }
                    chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
                    continue;
                }
                if (j <= 0) continue;
                --j;
                chunkPrimerIn.func_177855_a(i1, j1, l, iblockstate1);
            }
        }
    }

    public static class WorldProviderMod
    extends WorldProvider {
        public void func_76572_b() {
            this.field_76578_c = new BiomeProviderCustom(this.field_76579_a.func_72905_C());
            this.field_76576_e = false;
            this.field_191067_f = true;
        }

        public void calculateInitialWeather() {
        }

        public void updateWeather() {
        }

        public boolean canDoLightning(Chunk chunk) {
            return false;
        }

        public boolean canDoRainSnowIce(Chunk chunk) {
            return false;
        }

        public DimensionType func_186058_p() {
            return dtype;
        }

        @SideOnly(value=Side.CLIENT)
        public Vec3d func_76562_b(float par1, float par2) {
            return new Vec3d(0.027450980392, 0.058823529412, 0.188235294118);
        }

        public IChunkGenerator func_186060_c() {
            return new ChunkProviderModded(this.field_76579_a, this.field_76579_a.func_72905_C() - (long)DIMID);
        }

        public boolean func_76569_d() {
            return false;
        }

        public boolean func_76567_e() {
            return false;
        }

        @SideOnly(value=Side.CLIENT)
        public boolean func_76568_b(int par1, int par2) {
            return false;
        }

        public WorldProvider.WorldSleepResult canSleepAt(EntityPlayer player, BlockPos pos) {
            return WorldProvider.WorldSleepResult.DENY;
        }

        protected void func_76556_a() {
            float f = 0.5f;
            for (int i = 0; i <= 15; ++i) {
                float f1 = 1.0f - (float)i / 15.0f;
                this.field_76573_f[i] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f) + f;
            }
        }

        public boolean func_177500_n() {
            return false;
        }
    }
}

