/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch;

import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Comparator;
import net.hypherionmc.toggletorch.ConfigManager;
import net.hypherionmc.toggletorch.gui.ConfigGui;
import net.hypherionmc.toggletorch.particles.ParticleHandler;
import net.hypherionmc.toggletorch.util.UpdateEngine;
import net.hypherionmc.toggletorch.util.handlers.EventHandlers;
import net.hypherionmc.toggletorch.util.handlers.RegistryHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hmctt")
public class HyperLighting {
    public static final Logger LOGGER = LogManager.getLogger();
    private KeyBinding toggleButton;
    private long nextKeyTriggerTime;
    public static UpdateEngine checker;
    private boolean hasCheckedUpdate = false;
    public static final ItemGroup HYPERLIGHTS;

    public HyperLighting() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        RegistryHandler.init();
        ParticleHandler.PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ConfigManager.spec);
    }

    private void setup(FMLCommonSetupEvent event) {
    }

    public void clientSetup(FMLClientSetupEvent event) {
        this.toggleButton = new KeyBinding("Hyper Lighting Config", 268, "key.categories.gameplay");
        ClientRegistry.registerKeyBinding((KeyBinding)this.toggleButton);
        checker = new UpdateEngine();
        checker.run();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.field_70170_p.field_72995_K) {
            PlayerEntity thePlayer = event.player;
            if (!this.hasCheckedUpdate && !checker.isLatestVersion() && ConfigManager.showInChat()) {
                ClickEvent versionCheckChatClickEvent = new ClickEvent(ClickEvent.Action.OPEN_URL, checker.getUpdatelink());
                Style clickableStyle = new Style().func_150241_a(versionCheckChatClickEvent);
                StringTextComponent versionWarningChatComponent = new StringTextComponent(TextFormatting.RED + "[Hyper Lighting]" + TextFormatting.RESET + " PSSSSSST!! Version " + TextFormatting.YELLOW + checker.getUpdateTitle() + TextFormatting.RESET + " is now available." + TextFormatting.BLUE + " Click me to update!");
                versionWarningChatComponent.func_150255_a(clickableStyle);
                thePlayer.func_145747_a((ITextComponent)versionWarningChatComponent);
                this.hasCheckedUpdate = true;
            } else if (!this.hasCheckedUpdate && ConfigManager.showInChat()) {
                thePlayer.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "[Hyper Lighting]" + TextFormatting.GREEN + " Mod is up to date"));
                this.hasCheckedUpdate = true;
            }
        }
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71462_r == null && this.toggleButton.func_151468_f() && System.currentTimeMillis() >= this.nextKeyTriggerTime) {
            this.nextKeyTriggerTime = System.currentTimeMillis() + 1000L;
            ConfigGui.open();
        }
    }

    static {
        HYPERLIGHTS = new ItemGroup("hyperLighting"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)RegistryHandler.LANTERN.get());
            }

            public void func_78018_a(NonNullList<ItemStack> items) {
                super.func_78018_a(items);
                ArrayList<IForgeRegistryEntry> hypitems = new ArrayList<IForgeRegistryEntry>();
                for (RegistryObject itm : RegistryHandler.ITEMS.getEntries()) {
                    hypitems.add(itm.get());
                }
                Ordering c = Ordering.explicit(hypitems).onResultOf(ItemStack::func_77973_b);
                items.sort((Comparator)c);
            }
        };
    }
}

