/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.hypherionmc.hypcore.api.Light;
import net.hypherionmc.toggletorch.HyperLighting;
import net.hypherionmc.toggletorch.util.handlers.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class DiscoLight
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    protected static final VoxelShape STANDING_AAB = Block.func_208617_a((double)5.0, (double)12.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    private static Map<BlockPos, Object> discoColors = new HashMap<BlockPos, Object>();
    private static Map<BlockPos, Integer> tickers = new HashMap<BlockPos, Integer>();

    public DiscoLight(String name) {
        super(Block.Properties.func_200945_a((Material)Material.field_151581_o));
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
        RegistryHandler.ITEMS.register(name, () -> new BlockItem((Block)this, new Item.Properties().func_200916_a(HyperLighting.HYPERLIGHTS)));
        if (ModList.get().isLoaded("hypcore")) {
            InterModComms.sendTo((String)"hypcore", (String)"addBlockProvider", () -> this);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return STANDING_AAB;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        state = (BlockState)state.func_177231_a((IProperty)POWERED);
        worldIn.func_180501_a(pos, state, 2);
        if (!((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 1.0f);
        } else {
            if (!ModList.get().isLoaded("hypcore")) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.RED + "[Hyper Lighting] " + TextFormatting.RESET + "Hyper Lighting Core is not installed. This light will just act like a normal light."));
            }
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187750_dc, SoundCategory.BLOCKS, 0.3f, 1.5f);
        }
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{POWERED});
    }

    public int func_149750_m(BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 8;
        }
        return 0;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
    }

    public static Light produceLight(BlockPos blockPos, BlockState blockState) {
        Random clr = new Random();
        Random rr = new Random();
        if (!tickers.containsKey(blockPos.func_185334_h())) {
            tickers.put(blockPos.func_185334_h(), 0);
        } else {
            Integer tick = tickers.get(blockPos.func_185334_h());
            tickers.replace(blockPos.func_185334_h(), tick + 1);
        }
        if (!discoColors.containsKey(blockPos.func_185334_h())) {
            HashMap<Vec3d, Integer> colorTick = new HashMap<Vec3d, Integer>();
            colorTick.put(new Vec3d((double)((float)clr.nextInt(255) / 255.0f), (double)((float)clr.nextInt(255) / 255.0f), (double)((float)clr.nextInt(255) / 255.0f)), rr.nextInt(10));
            discoColors.put(blockPos.func_185334_h(), colorTick);
        }
        HashMap entry = (HashMap)discoColors.get(blockPos.func_185334_h());
        Vec3d colorKeys = (Vec3d)entry.keySet().toArray()[0];
        Integer nextTick = (Integer)entry.values().toArray()[0];
        Integer tickCount = tickers.get(blockPos.func_185334_h());
        if (tickCount >= nextTick) {
            discoColors.remove(blockPos.func_185334_h());
            tickers.replace(blockPos.func_185334_h(), 0);
        }
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return Light.builder().pos(blockPos).color((float)colorKeys.field_72450_a, (float)colorKeys.field_72448_b, (float)colorKeys.field_72449_c, 1.0f).radius(10.0f).build();
        }
        return null;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) != worldIn.func_175640_z(pos)) {
            if (flag) {
                worldIn.func_205220_G_().func_205360_a(pos, (Object)this, 4);
            } else {
                worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
            }
        }
    }

    public void func_196267_b(BlockState state, World worldIn, BlockPos pos, Random random) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue() && !worldIn.func_175640_z(pos)) {
            worldIn.func_180501_a(pos, (BlockState)state.func_177231_a((IProperty)POWERED), 2);
        }
    }
}

