/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.blocks;

import java.util.Random;
import net.hypherionmc.hypcore.api.Light;
import net.hypherionmc.toggletorch.ConfigManager;
import net.hypherionmc.toggletorch.HyperLighting;
import net.hypherionmc.toggletorch.blocks.TorchBlockBase;
import net.hypherionmc.toggletorch.particles.ParticleEnum;
import net.hypherionmc.toggletorch.particles.ParticleHandler;
import net.hypherionmc.toggletorch.util.handlers.RegistryHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;

public class ToggleTorch
extends TorchBlockBase {
    private ParticleEnum particleEnum;
    public Integer particleEnumID;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<AttachFace> ATTACH_FLOOR_OR_WALL = EnumProperty.func_177706_a((String)"face", AttachFace.class, (Enum[])new AttachFace[]{AttachFace.FLOOR, AttachFace.WALL});
    protected static final VoxelShape STANDING_AABB = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    protected static final VoxelShape TORCH_NORTH_AABB = Block.func_208617_a((double)5.5, (double)3.0, (double)11.0, (double)10.5, (double)13.0, (double)16.0);
    protected static final VoxelShape TORCH_SOUTH_AABB = Block.func_208617_a((double)5.5, (double)3.0, (double)0.0, (double)10.5, (double)13.0, (double)5.0);
    protected static final VoxelShape TORCH_WEST_AABB = Block.func_208617_a((double)11.0, (double)3.0, (double)5.5, (double)16.0, (double)13.0, (double)10.5);
    protected static final VoxelShape TORCH_EAST_AABB = Block.func_208617_a((double)0.0, (double)3.0, (double)5.5, (double)5.0, (double)13.0, (double)10.5);

    public ToggleTorch(String name, ParticleEnum particleEnum) {
        super(Block.Properties.func_200945_a((Material)Material.field_151581_o));
        this.particleEnum = particleEnum;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)HORIZONTAL_FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false))).func_206870_a(ATTACH_FLOOR_OR_WALL, (Comparable)AttachFace.FLOOR));
        RegistryHandler.ITEMS.register(name, () -> new BlockItem((Block)this, new Item.Properties().func_200916_a(HyperLighting.HYPERLIGHTS)));
        this.particleEnumID = this.particleEnum.getParticleID();
        if (ModList.get().isLoaded("hypcore")) {
            InterModComms.sendTo((String)"hypcore", (String)"addBlockProvider", () -> this);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((AttachFace)state.func_177229_b(ATTACH_FLOOR_OR_WALL)) {
            default: {
                return STANDING_AABB;
            }
            case WALL: 
        }
        switch ((Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING)) {
            case EAST: {
                return TORCH_EAST_AABB;
            }
            case WEST: {
                return TORCH_WEST_AABB;
            }
            case SOUTH: {
                return TORCH_SOUTH_AABB;
            }
        }
        return TORCH_NORTH_AABB;
    }

    public boolean func_220051_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (!player.func_184586_b(Hand.MAIN_HAND).func_190926_b() && player.func_184586_b(Hand.MAIN_HAND).func_77973_b() == RegistryHandler.TORCH_LIGHTER.get()) {
            state = (BlockState)state.func_177231_a((IProperty)POWERED);
            boolean flag = (Boolean)state.func_177229_b((IProperty)POWERED);
            worldIn.func_180501_a(pos, state, 3);
            if (!flag) {
                worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.3f, 1.0f);
            }
            return true;
        }
        return false;
    }

    private void addParticles(BlockState state, IWorld worldIn, BlockPos pos, float alpha) {
        Direction direction = (Direction)state.func_177229_b((IProperty)HORIZONTAL_FACING);
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.7;
        double d2 = (double)pos.func_177952_p() + 0.5;
        double d3 = 0.22;
        double d4 = 0.27;
        if (state.func_177229_b(ATTACH_FLOOR_OR_WALL) == AttachFace.WALL) {
            Direction direction1 = direction.func_176734_d();
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleHandler.DEFAULT_FLAME.get(), d0 + 0.27 * (double)direction1.func_82601_c(), d1 + 0.22, d2 + 0.27 * (double)direction1.func_82599_e(), (double)this.particleEnum.getRedFloat(), (double)this.particleEnum.getGreenFloat(), (double)this.particleEnum.getBlueFloat());
        } else {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
            worldIn.func_195594_a((IParticleData)ParticleHandler.DEFAULT_FLAME.get(), d0, d1, d2, (double)this.particleEnum.getRedFloat(), (double)this.particleEnum.getGreenFloat(), (double)this.particleEnum.getBlueFloat());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)POWERED)).booleanValue()) {
            this.addParticles(stateIn, (IWorld)worldIn, pos, 0.5f);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{ATTACH_FLOOR_OR_WALL, HORIZONTAL_FACING, POWERED});
    }

    public int func_149750_m(BlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            return 14;
        }
        return 0;
    }

    public static Light produceLight(BlockPos blockPos, BlockState blockState, Object obj) {
        ParticleEnum part = ParticleEnum.getParticleFromId((Integer)obj);
        if (((Boolean)blockState.func_177229_b((IProperty)POWERED)).booleanValue() && ConfigManager.enableTorch()) {
            return Light.builder().pos(blockPos).color(part.getRedFloat(), part.getGreenFloat(), part.getBlueFloat(), 1.0f).radius(14.0f).build();
        }
        return null;
    }
}

