/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.particles;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public enum ParticleEnum {
    DEFAULT_FLAME("default", 0, 255.0f, 165.0f, 0.0f),
    GREEN_FLAME("green_flame", 1, 0.0f, 170.0f, 0.0f),
    BLUE_FLAME("blue_flame", 2, 0.0f, 0.0f, 170.0f),
    RED_FLAME("red_flame", 3, 170.0f, 0.0f, 0.0f),
    PURPLE_FLAME("purple_flame", 4, 170.0f, 0.0f, 170.0f),
    WHITE_FLAME("white_flame", 5, 255.0f, 255.0f, 255.0f),
    PINK_FLAME("pink_flame", 6, 255.0f, 20.0f, 147.0f),
    YELLOW_FLAME("yellow_flame", 7, 255.0f, 255.0f, 85.0f),
    LIME_FLAME("lime_flame", 8, 191.0f, 255.0f, 0.0f),
    BROWN_FLAME("brown_flame", 9, 150.0f, 75.0f, 0.0f),
    LIGHT_GRAY_FLAME("light_gray_flame", 10, 170.0f, 170.0f, 170.0f),
    GRAY_FLAME("gray_flame", 11, 85.0f, 85.0f, 85.0f),
    BLACK_FLAME("black_flame", 12, 0.0f, 0.0f, 0.0f);

    private final String particleName;
    private final int particleID;
    private float redFloat;
    private float greenFloat;
    private float blueFloat;
    private static final Map<Integer, ParticleEnum> PARTICLES;
    private static final Map<String, ParticleEnum> BY_NAME;

    private ParticleEnum(String particleNameIn, int particleIDIn, float redFloatIn, float greenFloatIn, float blueFloatIn) {
        this.particleName = particleNameIn;
        this.particleID = particleIDIn;
        this.redFloat = redFloatIn;
        this.greenFloat = greenFloatIn;
        this.blueFloat = blueFloatIn;
    }

    public static Set<String> getParticleNames() {
        return BY_NAME.keySet();
    }

    public String getParticleName() {
        return this.particleName;
    }

    public int getParticleID() {
        return this.particleID;
    }

    public float getRedFloat() {
        return this.redFloat / 255.0f;
    }

    public float getGreenFloat() {
        return this.greenFloat / 255.0f;
    }

    public float getBlueFloat() {
        return this.blueFloat / 255.0f;
    }

    @Nullable
    public static ParticleEnum getParticleFromId(int particleId) {
        return PARTICLES.get(particleId);
    }

    @Nullable
    public static ParticleEnum getByName(String nameIn) {
        return BY_NAME.get(nameIn);
    }

    static {
        PARTICLES = Maps.newHashMap();
        BY_NAME = Maps.newHashMap();
        for (ParticleEnum enumparticletypes : ParticleEnum.values()) {
            PARTICLES.put(enumparticletypes.getParticleID(), enumparticletypes);
            BY_NAME.put(enumparticletypes.getParticleName(), enumparticletypes);
        }
    }
}

