/*
 * Decompiled with CFR 0.152.
 */
package net.hypherionmc.toggletorch.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.hypherionmc.toggletorch.HyperLighting;
import net.hypherionmc.toggletorch.References;

public class UpdateEngine
implements Runnable {
    private static boolean isLatestVersion = false;
    private static int latestVersion;
    private static String updatetitle;
    private static String updatelink;

    @Override
    public void run() {
        HyperLighting.LOGGER.info("Starting update check");
        try {
            URL url = new URL("https://raw.githubusercontent.com/hypherionmc/hyperlighting_public/master/update_api/versions.json");
            InputStreamReader reader = new InputStreamReader(url.openStream());
            JsonElement object = new JsonParser().parse((Reader)reader);
            JsonObject skr = (JsonObject)object;
            if (skr.has("1.14.4")) {
                JsonObject thisVersion = skr.getAsJsonObject("1.14.4");
                updatetitle = thisVersion.get("title").getAsString();
                updatelink = thisVersion.get("link").getAsString();
                latestVersion = thisVersion.get("versioncode").getAsInt();
                if (latestVersion > References.VERSION) {
                    isLatestVersion = false;
                    HyperLighting.LOGGER.info("There is an update available. New Version: " + updatetitle);
                } else {
                    isLatestVersion = true;
                    HyperLighting.LOGGER.info("Mod appears to be up to date");
                }
                System.out.println("Title: " + updatetitle + " - Link: " + updatelink + " Latest: " + isLatestVersion);
            } else {
                isLatestVersion = true;
                HyperLighting.LOGGER.info("Mod appears to be up to date");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isLatestVersion() {
        return isLatestVersion;
    }

    public String getUpdateTitle() {
        return updatetitle;
    }

    public String getUpdatelink() {
        return updatelink;
    }

    static {
        updatetitle = "";
        updatelink = "";
    }
}

